/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.MockConnectorColumnHandle;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.execution.warnings.WarningCollector;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.connector.SortingProperty;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanAssert;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.sanity.ValidateLimitWithPresortedInput;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.SortItem;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.Test;

public class TestPartialTopNWithPresortedInput
extends BasePlanTest {
    private static final String MOCK_CATALOG = "mock_catalog";
    private static final String TEST_SCHEMA = "test_schema";
    private static final SchemaTableName tableA = new SchemaTableName("test_schema", "table_a");
    private static final String columnNameA = "col_a";
    private static final ColumnHandle columnHandleA = new MockConnectorColumnHandle("col_a", (Type)VarcharType.VARCHAR);
    private static final String columnNameB = "col_b";

    @Override
    protected LocalQueryRunner createLocalQueryRunner() {
        Session session = TestingSession.testSessionBuilder().setCatalog(MOCK_CATALOG).setSchema(TEST_SCHEMA).build();
        LocalQueryRunner queryRunner = LocalQueryRunner.builder((Session)session).build();
        MockConnectorFactory mockFactory = MockConnectorFactory.builder().withGetTableProperties((connectorSession, handle) -> {
            MockConnectorTableHandle tableHandle = (MockConnectorTableHandle)handle;
            if (tableHandle.getTableName().equals((Object)tableA)) {
                return new ConnectorTableProperties(TupleDomain.all(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new SortingProperty((Object)columnHandleA, SortOrder.ASC_NULLS_FIRST)));
            }
            throw new IllegalArgumentException();
        }).withGetColumns(schemaTableName -> {
            if (schemaTableName.equals((Object)tableA)) {
                return ImmutableList.of((Object)new ColumnMetadata(columnNameA, (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata(columnNameB, (Type)VarcharType.VARCHAR));
            }
            throw new IllegalArgumentException();
        }).build();
        queryRunner.createCatalog(MOCK_CATALOG, (ConnectorFactory)mockFactory, (Map)ImmutableMap.of());
        return queryRunner;
    }

    @Test
    public void testWithSortedTable() {
        ImmutableList orderBy = ImmutableList.of((Object)PlanMatchPattern.sort("t_col_a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST));
        this.assertPlanWithValidation("SELECT col_a FROM table_a ORDER BY 1 ASC NULLS FIRST LIMIT 10", PlanMatchPattern.output(PlanMatchPattern.topN(10L, (List<PlanMatchPattern.Ordering>)orderBy, TopNNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), PlanMatchPattern.limit(10L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), true, (List)orderBy.stream().map(PlanMatchPattern.Ordering::getField).collect(ImmutableList.toImmutableList()), PlanMatchPattern.tableScan("table_a", (Map<String, String>)ImmutableMap.of((Object)"t_col_a", (Object)columnNameA))))))));
        this.assertPlanWithValidation("SELECT col_a FROM table_a ORDER BY 1 ASC NULLS FIRST", PlanMatchPattern.output(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.tableScan("table_a", (Map<String, String>)ImmutableMap.of((Object)"t_col_a", (Object)columnNameA))))))));
        orderBy = ImmutableList.of((Object)PlanMatchPattern.sort("t_col_a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST));
        this.assertPlanWithValidation("SELECT col_a FROM table_a ORDER BY 1 ASC NULLS LAST LIMIT 10", PlanMatchPattern.output(PlanMatchPattern.topN(10L, (List<PlanMatchPattern.Ordering>)orderBy, TopNNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), PlanMatchPattern.topN(10L, (List<PlanMatchPattern.Ordering>)orderBy, TopNNode.Step.PARTIAL, PlanMatchPattern.tableScan("table_a", (Map<String, String>)ImmutableMap.of((Object)"t_col_a", (Object)columnNameA))))))));
    }

    @Test
    public void testWithSortedWindowFunction() {
        ImmutableList orderBy = ImmutableList.of((Object)PlanMatchPattern.sort(columnNameB, SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST));
        this.assertPlanWithValidation("SELECT col_b, COUNT(*) OVER (ORDER BY col_b) FROM table_a ORDER BY col_b LIMIT 5", PlanMatchPattern.output(PlanMatchPattern.topN(5L, (List<PlanMatchPattern.Ordering>)orderBy, TopNNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), PlanMatchPattern.limit(5L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), true, (List)orderBy.stream().map(PlanMatchPattern.Ordering::getField).collect(ImmutableList.toImmutableList()), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), PlanMatchPattern.window(p -> p.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)columnNameB), (Map<String, SortOrder>)ImmutableMap.of((Object)columnNameB, (Object)SortOrder.ASC_NULLS_LAST)), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("table_a", (Map<String, String>)ImmutableMap.of((Object)columnNameB, (Object)columnNameB))))))))));
    }

    @Test
    public void testWithConstantProperty() {
        this.assertPlanWithValidation("SELECT * FROM (VALUES (1), (1)) AS t (id) WHERE id = 1 ORDER BY 1 LIMIT 1", PlanMatchPattern.output(PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("id", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), true, (List<String>)ImmutableList.of((Object)"id"), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"id"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1")), (Object)ImmutableList.of((Object)new LongLiteral("1"))))))))));
    }

    private void assertPlanWithValidation(@Language(value="SQL") String sql, PlanMatchPattern pattern) {
        LocalQueryRunner queryRunner = this.getQueryRunner();
        queryRunner.inTransaction(queryRunner.getDefaultSession(), transactionSession -> {
            Plan actualPlan = queryRunner.createPlan(transactionSession, sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, false, WarningCollector.NOOP);
            PlanAssert.assertPlan(transactionSession, queryRunner.getMetadata(), queryRunner.getFunctionManager(), queryRunner.getStatsCalculator(), actualPlan, pattern);
            PlannerContext plannerContext = queryRunner.getPlannerContext();
            new ValidateLimitWithPresortedInput().validate(actualPlan.getRoot(), transactionSession, plannerContext, TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)plannerContext), actualPlan.getTypes(), WarningCollector.NOOP);
            return null;
        });
    }
}

