/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.connector.MockConnectorColumnHandle;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestRemoveEmptyUnionBranches
extends BasePlanTest {
    private static final String CATALOG_NAME = "test";
    private static final String SCHEMA_NAME = "default";
    private final Set<String> tables = ImmutableSet.of((Object)"table_one", (Object)"table_two", (Object)"table_three");
    private final List<String> columnNames = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
    private final String pushdownColumn = "c";
    private final Map<String, ColumnHandle> columnHandles = (Map)this.columnNames.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), name -> new MockConnectorColumnHandle((String)name, (Type)VarcharType.VARCHAR)));
    private final Map<SchemaTableName, ConnectorViewDefinition> views = ImmutableMap.of((Object)new SchemaTableName("default", "view_of_union"), (Object)new ConnectorViewDefinition("SELECT    t1.a, t1.b, t1.c FROM    table_one t1 WHERE    t1.c = 'X' UNION ALL SELECT    t2.a, t2.b, t2.c FROM    table_two t2 WHERE    t2.c = 'Y'", Optional.of("test"), Optional.of("default"), (List)this.columnNames.stream().map(name -> new ConnectorViewDefinition.ViewColumn(name, VarcharType.VARCHAR.getTypeId(), Optional.empty())).collect(ImmutableList.toImmutableList()), Optional.empty(), Optional.empty(), true));

    @Override
    protected LocalQueryRunner createLocalQueryRunner() {
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)TestingSession.testSessionBuilder().setCatalog(CATALOG_NAME).setSchema(SCHEMA_NAME).build());
        queryRunner.createCatalog(CATALOG_NAME, (ConnectorFactory)this.createConnectorFactory(CATALOG_NAME), (Map)ImmutableMap.of());
        return queryRunner;
    }

    private MockConnectorFactory createConnectorFactory(String catalogHandle) {
        return MockConnectorFactory.builder().withGetTableHandle((session, tableName) -> {
            if (tableName.getSchemaName().equals(SCHEMA_NAME) && this.tables.contains(tableName.getTableName())) {
                return new MockConnectorTableHandle((SchemaTableName)tableName);
            }
            return null;
        }).withGetViews((session, schemaName) -> this.views).withGetColumns(schemaTableName -> (List)this.columnNames.stream().map(name -> new ColumnMetadata(name, (Type)VarcharType.VARCHAR)).collect(ImmutableList.toImmutableList())).withGetTableProperties((session, handle) -> {
            MockConnectorTableHandle table = (MockConnectorTableHandle)handle;
            return new ConnectorTableProperties(table.getConstraint(), Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyList());
        }).withApplyFilter(this.applyFilter()).withName(catalogHandle).build();
    }

    private MockConnectorFactory.ApplyFilter applyFilter() {
        return (session, table, constraint) -> {
            MockConnectorTableHandle handle;
            SchemaTableName schemaTable;
            if (table instanceof MockConnectorTableHandle && (schemaTable = (handle = (MockConnectorTableHandle)table).getTableName()).getSchemaName().equals(SCHEMA_NAME) && this.tables.contains(schemaTable.getTableName())) {
                Predicate<ColumnHandle> shouldPushdown = columnHandle -> ((MockConnectorColumnHandle)columnHandle).getName().equals("c");
                TupleDomain<ColumnHandle> oldDomain = handle.getConstraint();
                TupleDomain newDomain = oldDomain.intersect(constraint.getSummary().filter((columnHandle, domain) -> shouldPushdown.test((ColumnHandle)columnHandle)));
                boolean nonePredicateOnPushdownColumn = this.discoveredNonePredicateOnPushdownColumn((TupleDomain<ColumnHandle>)newDomain, constraint);
                if (nonePredicateOnPushdownColumn) {
                    return Optional.of(new ConstraintApplicationResult((Object)new MockConnectorTableHandle(handle.getTableName(), (TupleDomain<ColumnHandle>)TupleDomain.none(), Optional.empty()), constraint.getSummary().filter((ch, domain) -> !shouldPushdown.test((ColumnHandle)ch)), false));
                }
                if (oldDomain.equals((Object)newDomain)) {
                    return Optional.empty();
                }
                return Optional.of(new ConstraintApplicationResult((Object)new MockConnectorTableHandle(handle.getTableName(), (TupleDomain<ColumnHandle>)newDomain, Optional.empty()), constraint.getSummary().filter((columnHandle, domain) -> !shouldPushdown.test((ColumnHandle)columnHandle)), false));
            }
            return Optional.empty();
        };
    }

    private boolean discoveredNonePredicateOnPushdownColumn(TupleDomain<ColumnHandle> domain, Constraint constraint) {
        Domain.DiscreteSet discreteSet;
        if (domain.isNone() || constraint.predicate().isEmpty()) {
            return false;
        }
        Domain pushdownColumnDomain = (Domain)((Map)domain.getDomains().get()).get(this.columnHandles.get("c"));
        Optional predicate = constraint.predicate();
        if (pushdownColumnDomain != null && pushdownColumnDomain.isNullableDiscreteSet() && (discreteSet = pushdownColumnDomain.getNullableDiscreteSet()) != null) {
            List nullableValues = (List)discreteSet.getNonNullValues().stream().map(object -> NullableValue.of((Type)VarcharType.VARCHAR, (Object)object)).collect(ImmutableList.toImmutableList());
            MockConnectorColumnHandle columnHandle = new MockConnectorColumnHandle("c", (Type)VarcharType.VARCHAR);
            return nullableValues.stream().allMatch(value -> !((Predicate)predicate.get()).test(ImmutableMap.of((Object)columnHandle, (Object)value)));
        }
        return false;
    }

    @Test
    public void testRemoveUnionBranches() {
        this.assertPlan("SELECT v1.a FROM view_of_union v1 JOIN table_three t3 ON v1.a = t3.a WHERE substring(v1.c, 1, 10) = 'Y' ", PlanMatchPattern.output(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("symbol_a", "symbol_a2").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("table_two", (Map<String, String>)ImmutableMap.of((Object)"symbol_a", (Object)"a", (Object)"symbol_c", (Object)"c")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("table_three", (Map<String, String>)ImmutableMap.of((Object)"symbol_a2", (Object)"a")))).build())));
    }
}

