/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.SessionTestUtils;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.server.ExpressionSerialization;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.AggregatedSetDescriptor;
import io.trino.sql.planner.rowpattern.AggregationValuePointer;
import io.trino.sql.planner.rowpattern.LogicalIndexExtractor;
import io.trino.sql.planner.rowpattern.LogicalIndexPointer;
import io.trino.sql.planner.rowpattern.ScalarValuePointer;
import io.trino.sql.planner.rowpattern.ValuePointer;
import io.trino.sql.planner.rowpattern.ir.IrConcatenation;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SkipTo;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.tree.WindowFrame;
import io.trino.type.InternalTypeManager;
import io.trino.type.TypeDeserializer;
import io.trino.type.TypeSignatureKeyDeserializer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Provider;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPatternRecognitionNodeSerialization {
    @Test
    public void testScalarValuePointerRoundtrip() {
        JsonCodec codec = new JsonCodecFactory((Provider)new ObjectMapperProvider()).jsonCodec(ValuePointer.class);
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(codec, new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of(), false, false, 5, 5), new Symbol("input_symbol")));
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(codec, new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("A"), (Object)new IrLabel("B")), true, true, 1, -1), new Symbol("input_symbol")));
    }

    @Test
    public void testAggregationValuePointerRoundtrip() {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setJsonSerializers((Map)ImmutableMap.of(Expression.class, (Object)new ExpressionSerialization.ExpressionSerializer()));
        provider.setJsonDeserializers((Map)ImmutableMap.of(Expression.class, (Object)new ExpressionSerialization.ExpressionDeserializer(new SqlParser()), Type.class, (Object)new TypeDeserializer(InternalTypeManager.TESTING_TYPE_MANAGER)));
        provider.setKeyDeserializers((Map)ImmutableMap.of(TypeSignature.class, (Object)new TypeSignatureKeyDeserializer()));
        JsonCodec codec = new JsonCodecFactory((Provider)provider).jsonCodec(ValuePointer.class);
        ResolvedFunction countFunction = MetadataManager.createTestMetadataManager().resolveFunction(SessionTestUtils.TEST_SESSION, QualifiedName.of((String)"count"), (List)ImmutableList.of());
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(codec, new AggregationValuePointer(countFunction, new AggregatedSetDescriptor((Set)ImmutableSet.of(), false), (List)ImmutableList.of(), new Symbol("classifier"), new Symbol("match_number")));
        ResolvedFunction maxFunction = MetadataManager.createTestMetadataManager().resolveFunction(SessionTestUtils.TEST_SESSION, QualifiedName.of((String)"max"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(codec, new AggregationValuePointer(maxFunction, new AggregatedSetDescriptor((Set)ImmutableSet.of((Object)new IrLabel("A"), (Object)new IrLabel("B")), true), (List)ImmutableList.of((Object)new NullLiteral()), new Symbol("classifier"), new Symbol("match_number")));
    }

    @Test
    public void testExpressionAndValuePointersRoundtrip() {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setJsonSerializers((Map)ImmutableMap.of(Expression.class, (Object)new ExpressionSerialization.ExpressionSerializer()));
        provider.setJsonDeserializers((Map)ImmutableMap.of(Expression.class, (Object)new ExpressionSerialization.ExpressionDeserializer(new SqlParser())));
        JsonCodec codec = new JsonCodecFactory((Provider)provider).jsonCodec(LogicalIndexExtractor.ExpressionAndValuePointers.class);
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(codec, new LogicalIndexExtractor.ExpressionAndValuePointers((Expression)new NullLiteral(), (List)ImmutableList.of(), (List)ImmutableList.of(), (Set)ImmutableSet.of(), (Set)ImmutableSet.of()));
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(codec, new LogicalIndexExtractor.ExpressionAndValuePointers((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("classifier"), (Expression)new SymbolReference("x")), (Expression)new FunctionCall(QualifiedName.of((String)"rand"), (List)ImmutableList.of()), (Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new SymbolReference("match_number"))), (List)ImmutableList.of((Object)new Symbol("classifier"), (Object)new Symbol("x"), (Object)new Symbol("match_number")), (List)ImmutableList.of((Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("A"), (Object)new IrLabel("B")), false, true, 1, -1), new Symbol("input_symbol_a")), (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("B")), true, false, 2, 1), new Symbol("input_symbol_a")), (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of(), true, true, 0, 0), new Symbol("input_symbol_a"))), (Set)ImmutableSet.of((Object)new Symbol("classifier")), (Set)ImmutableSet.of((Object)new Symbol("match_number"))));
    }

    @Test
    public void testMeasureRoundtrip() {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setJsonSerializers((Map)ImmutableMap.of(Expression.class, (Object)new ExpressionSerialization.ExpressionSerializer()));
        provider.setJsonDeserializers((Map)ImmutableMap.of(Expression.class, (Object)new ExpressionSerialization.ExpressionDeserializer(new SqlParser()), Type.class, (Object)new TypeDeserializer(InternalTypeManager.TESTING_TYPE_MANAGER)));
        JsonCodec codec = new JsonCodecFactory((Provider)provider).jsonCodec(PatternRecognitionNode.Measure.class);
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(codec, new PatternRecognitionNode.Measure(new LogicalIndexExtractor.ExpressionAndValuePointers((Expression)new NullLiteral(), (List)ImmutableList.of(), (List)ImmutableList.of(), (Set)ImmutableSet.of(), (Set)ImmutableSet.of()), (Type)BooleanType.BOOLEAN));
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(codec, new PatternRecognitionNode.Measure(new LogicalIndexExtractor.ExpressionAndValuePointers((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("match_number"), (Expression)new SymbolReference("x")), (Expression)new GenericLiteral("BIGINT", "10"), (Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new SymbolReference("y"))), (List)ImmutableList.of((Object)new Symbol("match_number"), (Object)new Symbol("x"), (Object)new Symbol("y")), (List)ImmutableList.of((Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of(), true, true, 0, 0), new Symbol("input_symbol_a")), (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("A")), false, true, 1, -1), new Symbol("input_symbol_a")), (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("B")), false, true, 1, -1), new Symbol("input_symbol_b"))), (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)new Symbol("match_number"))), (Type)BigintType.BIGINT));
    }

    @Test
    public void testPatternRecognitionNodeRoundtrip() {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setJsonSerializers((Map)ImmutableMap.of(Expression.class, (Object)new ExpressionSerialization.ExpressionSerializer()));
        provider.setJsonDeserializers((Map)ImmutableMap.of(Expression.class, (Object)new ExpressionSerialization.ExpressionDeserializer(new SqlParser()), Type.class, (Object)new TypeDeserializer(InternalTypeManager.TESTING_TYPE_MANAGER)));
        provider.setKeyDeserializers((Map)ImmutableMap.of(TypeSignature.class, (Object)new TypeSignatureKeyDeserializer()));
        JsonCodec codec = new JsonCodecFactory((Provider)provider).jsonCodec(PatternRecognitionNode.class);
        ResolvedFunction rankFunction = MetadataManager.createTestMetadataManager().resolveFunction(SessionTestUtils.TEST_SESSION, QualifiedName.of((String)"rank"), (List)ImmutableList.of());
        PatternRecognitionNode node = new PatternRecognitionNode(new PlanNodeId("0"), (PlanNode)new ValuesNode(new PlanNodeId("1"), 1), new DataOrganizationSpecification((List)ImmutableList.of(), Optional.empty()), Optional.empty(), (Set)ImmutableSet.of(), 0, (Map)ImmutableMap.of((Object)new Symbol("rank"), (Object)new WindowNode.Function(rankFunction, (List)ImmutableList.of(), new WindowNode.Frame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()), false)), (Map)ImmutableMap.of((Object)new Symbol("measure"), (Object)new PatternRecognitionNode.Measure(new LogicalIndexExtractor.ExpressionAndValuePointers((Expression)new NullLiteral(), (List)ImmutableList.of(), (List)ImmutableList.of(), (Set)ImmutableSet.of(), (Set)ImmutableSet.of()), (Type)BooleanType.BOOLEAN)), Optional.of(new WindowNode.Frame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())), PatternRecognitionRelation.RowsPerMatch.WINDOW, Optional.of(new IrLabel("B")), SkipTo.Position.LAST, true, (IrRowPattern)new IrConcatenation((List)ImmutableList.of((Object)new IrLabel("A"), (Object)new IrLabel("B"), (Object)new IrLabel("C"))), (Map)ImmutableMap.of((Object)new IrLabel("U"), (Object)ImmutableSet.of((Object)new IrLabel("A"), (Object)new IrLabel("B")), (Object)new IrLabel("V"), (Object)ImmutableSet.of((Object)new IrLabel("B"), (Object)new IrLabel("C"))), (Map)ImmutableMap.of((Object)new IrLabel("B"), (Object)new LogicalIndexExtractor.ExpressionAndValuePointers((Expression)new NullLiteral(), (List)ImmutableList.of(), (List)ImmutableList.of(), (Set)ImmutableSet.of(), (Set)ImmutableSet.of()), (Object)new IrLabel("C"), (Object)new LogicalIndexExtractor.ExpressionAndValuePointers((Expression)new NullLiteral(), (List)ImmutableList.of(), (List)ImmutableList.of(), (Set)ImmutableSet.of(), (Set)ImmutableSet.of())));
        PatternRecognitionNode roundtripNode = (PatternRecognitionNode)codec.fromJson(codec.toJson((Object)node));
        Assert.assertEquals((Map)roundtripNode.getMeasures(), (Map)node.getMeasures());
        Assert.assertEquals((Object)roundtripNode.getRowsPerMatch(), (Object)node.getRowsPerMatch());
        Assert.assertEquals((Object)roundtripNode.getSkipToLabel(), (Object)node.getSkipToLabel());
        Assert.assertEquals((Object)roundtripNode.getSkipToPosition(), (Object)node.getSkipToPosition());
        Assert.assertEquals((boolean)roundtripNode.isInitial(), (boolean)node.isInitial());
        Assert.assertEquals((Object)roundtripNode.getPattern(), (Object)node.getPattern());
        Assert.assertEquals((Map)roundtripNode.getSubsets(), (Map)node.getSubsets());
        Assert.assertEquals((Map)roundtripNode.getVariableDefinitions(), (Map)node.getVariableDefinitions());
    }

    public static <T> void assertJsonRoundTrip(JsonCodec<T> codec, T object) {
        String json = codec.toJson(object);
        Object copy = codec.fromJson(json);
        Assert.assertEquals((Object)copy, object);
    }
}

