/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.rowpattern;

import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.sql.planner.rowpattern.Patterns;
import io.trino.sql.planner.rowpattern.ir.IrQuantifier;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import java.util.Optional;
import javax.inject.Provider;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRowPatternSerialization {
    @Test
    public void testPatternQuantifierRoundtrip() {
        JsonCodec codec = new JsonCodecFactory((Provider)new ObjectMapperProvider()).jsonCodec(IrQuantifier.class);
        TestRowPatternSerialization.assertJsonRoundTrip(codec, IrQuantifier.zeroOrMore((boolean)true));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, IrQuantifier.zeroOrMore((boolean)false));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, IrQuantifier.oneOrMore((boolean)true));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, IrQuantifier.oneOrMore((boolean)false));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, IrQuantifier.zeroOrOne((boolean)true));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, IrQuantifier.zeroOrOne((boolean)false));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, IrQuantifier.range(Optional.empty(), Optional.empty(), (boolean)true));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, IrQuantifier.range(Optional.empty(), Optional.empty(), (boolean)false));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, IrQuantifier.range(Optional.of(5), Optional.empty(), (boolean)true));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, IrQuantifier.range(Optional.of(5), Optional.empty(), (boolean)false));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, IrQuantifier.range(Optional.empty(), Optional.of(5), (boolean)true));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, IrQuantifier.range(Optional.empty(), Optional.of(5), (boolean)false));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, IrQuantifier.range(Optional.of(5), Optional.of(10), (boolean)true));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, IrQuantifier.range(Optional.of(5), Optional.of(10), (boolean)false));
    }

    @Test
    public void testRowPatternRoundtrip() {
        JsonCodec codec = new JsonCodecFactory((Provider)new ObjectMapperProvider()).jsonCodec(IrRowPattern.class);
        TestRowPatternSerialization.assertJsonRoundTrip(codec, Patterns.start());
        TestRowPatternSerialization.assertJsonRoundTrip(codec, Patterns.end());
        TestRowPatternSerialization.assertJsonRoundTrip(codec, Patterns.empty());
        TestRowPatternSerialization.assertJsonRoundTrip(codec, Patterns.excluded(Patterns.empty()));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, Patterns.label("name"));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, Patterns.label(""));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, Patterns.label("^"));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, Patterns.label("$"));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, Patterns.alternation(Patterns.empty(), Patterns.empty(), Patterns.empty()));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, Patterns.concatenation(Patterns.empty(), Patterns.empty(), Patterns.empty()));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, Patterns.permutation(Patterns.empty(), Patterns.empty(), Patterns.empty()));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, Patterns.starQuantified(Patterns.empty(), true));
        TestRowPatternSerialization.assertJsonRoundTrip(codec, Patterns.concatenation(Patterns.alternation(Patterns.starQuantified(Patterns.start(), true), Patterns.plusQuantified(Patterns.end(), false), Patterns.questionMarkQuantified(Patterns.empty(), true)), Patterns.concatenation(new IrRowPattern[]{Patterns.excluded(Patterns.rangeQuantified(Patterns.empty(), 0, Optional.empty(), true)), Patterns.rangeQuantified((IrRowPattern)Patterns.label("name_0"), 5, Optional.empty(), false), Patterns.label("name_1")}), Patterns.permutation(Patterns.alternation(new IrRowPattern[]{Patterns.label("name_2"), Patterns.rangeQuantified((IrRowPattern)Patterns.label("name_3"), 0, Optional.of(5), true)}), Patterns.rangeQuantified(Patterns.concatenation(new IrRowPattern[]{Patterns.label("name_4"), Patterns.label("name_5")}), 5, Optional.of(10), false))));
    }

    public static <T> void assertJsonRoundTrip(JsonCodec<T> codec, T object) {
        String json = codec.toJson(object);
        Object copy = codec.fromJson(json);
        Assert.assertEquals((Object)copy, object);
    }
}

