/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.MockConnectorColumnHandle;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.connector.SortingProperty;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.sanity.ValidateLimitWithPresortedInput;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LongLiteral;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestValidateLimitWithPresortedInput
extends BasePlanTest {
    private final PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
    private static final String TEST_SCHEMA = "test_schema";
    private static final SchemaTableName MOCK_TABLE_NAME = new SchemaTableName("test_schema", "table_a");
    private static final String COLUMN_NAME_A = "col_a";
    private static final ColumnHandle COLUMN_HANDLE_A = new MockConnectorColumnHandle("col_a", (Type)VarcharType.VARCHAR);
    private static final String COLUMN_NAME_B = "col_b";
    private static final ColumnHandle COLUMN_HANDLE_B = new MockConnectorColumnHandle("col_b", (Type)VarcharType.VARCHAR);
    private static final String COLUMN_NAME_C = "col_c";
    private static final ColumnHandle COLUMN_HANDLE_C = new MockConnectorColumnHandle("col_c", (Type)VarcharType.VARCHAR);
    private TableHandle mockTableHandle;

    @Override
    protected LocalQueryRunner createLocalQueryRunner() {
        Session session = TestingSession.testSessionBuilder().setCatalog("test-catalog").setSchema(TEST_SCHEMA).build();
        LocalQueryRunner queryRunner = LocalQueryRunner.builder((Session)session).build();
        MockConnectorFactory mockFactory = MockConnectorFactory.builder().withGetTableProperties((connectorSession, handle) -> {
            MockConnectorTableHandle tableHandle = (MockConnectorTableHandle)handle;
            if (tableHandle.getTableName().equals((Object)MOCK_TABLE_NAME)) {
                return new ConnectorTableProperties(TupleDomain.all(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new SortingProperty((Object)COLUMN_HANDLE_A, SortOrder.ASC_NULLS_FIRST), (Object)new SortingProperty((Object)COLUMN_HANDLE_C, SortOrder.ASC_NULLS_FIRST)));
            }
            throw new IllegalArgumentException();
        }).withGetColumns(schemaTableName -> {
            if (schemaTableName.equals((Object)MOCK_TABLE_NAME)) {
                return ImmutableList.of((Object)new ColumnMetadata(COLUMN_NAME_A, (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata(COLUMN_NAME_B, (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata(COLUMN_NAME_C, (Type)VarcharType.VARCHAR));
            }
            throw new IllegalArgumentException();
        }).build();
        queryRunner.createCatalog("test-catalog", (ConnectorFactory)mockFactory, (Map)ImmutableMap.of());
        this.mockTableHandle = queryRunner.getTableHandle("test-catalog", MOCK_TABLE_NAME.getSchemaName(), MOCK_TABLE_NAME.getTableName());
        return queryRunner;
    }

    @Test
    public void testValidateSuccessful() {
        this.validatePlan(p -> p.limit(10L, (List<Symbol>)ImmutableList.of(), true, (List<Symbol>)ImmutableList.of((Object)p.symbol(COLUMN_NAME_A, (Type)VarcharType.VARCHAR), (Object)p.symbol(COLUMN_NAME_C, (Type)VarcharType.VARCHAR)), (PlanNode)p.tableScan(this.mockTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol(COLUMN_NAME_A, (Type)VarcharType.VARCHAR), (Object)p.symbol(COLUMN_NAME_B, (Type)VarcharType.VARCHAR), (Object)p.symbol(COLUMN_NAME_C, (Type)VarcharType.VARCHAR)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol(COLUMN_NAME_A, (Type)VarcharType.VARCHAR), (Object)COLUMN_HANDLE_A, (Object)p.symbol(COLUMN_NAME_B, (Type)VarcharType.VARCHAR), (Object)COLUMN_HANDLE_B, (Object)p.symbol(COLUMN_NAME_C, (Type)VarcharType.VARCHAR), (Object)COLUMN_HANDLE_C))));
        this.validatePlan(p -> p.limit(10L, (List<Symbol>)ImmutableList.of(), true, (List<Symbol>)ImmutableList.of((Object)p.symbol(COLUMN_NAME_A, (Type)VarcharType.VARCHAR)), (PlanNode)p.tableScan(this.mockTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol(COLUMN_NAME_A, (Type)VarcharType.VARCHAR), (Object)p.symbol(COLUMN_NAME_B, (Type)VarcharType.VARCHAR), (Object)p.symbol(COLUMN_NAME_C, (Type)VarcharType.VARCHAR)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol(COLUMN_NAME_A, (Type)VarcharType.VARCHAR), (Object)COLUMN_HANDLE_A, (Object)p.symbol(COLUMN_NAME_B, (Type)VarcharType.VARCHAR), (Object)COLUMN_HANDLE_B, (Object)p.symbol(COLUMN_NAME_C, (Type)VarcharType.VARCHAR), (Object)COLUMN_HANDLE_C))));
    }

    @Test
    public void testValidateConstantProperty() {
        this.validatePlan(p -> p.limit(10L, (List<Symbol>)ImmutableList.of(), true, (List<Symbol>)ImmutableList.of((Object)p.symbol("a", (Type)BigintType.BIGINT)), (PlanNode)p.filter(PlanBuilder.expression("a = BIGINT '1'"), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a", (Type)BigintType.BIGINT)), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1")), (Object)ImmutableList.of((Object)new LongLiteral("1")))))));
    }

    @Test
    public void testValidateFailed() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.validatePlan(p -> p.limit(10L, (List<Symbol>)ImmutableList.of(), true, (List<Symbol>)ImmutableList.of((Object)p.symbol(COLUMN_NAME_B, (Type)VarcharType.VARCHAR)), (PlanNode)p.tableScan(this.mockTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol(COLUMN_NAME_A, (Type)VarcharType.VARCHAR), (Object)p.symbol(COLUMN_NAME_B, (Type)VarcharType.VARCHAR)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol(COLUMN_NAME_A, (Type)VarcharType.VARCHAR), (Object)COLUMN_HANDLE_A, (Object)p.symbol(COLUMN_NAME_B, (Type)VarcharType.VARCHAR), (Object)COLUMN_HANDLE_B))))).isInstanceOf(VerifyException.class)).hasMessageMatching("\\QExpected Limit input to be sorted by: [col_b], but was [S\u2191\u2190(col_a)]\\E");
    }

    private void validatePlan(Function<PlanBuilder, PlanNode> planProvider) {
        LocalQueryRunner queryRunner = this.getQueryRunner();
        PlanBuilder builder = new PlanBuilder(this.idAllocator, queryRunner.getMetadata(), queryRunner.getDefaultSession());
        PlanNode planNode = planProvider.apply(builder);
        TypeProvider types = builder.getTypes();
        queryRunner.inTransaction(session -> {
            session.getCatalog().ifPresent(catalog -> queryRunner.getMetadata().getCatalogHandle(session, catalog));
            TypeAnalyzer typeAnalyzer = TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)queryRunner.getPlannerContext());
            new ValidateLimitWithPresortedInput().validate(planNode, session, queryRunner.getPlannerContext(), typeAnalyzer, types, WarningCollector.NOOP);
            return null;
        });
    }
}

