/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.connector.MockConnectorFactory;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.TableHandle;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.sanity.ValidateScaledWritersUsage;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingTransactionHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestValidateScaledWritersUsage
extends BasePlanTest {
    private LocalQueryRunner queryRunner;
    private PlannerContext plannerContext;
    private PlanBuilder planBuilder;
    private Symbol symbol;
    private TableScanNode tableScanNode;
    private CatalogHandle catalogSupportingScaledWriters;
    private CatalogHandle catalogNotSupportingScaledWriters;
    private SchemaTableName schemaTableName;

    @BeforeClass
    public void setup() {
        this.schemaTableName = new SchemaTableName("any", "any");
        this.catalogSupportingScaledWriters = TestingHandles.createTestCatalogHandle((String)"bytes_written_reported");
        this.catalogNotSupportingScaledWriters = TestingHandles.createTestCatalogHandle((String)"no_bytes_written_reported");
        this.queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);
        this.queryRunner.createCatalog(this.catalogSupportingScaledWriters.getCatalogName(), (ConnectorFactory)this.createConnectorFactorySupportingReportingBytesWritten(true, this.catalogSupportingScaledWriters.getCatalogName()), (Map)ImmutableMap.of());
        this.queryRunner.createCatalog(this.catalogNotSupportingScaledWriters.getCatalogName(), (ConnectorFactory)this.createConnectorFactorySupportingReportingBytesWritten(false, this.catalogNotSupportingScaledWriters.getCatalogName()), (Map)ImmutableMap.of());
        this.plannerContext = this.queryRunner.getPlannerContext();
        this.planBuilder = new PlanBuilder(new PlanNodeIdAllocator(), this.plannerContext.getMetadata(), SessionTestUtils.TEST_SESSION);
        TableHandle nationTableHandle = new TableHandle(this.catalogSupportingScaledWriters, (ConnectorTableHandle)new TpchTableHandle("sf1", "nation", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create());
        TpchColumnHandle nationkeyColumnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.symbol = new Symbol("nationkey");
        this.tableScanNode = this.planBuilder.tableScan(nationTableHandle, (List<Symbol>)ImmutableList.of((Object)this.symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)this.symbol, (Object)nationkeyColumnHandle));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.queryRunner.close();
        this.queryRunner = null;
        this.plannerContext = null;
        this.planBuilder = null;
        this.tableScanNode = null;
        this.catalogSupportingScaledWriters = null;
        this.catalogNotSupportingScaledWriters = null;
    }

    private MockConnectorFactory createConnectorFactorySupportingReportingBytesWritten(boolean supportsWrittenBytes, String name) {
        return MockConnectorFactory.builder().withSupportsReportingWrittenBytes(supportsWrittenBytes).withGetTableHandle((session, schemaTableName) -> null).withName(name).build();
    }

    @Test(dataProvider="scaledWriterPartitioningHandles")
    public void testScaledWritersUsedAndTargetSupportsIt(PartitioningHandle scaledWriterPartitionHandle) {
        ExchangeNode tableWriterSource = this.planBuilder.exchange(ex -> ex.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)scaledWriterPartitionHandle, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode))));
        OutputNode root = this.planBuilder.output(arg_0 -> this.lambda$testScaledWritersUsedAndTargetSupportsIt$3((PlanNode)tableWriterSource, arg_0));
        this.validatePlan((PlanNode)root);
    }

    @Test(dataProvider="scaledWriterPartitioningHandles")
    public void testScaledWritersUsedAndTargetDoesNotSupportReportingWrittenBytes(PartitioningHandle scaledWriterPartitionHandle) {
        ExchangeNode tableWriterSource = this.planBuilder.exchange(ex -> ex.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)scaledWriterPartitionHandle, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode))));
        OutputNode root = this.planBuilder.output(arg_0 -> this.lambda$testScaledWritersUsedAndTargetDoesNotSupportReportingWrittenBytes$6((PlanNode)tableWriterSource, arg_0));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testScaledWritersUsedAndTargetDoesNotSupportReportingWrittenBytes$7((PlanNode)root)).isInstanceOf(IllegalStateException.class)).hasMessage("The scaled writer partitioning scheme is set but writer target no_bytes_written_reported:INSTANCE doesn't support reporting physical written bytes");
    }

    @Test(dataProvider="scaledWriterPartitioningHandles")
    public void testScaledWritersWithMultipleSourceExchangesAndTargetDoesNotSupportReportingWrittenBytes(PartitioningHandle scaledWriterPartitionHandle) {
        ExchangeNode tableWriterSource = this.planBuilder.exchange(ex -> ex.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol, (Object)this.symbol))).addInputsSet(this.symbol, this.symbol).addInputsSet(this.symbol, this.symbol).addSource((PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)scaledWriterPartitionHandle, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode))).addSource((PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode))));
        OutputNode root = this.planBuilder.output(arg_0 -> this.lambda$testScaledWritersWithMultipleSourceExchangesAndTargetDoesNotSupportReportingWrittenBytes$11((PlanNode)tableWriterSource, arg_0));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testScaledWritersWithMultipleSourceExchangesAndTargetDoesNotSupportReportingWrittenBytes$12((PlanNode)root)).isInstanceOf(IllegalStateException.class)).hasMessage("The scaled writer partitioning scheme is set but writer target no_bytes_written_reported:INSTANCE doesn't support reporting physical written bytes");
    }

    @Test(dataProvider="scaledWriterPartitioningHandles")
    public void testScaledWritersWithMultipleSourceExchangesAndTargetSupportIt(PartitioningHandle scaledWriterPartitionHandle) {
        ExchangeNode tableWriterSource = this.planBuilder.exchange(ex -> ex.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol, (Object)this.symbol))).addInputsSet(this.symbol, this.symbol).addInputsSet(this.symbol, this.symbol).addSource((PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)scaledWriterPartitionHandle, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode))).addSource((PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode))));
        OutputNode root = this.planBuilder.output(arg_0 -> this.lambda$testScaledWritersWithMultipleSourceExchangesAndTargetSupportIt$16((PlanNode)tableWriterSource, arg_0));
        this.validatePlan((PlanNode)root);
    }

    @Test(dataProvider="scaledWriterPartitioningHandles")
    public void testScaledWritersUsedAboveTableWriterInThePlanTree(PartitioningHandle scaledWriterPartitionHandle) {
        ExchangeNode tableWriterSource = this.planBuilder.exchange(ex -> ex.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode))));
        OutputNode root = this.planBuilder.output(arg_0 -> this.lambda$testScaledWritersUsedAboveTableWriterInThePlanTree$19((PlanNode)tableWriterSource, scaledWriterPartitionHandle, arg_0));
        this.validatePlan((PlanNode)root);
    }

    @Test(dataProvider="scaledWriterPartitioningHandles")
    public void testScaledWritersTwoTableWritersNodes(PartitioningHandle scaledWriterPartitionHandle) {
        ExchangeNode tableWriterSource = this.planBuilder.exchange(ex -> ex.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.planBuilder.tableWriter((List<Symbol>)ImmutableList.of((Object)this.symbol), (List<String>)ImmutableList.of((Object)"column_a"), Optional.empty(), Optional.empty(), (TableWriterNode.WriterTarget)this.planBuilder.createTarget(this.catalogSupportingScaledWriters, this.schemaTableName, true, true), (PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)scaledWriterPartitionHandle, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode)), this.symbol)));
        OutputNode root = this.planBuilder.output(arg_0 -> this.lambda$testScaledWritersTwoTableWritersNodes$22((PlanNode)tableWriterSource, arg_0));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testScaledWritersTwoTableWritersNodes$23((PlanNode)root)).isInstanceOf(IllegalStateException.class)).hasMessage("The scaled writer partitioning scheme is set but writer target no_bytes_written_reported:INSTANCE doesn't support reporting physical written bytes");
    }

    @Test(dataProvider="scaledWriterPartitioningHandles")
    public void testScaledWriterUsedAndTargetDoesNotSupportMultipleWritersPerPartition(PartitioningHandle scaledWriterPartitionHandle) {
        ExchangeNode tableWriterSource = this.planBuilder.exchange(ex -> ex.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)scaledWriterPartitionHandle, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode))));
        OutputNode root = this.planBuilder.output(arg_0 -> this.lambda$testScaledWriterUsedAndTargetDoesNotSupportMultipleWritersPerPartition$26((PlanNode)tableWriterSource, arg_0));
        if (scaledWriterPartitionHandle == SystemPartitioningHandle.SCALED_WRITER_ROUND_ROBIN_DISTRIBUTION) {
            this.validatePlan((PlanNode)root);
        } else {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testScaledWriterUsedAndTargetDoesNotSupportMultipleWritersPerPartition$27((PlanNode)root)).isInstanceOf(IllegalStateException.class)).hasMessage("The scaled writer partitioning scheme is set for the partitioned write but writer target no_bytes_written_reported:INSTANCE doesn't support multiple writers per partition");
        }
    }

    @Test(dataProvider="scaledWriterPartitioningHandles")
    public void testScaledWriterWithMultipleSourceExchangesAndTargetDoesNotSupportMultipleWritersPerPartition(PartitioningHandle scaledWriterPartitionHandle) {
        ExchangeNode tableWriterSource = this.planBuilder.exchange(ex -> ex.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol, (Object)this.symbol))).addInputsSet(this.symbol, this.symbol).addInputsSet(this.symbol, this.symbol).addSource((PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)scaledWriterPartitionHandle, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode))).addSource((PlanNode)this.planBuilder.exchange(innerExchange -> innerExchange.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))).addInputsSet(this.symbol).addSource((PlanNode)this.tableScanNode))));
        OutputNode root = this.planBuilder.output(arg_0 -> this.lambda$testScaledWriterWithMultipleSourceExchangesAndTargetDoesNotSupportMultipleWritersPerPartition$31((PlanNode)tableWriterSource, arg_0));
        if (scaledWriterPartitionHandle == SystemPartitioningHandle.SCALED_WRITER_ROUND_ROBIN_DISTRIBUTION) {
            this.validatePlan((PlanNode)root);
        } else {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testScaledWriterWithMultipleSourceExchangesAndTargetDoesNotSupportMultipleWritersPerPartition$32((PlanNode)root)).isInstanceOf(IllegalStateException.class)).hasMessage("The scaled writer partitioning scheme is set for the partitioned write but writer target no_bytes_written_reported:INSTANCE doesn't support multiple writers per partition");
        }
    }

    @DataProvider
    public Object[][] scaledWriterPartitioningHandles() {
        return new Object[][]{{SystemPartitioningHandle.SCALED_WRITER_ROUND_ROBIN_DISTRIBUTION}, {SystemPartitioningHandle.SCALED_WRITER_HASH_DISTRIBUTION}, {new PartitioningHandle(Optional.of(TestingHandles.TEST_CATALOG_HANDLE), Optional.of(new ConnectorTransactionHandle(){}), new ConnectorPartitioningHandle(){}, true)}};
    }

    private void validatePlan(PlanNode root) {
        this.queryRunner.inTransaction(session -> {
            this.plannerContext.getMetadata().getCatalogHandle(session, this.catalogSupportingScaledWriters.getCatalogName());
            this.plannerContext.getMetadata().getCatalogHandle(session, this.catalogNotSupportingScaledWriters.getCatalogName());
            new ValidateScaledWritersUsage().validate(root, session, this.plannerContext, TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)this.plannerContext), TypeProvider.empty(), WarningCollector.NOOP);
            return null;
        });
    }

    private /* synthetic */ void lambda$testScaledWriterWithMultipleSourceExchangesAndTargetDoesNotSupportMultipleWritersPerPartition$32(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }

    private /* synthetic */ void lambda$testScaledWriterWithMultipleSourceExchangesAndTargetDoesNotSupportMultipleWritersPerPartition$31(PlanNode tableWriterSource, PlanBuilder.OutputBuilder outputBuilder) {
        outputBuilder.source((PlanNode)this.planBuilder.tableWithExchangeCreate((TableWriterNode.WriterTarget)this.planBuilder.createTarget(this.catalogNotSupportingScaledWriters, this.schemaTableName, true, false), tableWriterSource, this.symbol, new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))));
    }

    private /* synthetic */ void lambda$testScaledWriterUsedAndTargetDoesNotSupportMultipleWritersPerPartition$27(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }

    private /* synthetic */ void lambda$testScaledWriterUsedAndTargetDoesNotSupportMultipleWritersPerPartition$26(PlanNode tableWriterSource, PlanBuilder.OutputBuilder outputBuilder) {
        outputBuilder.source((PlanNode)this.planBuilder.tableWithExchangeCreate((TableWriterNode.WriterTarget)this.planBuilder.createTarget(this.catalogNotSupportingScaledWriters, this.schemaTableName, true, false), tableWriterSource, this.symbol, new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))));
    }

    private /* synthetic */ void lambda$testScaledWritersTwoTableWritersNodes$23(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }

    private /* synthetic */ void lambda$testScaledWritersTwoTableWritersNodes$22(PlanNode tableWriterSource, PlanBuilder.OutputBuilder outputBuilder) {
        outputBuilder.source((PlanNode)this.planBuilder.tableWithExchangeCreate((TableWriterNode.WriterTarget)this.planBuilder.createTarget(this.catalogNotSupportingScaledWriters, this.schemaTableName, false, true), tableWriterSource, this.symbol, new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))));
    }

    private /* synthetic */ void lambda$testScaledWritersUsedAboveTableWriterInThePlanTree$19(PlanNode tableWriterSource, PartitioningHandle scaledWriterPartitionHandle, PlanBuilder.OutputBuilder outputBuilder) {
        outputBuilder.source((PlanNode)this.planBuilder.tableWithExchangeCreate((TableWriterNode.WriterTarget)this.planBuilder.createTarget(this.catalogNotSupportingScaledWriters, this.schemaTableName, false, true), tableWriterSource, this.symbol, new PartitioningScheme(Partitioning.create((PartitioningHandle)scaledWriterPartitionHandle, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))));
    }

    private /* synthetic */ void lambda$testScaledWritersWithMultipleSourceExchangesAndTargetSupportIt$16(PlanNode tableWriterSource, PlanBuilder.OutputBuilder outputBuilder) {
        outputBuilder.source((PlanNode)this.planBuilder.tableWithExchangeCreate((TableWriterNode.WriterTarget)this.planBuilder.createTarget(this.catalogSupportingScaledWriters, this.schemaTableName, true, true), tableWriterSource, this.symbol, new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))));
    }

    private /* synthetic */ void lambda$testScaledWritersWithMultipleSourceExchangesAndTargetDoesNotSupportReportingWrittenBytes$12(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }

    private /* synthetic */ void lambda$testScaledWritersWithMultipleSourceExchangesAndTargetDoesNotSupportReportingWrittenBytes$11(PlanNode tableWriterSource, PlanBuilder.OutputBuilder outputBuilder) {
        outputBuilder.source((PlanNode)this.planBuilder.tableWithExchangeCreate((TableWriterNode.WriterTarget)this.planBuilder.createTarget(this.catalogNotSupportingScaledWriters, this.schemaTableName, false, true), tableWriterSource, this.symbol, new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))));
    }

    private /* synthetic */ void lambda$testScaledWritersUsedAndTargetDoesNotSupportReportingWrittenBytes$7(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }

    private /* synthetic */ void lambda$testScaledWritersUsedAndTargetDoesNotSupportReportingWrittenBytes$6(PlanNode tableWriterSource, PlanBuilder.OutputBuilder outputBuilder) {
        outputBuilder.source((PlanNode)this.planBuilder.tableWithExchangeCreate((TableWriterNode.WriterTarget)this.planBuilder.createTarget(this.catalogNotSupportingScaledWriters, this.schemaTableName, false, true), tableWriterSource, this.symbol, new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))));
    }

    private /* synthetic */ void lambda$testScaledWritersUsedAndTargetSupportsIt$3(PlanNode tableWriterSource, PlanBuilder.OutputBuilder outputBuilder) {
        outputBuilder.source((PlanNode)this.planBuilder.tableWithExchangeCreate((TableWriterNode.WriterTarget)this.planBuilder.createTarget(this.catalogSupportingScaledWriters, this.schemaTableName, true, true), tableWriterSource, this.symbol, new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)this.symbol))));
    }
}

