/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.trino.Session;
import io.trino.cost.StatsCalculator;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.OperatorNameUtil;
import io.trino.security.AccessControl;
import io.trino.spi.Plugin;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.assertions.PlanAssert;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.transaction.TransactionBuilder;
import io.trino.transaction.TransactionManager;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.CanIgnoreReturnValue;
import org.intellij.lang.annotations.Language;

public class QueryAssertions
implements Closeable {
    private final QueryRunner runner;

    public QueryAssertions() {
        this(TestingSession.testSessionBuilder().setCatalog("test-catalog").setSchema("default").build());
    }

    public QueryAssertions(Session session) {
        this((QueryRunner)LocalQueryRunner.create((Session)session));
    }

    public QueryAssertions(QueryRunner runner) {
        this.runner = Objects.requireNonNull(runner, "runner is null");
    }

    public Session.SessionBuilder sessionBuilder() {
        return Session.builder((Session)this.runner.getDefaultSession());
    }

    public Session getDefaultSession() {
        return this.runner.getDefaultSession();
    }

    public void addFunctions(FunctionBundle functionBundle) {
        this.runner.addFunctions(functionBundle);
    }

    public void addPlugin(Plugin plugin) {
        this.runner.installPlugin(plugin);
    }

    public AssertProvider<QueryAssert> query(@Language(value="SQL") String query) {
        return this.query(this.runner.getDefaultSession(), query);
    }

    public AssertProvider<QueryAssert> query(Session session, @Language(value="SQL") String query) {
        return QueryAssert.newQueryAssert(query, this.runner, session);
    }

    public ExpressionAssertProvider expression(@Language(value="SQL") String expression) {
        return this.expression(expression, this.runner.getDefaultSession());
    }

    public ExpressionAssertProvider operator(OperatorType operator, String ... arguments) {
        return this.function(OperatorNameUtil.mangleOperatorName((OperatorType)operator), arguments);
    }

    public ExpressionAssertProvider function(String name, List<String> arguments) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < arguments.size(); ++i) {
            builder.add((Object)("a" + i));
        }
        ImmutableList names = builder.build();
        ExpressionAssertProvider assertion = this.expression("\"%s\"(%s)".formatted(name, String.join((CharSequence)",", (Iterable<? extends CharSequence>)names)));
        for (int i = 0; i < arguments.size(); ++i) {
            assertion.binding((String)names.get(i), arguments.get(i));
        }
        return assertion;
    }

    public ExpressionAssertProvider function(String name, String ... arguments) {
        return this.function(name, Arrays.asList(arguments));
    }

    public ExpressionAssertProvider expression(@Language(value="SQL") String expression, Session session) {
        return new ExpressionAssertProvider(this.runner, session, expression);
    }

    public void assertQueryAndPlan(@Language(value="SQL") String actual, @Language(value="SQL") String expected, PlanMatchPattern pattern) {
        this.assertQuery(this.runner.getDefaultSession(), actual, expected, false);
        Plan plan = this.runner.executeWithPlan(this.runner.getDefaultSession(), actual, WarningCollector.NOOP).getQueryPlan();
        PlanAssert.assertPlan(this.runner.getDefaultSession(), this.runner.getMetadata(), this.runner.getFunctionManager(), this.runner.getStatsCalculator(), plan, pattern);
    }

    private void assertQuery(Session session, @Language(value="SQL") String actual, @Language(value="SQL") String expected, boolean ensureOrdering) {
        MaterializedResult actualResults = null;
        try {
            actualResults = this.execute(session, actual);
        }
        catch (RuntimeException ex) {
            org.junit.jupiter.api.Assertions.fail((String)("Execution of 'actual' query failed: " + actual), (Throwable)ex);
        }
        MaterializedResult expectedResults = null;
        try {
            expectedResults = this.execute(expected);
        }
        catch (RuntimeException ex) {
            org.junit.jupiter.api.Assertions.fail((String)("Execution of 'expected' query failed: " + expected), (Throwable)ex);
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResults.getTypes(), (Object)actualResults.getTypes(), (String)("Types mismatch for query: \n " + actual + "\n:"));
        List actualRows = actualResults.getMaterializedRows();
        List expectedRows = expectedResults.getMaterializedRows();
        if (ensureOrdering) {
            if (!actualRows.equals(expectedRows)) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRows, (Object)actualRows, (String)("For query: \n " + actual + "\n:"));
            }
        } else {
            io.airlift.testing.Assertions.assertEqualsIgnoreOrder((Iterable)actualRows, (Iterable)expectedRows, (String)("For query: \n " + actual));
        }
    }

    public void assertQueryReturnsEmptyResult(@Language(value="SQL") String actual) {
        MaterializedResult actualResults = null;
        try {
            actualResults = this.execute(actual);
        }
        catch (RuntimeException ex) {
            org.junit.jupiter.api.Assertions.fail((String)("Execution of 'actual' query failed: " + actual), (Throwable)ex);
        }
        List actualRows = actualResults.getMaterializedRows();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)actualRows.size());
    }

    public MaterializedResult execute(@Language(value="SQL") String query) {
        return this.execute(this.runner.getDefaultSession(), query);
    }

    public MaterializedResult execute(Session session, @Language(value="SQL") String query) {
        MaterializedResult actualResults = this.runner.execute(session, query).toTestTypes();
        return actualResults;
    }

    @Override
    public void close() {
        this.runner.close();
    }

    public QueryRunner getQueryRunner() {
        return this.runner;
    }

    protected void executeExclusively(Runnable executionBlock) {
        this.runner.getExclusiveLock().lock();
        try {
            executionBlock.run();
        }
        finally {
            this.runner.getExclusiveLock().unlock();
        }
    }

    public static class QueryAssert
    extends AbstractAssert<QueryAssert, MaterializedResult> {
        private static final Representation ROWS_REPRESENTATION = new StandardRepresentation(){

            public String toStringOf(Object object) {
                if (object instanceof List) {
                    List list = (List)object;
                    return list.stream().map(this::toStringOf).collect(Collectors.joining(", "));
                }
                if (object instanceof MaterializedRow) {
                    MaterializedRow row = (MaterializedRow)object;
                    return row.getFields().stream().map(this::formatRowElement).collect(Collectors.joining(", ", "(", ")"));
                }
                return super.toStringOf(object);
            }

            private String formatRowElement(Object value) {
                if (value == null) {
                    return "null";
                }
                if (value.getClass().isArray()) {
                    return this.formatArray(value);
                }
                return String.valueOf(value);
            }
        };
        private final QueryRunner runner;
        private final Session session;
        private final String query;
        private boolean ordered;
        private boolean skipTypesCheck;
        private boolean skipResultsCorrectnessCheckForPushdown;

        static AssertProvider<QueryAssert> newQueryAssert(String query, QueryRunner runner, Session session) {
            MaterializedResult result = runner.execute(session, query);
            return () -> new QueryAssert(runner, session, query, result, false, false, false);
        }

        private QueryAssert(QueryRunner runner, Session session, String query, MaterializedResult actual, boolean ordered, boolean skipTypesCheck, boolean skipResultsCorrectnessCheckForPushdown) {
            super((Object)actual, Object.class);
            this.runner = Objects.requireNonNull(runner, "runner is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.query = Objects.requireNonNull(query, "query is null");
            this.ordered = ordered;
            this.skipTypesCheck = skipTypesCheck;
            this.skipResultsCorrectnessCheckForPushdown = skipResultsCorrectnessCheckForPushdown;
        }

        public QueryAssert exceptColumns(String ... columnNamesToExclude) {
            this.validateIfColumnsPresent(columnNamesToExclude);
            Preconditions.checkArgument((columnNamesToExclude.length > 0 ? 1 : 0) != 0, (Object)"At least one column must be excluded");
            Preconditions.checkArgument((columnNamesToExclude.length < ((MaterializedResult)this.actual).getColumnNames().size() ? 1 : 0) != 0, (Object)"All columns cannot be excluded");
            return this.projected(((Predicate<String>)Set.of(columnNamesToExclude)::contains).negate());
        }

        public QueryAssert projected(String ... columnNamesToInclude) {
            this.validateIfColumnsPresent(columnNamesToInclude);
            Preconditions.checkArgument((columnNamesToInclude.length > 0 ? 1 : 0) != 0, (Object)"At least one column must be projected");
            return this.projected(Set.of(columnNamesToInclude)::contains);
        }

        private QueryAssert projected(Predicate<String> columnFilter) {
            List columnNames = ((MaterializedResult)this.actual).getColumnNames();
            HashMap<Integer, String> columnsIndexToNameMap = new HashMap<Integer, String>();
            for (int i = 0; i < columnNames.size(); ++i) {
                String columnName = (String)columnNames.get(i);
                if (!columnFilter.test(columnName)) continue;
                columnsIndexToNameMap.put(i, columnName);
            }
            return new QueryAssert(this.runner, this.session, String.format("%s projected with %s", this.query, columnsIndexToNameMap.values()), new MaterializedResult((List)((MaterializedResult)this.actual).getMaterializedRows().stream().map(row -> new MaterializedRow(row.getPrecision(), columnsIndexToNameMap.keySet().stream().map(arg_0 -> ((MaterializedRow)row).getField(arg_0)).collect(Collectors.toList()))).collect(ImmutableList.toImmutableList()), (List)columnsIndexToNameMap.keySet().stream().map(((MaterializedResult)this.actual).getTypes()::get).collect(ImmutableList.toImmutableList())), this.ordered, this.skipTypesCheck, this.skipResultsCorrectnessCheckForPushdown);
        }

        private void validateIfColumnsPresent(String ... columns) {
            ImmutableSet columnNames = ImmutableSet.copyOf((Collection)((MaterializedResult)this.actual).getColumnNames());
            Arrays.stream(columns).forEach(arg_0 -> QueryAssert.lambda$validateIfColumnsPresent$2((Set)columnNames, arg_0));
        }

        public QueryAssert matches(BiFunction<Session, QueryRunner, MaterializedResult> evaluator) {
            MaterializedResult expected = evaluator.apply(this.session, this.runner);
            return this.matches(expected);
        }

        public QueryAssert ordered() {
            this.ordered = true;
            return this;
        }

        public QueryAssert skippingTypesCheck() {
            this.skipTypesCheck = true;
            return this;
        }

        public QueryAssert skipResultsCorrectnessCheckForPushdown() {
            this.skipResultsCorrectnessCheckForPushdown = true;
            return this;
        }

        @CanIgnoreReturnValue
        public QueryAssert matches(@Language(value="SQL") String query) {
            MaterializedResult expected = this.runner.execute(this.session, query);
            return this.matches(expected);
        }

        @CanIgnoreReturnValue
        public QueryAssert matches(MaterializedResult expected) {
            return (QueryAssert)this.satisfies(new ThrowingConsumer[]{actual -> {
                if (!this.skipTypesCheck) {
                    QueryAssert.assertTypes(this.query, actual, expected.getTypes());
                }
                ListAssert assertion = (ListAssert)((ListAssert)Assertions.assertThat((List)actual.getMaterializedRows()).as("Rows for query [%s]", new Object[]{this.query})).withRepresentation(ROWS_REPRESENTATION);
                if (this.ordered) {
                    assertion.containsExactlyElementsOf((Iterable)expected.getMaterializedRows());
                } else {
                    assertion.containsExactlyInAnyOrderElementsOf((Iterable)expected.getMaterializedRows());
                }
            }});
        }

        @CanIgnoreReturnValue
        public QueryAssert matches(PlanMatchPattern expectedPlan) {
            TransactionBuilder.transaction((TransactionManager)this.runner.getTransactionManager(), (AccessControl)this.runner.getAccessControl()).execute(this.session, session -> {
                Plan plan = this.runner.createPlan(session, this.query, WarningCollector.NOOP);
                PlanAssert.assertPlan(session, this.runner.getMetadata(), this.runner.getFunctionManager(), StatsCalculator.noopStatsCalculator(), plan, expectedPlan);
            });
            return this;
        }

        @CanIgnoreReturnValue
        public QueryAssert containsAll(@Language(value="SQL") String query) {
            MaterializedResult expected = this.runner.execute(this.session, query);
            return this.containsAll(expected);
        }

        @CanIgnoreReturnValue
        public QueryAssert containsAll(MaterializedResult expected) {
            return (QueryAssert)this.satisfies(new ThrowingConsumer[]{actual -> {
                if (!this.skipTypesCheck) {
                    QueryAssert.assertTypes(this.query, actual, expected.getTypes());
                }
                ((ListAssert)((ListAssert)Assertions.assertThat((List)actual.getMaterializedRows()).as("Rows for query [%s]", new Object[]{this.query})).withRepresentation(ROWS_REPRESENTATION)).containsAll((Iterable)expected.getMaterializedRows());
            }});
        }

        @CanIgnoreReturnValue
        public QueryAssert hasOutputTypes(List<Type> expectedTypes) {
            return (QueryAssert)this.satisfies(new ThrowingConsumer[]{actual -> QueryAssert.assertTypes(this.query, actual, expectedTypes)});
        }

        @CanIgnoreReturnValue
        public QueryAssert outputHasType(int index, Type expectedType) {
            return (QueryAssert)this.satisfies(new ThrowingConsumer[]{actual -> ((ObjectAssert)((ListAssert)Assertions.assertThat((List)actual.getTypes()).as("Output types for query [%s]", new Object[]{this.query})).element(index)).isEqualTo((Object)expectedType)});
        }

        private static void assertTypes(String query, MaterializedResult actual, List<Type> expectedTypes) {
            ((ListAssert)Assertions.assertThat((List)actual.getTypes()).as("Output types for query [%s]", new Object[]{query})).isEqualTo(expectedTypes);
        }

        @CanIgnoreReturnValue
        public QueryAssert returnsEmptyResult() {
            return (QueryAssert)this.satisfies(new ThrowingConsumer[]{actual -> ((ListAssert)Assertions.assertThat((List)actual.getMaterializedRows()).as("Rows for query [%s]", new Object[]{this.query})).isEmpty()});
        }

        @CanIgnoreReturnValue
        public QueryAssert isFullyPushedDown() {
            Preconditions.checkState((!(this.runner instanceof LocalQueryRunner) ? 1 : 0) != 0, (Object)"isFullyPushedDown() currently does not work with LocalQueryRunner");
            TransactionBuilder.transaction((TransactionManager)this.runner.getTransactionManager(), (AccessControl)this.runner.getAccessControl()).execute(this.session, session -> {
                Plan plan = this.runner.createPlan(session, this.query, WarningCollector.NOOP);
                PlanAssert.assertPlan(session, this.runner.getMetadata(), this.runner.getFunctionManager(), StatsCalculator.noopStatsCalculator(), plan, PlanMatchPattern.output(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])));
            });
            if (!this.skipResultsCorrectnessCheckForPushdown) {
                this.hasCorrectResultsRegardlessOfPushdown();
            }
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final QueryAssert isNotFullyPushedDown(Class<? extends PlanNode> firstRetainedNode, Class<? extends PlanNode> ... moreRetainedNodes) {
            PlanMatchPattern expectedPlan = PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]);
            List retainedNodes = Lists.asList(firstRetainedNode, (Object[])moreRetainedNodes);
            for (Class retainedNode : ImmutableList.copyOf((Collection)retainedNodes).reverse()) {
                expectedPlan = PlanMatchPattern.node(retainedNode, expectedPlan);
            }
            return this.isNotFullyPushedDown(expectedPlan);
        }

        @CanIgnoreReturnValue
        public QueryAssert isNotFullyPushedDown(PlanMatchPattern retainedSubplan) {
            PlanMatchPattern expectedPlan = PlanMatchPattern.anyTree(retainedSubplan);
            return this.hasPlan(expectedPlan, plan -> {
                if (PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).whereIsInstanceOfAny(new Class[]{TableScanNode.class}).findFirst().isEmpty()) {
                    throw new IllegalArgumentException("Incorrect use of isNotFullyPushedDown: the actual plan matched the expected despite not having a TableScanNode left in the plan. Use hasPlan() instead");
                }
            });
        }

        @CanIgnoreReturnValue
        public QueryAssert joinIsNotFullyPushedDown() {
            return this.verifyPlan(plan -> {
                if (PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).whereIsInstanceOfAny(new Class[]{JoinNode.class}).findFirst().isEmpty()) {
                    throw new IllegalStateException("Join node should be present in explain plan, when pushdown is not applied");
                }
            });
        }

        @CanIgnoreReturnValue
        public QueryAssert hasPlan(PlanMatchPattern expectedPlan) {
            return this.hasPlan(expectedPlan, plan -> {});
        }

        private QueryAssert hasPlan(PlanMatchPattern expectedPlan, Consumer<Plan> additionalPlanVerification) {
            TransactionBuilder.transaction((TransactionManager)this.runner.getTransactionManager(), (AccessControl)this.runner.getAccessControl()).execute(this.session, session -> {
                Plan plan = this.runner.createPlan(session, this.query, WarningCollector.NOOP);
                PlanAssert.assertPlan(session, this.runner.getMetadata(), this.runner.getFunctionManager(), StatsCalculator.noopStatsCalculator(), plan, expectedPlan);
                additionalPlanVerification.accept(plan);
            });
            if (!this.skipResultsCorrectnessCheckForPushdown) {
                this.hasCorrectResultsRegardlessOfPushdown();
            }
            return this;
        }

        private QueryAssert verifyPlan(Consumer<Plan> planVerification) {
            TransactionBuilder.transaction((TransactionManager)this.runner.getTransactionManager(), (AccessControl)this.runner.getAccessControl()).execute(this.session, session -> {
                Plan plan = this.runner.createPlan(session, this.query, WarningCollector.NOOP);
                planVerification.accept(plan);
            });
            if (!this.skipResultsCorrectnessCheckForPushdown) {
                this.hasCorrectResultsRegardlessOfPushdown();
            }
            return this;
        }

        @CanIgnoreReturnValue
        public QueryAssert hasCorrectResultsRegardlessOfPushdown() {
            Session withoutPushdown = Session.builder((Session)this.session).setSystemProperty("allow_pushdown_into_connectors", "false").build();
            this.matches(this.runner.execute(withoutPushdown, this.query));
            return this;
        }

        private static /* synthetic */ void lambda$validateIfColumnsPresent$2(Set columnNames, String column) {
            Preconditions.checkArgument((boolean)columnNames.contains(column), (Object)"[%s] column is not present in %s".formatted(column, columnNames));
        }
    }

    public static class ExpressionAssertProvider
    implements AssertProvider<ExpressionAssert> {
        private final QueryRunner runner;
        private final String expression;
        private final Session session;
        private final Map<String, String> bindings = new HashMap<String, String>();

        public ExpressionAssertProvider(QueryRunner runner, Session session, String expression) {
            this.runner = runner;
            this.session = session;
            this.expression = expression;
        }

        public ExpressionAssertProvider binding(String variable, @Language(value="SQL") String value) {
            String previous = this.bindings.put(variable, value);
            if (previous != null) {
                org.junit.jupiter.api.Assertions.fail((String)"%s already bound to: %s".formatted(variable, value));
            }
            return this;
        }

        public Result evaluate() {
            if (this.bindings.isEmpty()) {
                return this.run("VALUES ROW(%s)".formatted(this.expression));
            }
            ImmutableList entries = ImmutableList.copyOf(this.bindings.entrySet());
            List columns = entries.stream().map(Map.Entry::getKey).collect(Collectors.toList());
            List values = entries.stream().map(Map.Entry::getValue).collect(Collectors.toList());
            Result full = this.run("SELECT %s\nFROM (\n    VALUES ROW(%s)\n) t(%s)\nWHERE rand() >= 0\n".formatted(this.expression, Joiner.on((String)",").join(values), Joiner.on((String)",").join(columns)));
            Result withConstantFolding = this.run("SELECT %s\nFROM (\n    VALUES ROW(%s)\n) t(%s)\n".formatted(this.expression, Joiner.on((String)",").join(values), Joiner.on((String)",").join(columns)));
            if (!full.type().equals(withConstantFolding.type())) {
                org.junit.jupiter.api.Assertions.fail((String)"Mismatched types between interpreter and evaluation engine: %s vs %s".formatted(full.type(), withConstantFolding.type()));
            }
            if (!Objects.equals(full.value(), withConstantFolding.value())) {
                org.junit.jupiter.api.Assertions.fail((String)"Mismatched results between interpreter and evaluation engine: %s vs %s".formatted(full.value(), withConstantFolding.value()));
            }
            return new Result(full.type(), full.value);
        }

        private Result run(String query) {
            MaterializedResult result = this.runner.execute(this.session, query);
            return new Result((Type)result.getTypes().get(0), result.getOnlyColumnAsSet().iterator().next());
        }

        public ExpressionAssert assertThat() {
            Result result = this.evaluate();
            return (ExpressionAssert)new ExpressionAssert(this.runner, this.session, result.value(), result.type()).withRepresentation((Representation)ExpressionAssert.TYPE_RENDERER);
        }

        record Result(Type type, Object value) {
        }
    }

    public static class ExpressionAssert
    extends AbstractAssert<ExpressionAssert, Object> {
        private static final StandardRepresentation TYPE_RENDERER = new StandardRepresentation(){

            public String toStringOf(Object object) {
                if (object instanceof SqlTimestamp) {
                    SqlTimestamp timestamp = (SqlTimestamp)object;
                    return String.format("%s [p = %s, epochMicros = %s, fraction = %s]", timestamp, timestamp.getPrecision(), timestamp.getEpochMicros(), timestamp.getPicosOfMicros());
                }
                if (object instanceof SqlTimestampWithTimeZone) {
                    SqlTimestampWithTimeZone timestamp = (SqlTimestampWithTimeZone)object;
                    return String.format("%s [p = %s, epochMillis = %s, fraction = %s, tz = %s]", timestamp, timestamp.getPrecision(), timestamp.getEpochMillis(), timestamp.getPicosOfMilli(), timestamp.getTimeZoneKey());
                }
                if (object instanceof SqlTime) {
                    SqlTime time = (SqlTime)object;
                    return String.format("%s [picos = %s]", time, time.getPicos());
                }
                if (object instanceof SqlTimeWithTimeZone) {
                    SqlTimeWithTimeZone time = (SqlTimeWithTimeZone)object;
                    return String.format("%s [picos = %s, offset = %s]", time, time.getPicos(), time.getOffsetMinutes());
                }
                return Objects.toString(object);
            }
        };
        private final QueryRunner runner;
        private final Session session;
        private final Type actualType;

        public ExpressionAssert(QueryRunner runner, Session session, Object actual, Type actualType) {
            super(actual, Object.class);
            this.runner = runner;
            this.session = session;
            this.actualType = actualType;
        }

        public ExpressionAssert isEqualTo(BiFunction<Session, QueryRunner, Object> evaluator) {
            return (ExpressionAssert)this.isEqualTo(evaluator.apply(this.session, this.runner));
        }

        public ExpressionAssert matches(@Language(value="SQL") String expression) {
            MaterializedResult result = this.runner.execute(this.session, "VALUES " + expression);
            Type expectedType = (Type)result.getTypes().get(0);
            Object expectedValue = result.getOnlyColumnAsSet().iterator().next();
            return (ExpressionAssert)this.satisfies(new ThrowingConsumer[]{actual -> {
                ((ObjectAssert)Assertions.assertThat((Object)this.actualType).as("Type", new Object[0])).isEqualTo((Object)expectedType);
                ((ObjectAssert)Assertions.assertThat((Object)actual).withRepresentation((Representation)TYPE_RENDERER)).isEqualTo(expectedValue);
            }});
        }

        public void isNull(Type type) {
            this.hasType(type).isNull();
        }

        public ExpressionAssert hasType(Type type) {
            this.objects.assertEqual((AssertionInfo)this.info, (Object)this.actualType, (Object)type);
            return this;
        }
    }
}

