/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.base.Throwables;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.SqlFunction;
import io.trino.operator.scalar.ApplyFunction;
import io.trino.operator.scalar.InvokeFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.Convention;
import io.trino.spi.function.FunctionDependency;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.IntegerType;
import io.trino.sql.query.QueryAssertions;
import java.lang.invoke.MethodHandle;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestConventionDependencies {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
        this.assertions.addFunctions((FunctionBundle)InternalFunctionBundle.builder().scalar(RegularConvention.class).scalar(BlockPositionConvention.class).scalar(Add.class).build());
        this.assertions.addFunctions((FunctionBundle)new InternalFunctionBundle(new SqlFunction[]{ApplyFunction.APPLY_FUNCTION, InvokeFunction.INVOKE_FUNCTION}));
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testConventionDependencies() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regular_convention", "1", "1")))).isEqualTo(2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regular_convention", "50", "10")))).isEqualTo(60);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regular_convention", "1", "0")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("block_position_convention", "ARRAY[1, 2, 3]")))).isEqualTo(6);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("block_position_convention", "ARRAY[25, 0, 5]")))).isEqualTo(30);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("block_position_convention", "ARRAY[56, 275, 36]")))).isEqualTo(367);
    }

    @ScalarFunction(value="regular_convention")
    public static final class RegularConvention {
        @SqlType(value="integer")
        public static long testRegularConvention(@FunctionDependency(name="add", argumentTypes={"integer", "integer"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle function, @SqlType(value="integer") long left, @SqlType(value="integer") long right) {
            try {
                return function.invokeExact(left, right);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
    }

    @ScalarFunction(value="block_position_convention")
    public static final class BlockPositionConvention {
        @SqlType(value="integer")
        public static long testBlockPositionConvention(@FunctionDependency(name="add", argumentTypes={"integer", "integer"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle function, @SqlType(value="array(integer)") Block array) {
            long sum = 0L;
            for (int i = 0; i < array.getPositionCount(); ++i) {
                try {
                    sum = function.invokeExact(sum, array, i);
                    continue;
                }
                catch (Throwable t) {
                    Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                    Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
                }
            }
            return sum;
        }
    }

    @ScalarFunction(value="add")
    public static final class Add {
        @SqlType(value="integer")
        public static long add(@SqlType(value="integer") long left, @SqlType(value="integer") long right) {
            return Math.addExact((int)left, (int)right);
        }

        @SqlType(value="integer")
        public static long addBlockPosition(@SqlType(value="integer") long first, @BlockPosition @SqlType(value="integer", nativeContainerType=long.class) Block block, @BlockIndex int position) {
            return Math.addExact((int)first, (int)IntegerType.INTEGER.getLong(block, position));
        }
    }
}

