/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.lang.invoke.MethodHandle;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.testng.Assert;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestDoubleOperators {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testLiteral() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("37.7E0")))).isEqualTo(37.7);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("17.1E0")))).isEqualTo(17.1);
    }

    @Test
    public void testTypeConstructor() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DOUBLE '12.34'")))).isEqualTo(12.34);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DOUBLE '-17.6'")))).isEqualTo(-17.6);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DOUBLE '+754'")))).isEqualTo(754.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DOUBLE 'NaN'")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DOUBLE '-NaN'")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DOUBLE PRECISION '12.34'")))).isEqualTo(12.34);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DOUBLE PRECISION '-17.6'")))).isEqualTo(-17.6);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DOUBLE PRECISION '+754'")))).isEqualTo(754.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DOUBLE PRECISION 'NaN'")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DOUBLE PRECISION '-NaN'")))).isEqualTo(Double.NaN);
    }

    @Test
    public void testAdd() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "37.7E0", "37.7E0")))).isEqualTo(75.4);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "37.7E0", "17.1E0")))).isEqualTo(54.800000000000004);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "17.1E0", "37.7E0")))).isEqualTo(54.800000000000004);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "17.1E0", "17.1E0")))).isEqualTo(34.2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DOUBLE 'NaN'", "37.7E0")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "37.7E0", "DOUBLE 'NaN'")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DOUBLE 'NaN'", "DOUBLE '-NaN'")))).isEqualTo(Double.NaN);
    }

    @Test
    public void testSubtract() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "37.7E0", "37.7E0")))).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "37.7E0", "17.1E0")))).isEqualTo(20.6);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "17.1E0", "37.7E0")))).isEqualTo(-20.6);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "17.1E0", "17.1E0")))).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DOUBLE 'NaN'", "37.7E0")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "37.7E0", "DOUBLE 'NaN'")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DOUBLE 'NaN'", "DOUBLE 'NaN'")))).isEqualTo(Double.NaN);
    }

    @Test
    public void testMultiply() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "37.7E0", "37.7E0")))).isEqualTo(1421.2900000000002);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "37.7E0", "17.1E0")))).isEqualTo(644.6700000000001);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "17.1E0", "37.7E0")))).isEqualTo(644.6700000000001);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "17.1E0", "17.1E0")))).isEqualTo(292.41);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DOUBLE 'NaN'", "37.7E0")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "37.7E0", "DOUBLE 'NaN'")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DOUBLE 'NaN'", "DOUBLE '-NaN'")))).isEqualTo(Double.NaN);
    }

    @Test
    public void testDivide() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "37.7E0", "37.7E0")))).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "37.7E0", "17.1E0")))).isEqualTo(2.2046783625730995);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "17.1E0", "37.7E0")))).isEqualTo(0.4535809018567639);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "17.1E0", "17.1E0")))).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DOUBLE 'NaN'", "37.7E0")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "37.7E0", "DOUBLE 'NaN'")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DOUBLE 'NaN'", "DOUBLE '-NaN'")))).isEqualTo(Double.NaN);
    }

    @Test
    public void testModulus() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "37.7E0", "37.7E0")))).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "37.7E0", "17.1E0")))).isEqualTo(3.5);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "17.1E0", "37.7E0")))).isEqualTo(17.1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "17.1E0", "17.1E0")))).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DOUBLE 'NaN'", "37.7E0")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "37.7E0", "DOUBLE 'NaN'")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DOUBLE 'NaN'", "DOUBLE 'NaN'")))).isEqualTo(Double.NaN);
    }

    @Test
    public void testNegation() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "(37.7E0)")))).isEqualTo(-37.7);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "(17.1E0)")))).isEqualTo(-17.1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "DOUBLE 'NaN'")))).isEqualTo(Double.NaN);
    }

    @Test
    public void testEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "37.7E0", "37.7E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "37.7E0", "17.1E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "17.1E0", "37.7E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "17.1E0", "17.1E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "0E0", "-0E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DOUBLE 'NaN'", "37.7E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "37.7E0", "DOUBLE 'NaN'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DOUBLE 'NaN'", "DOUBLE 'NaN'")))).isEqualTo(false);
    }

    @Test
    public void testNotEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "37.7E0").binding("b", "37.7E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "37.7E0").binding("b", "17.1E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "17.1E0").binding("b", "37.7E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "17.1E0").binding("b", "17.1E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "DOUBLE 'NaN'").binding("b", "37.7E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "37.7E0").binding("b", "DOUBLE 'NaN'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "DOUBLE 'NaN'").binding("b", "DOUBLE 'NaN'")))).isEqualTo(true);
    }

    @Test
    public void testLessThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "37.7E0", "37.7E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "37.7E0", "17.1E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "17.1E0", "37.7E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "17.1E0", "17.1E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DOUBLE 'NaN'", "37.7E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "37.7E0", "DOUBLE 'NaN'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DOUBLE 'NaN'", "DOUBLE 'NaN'")))).isEqualTo(false);
    }

    @Test
    public void testLessThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "37.7E0", "37.7E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "37.7E0", "17.1E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "17.1E0", "37.7E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "17.1E0", "17.1E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DOUBLE 'NaN'", "37.7E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "37.7E0", "DOUBLE 'NaN'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DOUBLE 'NaN'", "DOUBLE 'NaN'")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "37.7E0").binding("b", "37.7E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "37.7E0").binding("b", "17.1E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "17.1E0").binding("b", "37.7E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "17.1E0").binding("b", "17.1E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DOUBLE 'NaN'").binding("b", "37.7E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "37.7E0").binding("b", "DOUBLE 'NaN'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DOUBLE 'NaN'").binding("b", "DOUBLE 'NaN'")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "37.7E0").binding("b", "37.7E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "37.7E0").binding("b", "17.1E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "17.1E0").binding("b", "37.7E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "17.1E0").binding("b", "17.1E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DOUBLE 'NaN'").binding("b", "37.7E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "37.7E0").binding("b", "DOUBLE 'NaN'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DOUBLE 'NaN'").binding("b", "DOUBLE 'NaN'")))).isEqualTo(false);
    }

    @Test
    public void testBetween() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "37.7E0").binding("low", "37.7E0").binding("high", "37.7E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "37.7E0").binding("low", "37.7E0").binding("high", "17.1E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "37.7E0").binding("low", "17.1E0").binding("high", "37.7E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "37.7E0").binding("low", "17.1E0").binding("high", "17.1E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "17.1E0").binding("low", "37.7E0").binding("high", "37.7E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "17.1E0").binding("low", "37.7E0").binding("high", "17.1E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "17.1E0").binding("low", "17.1E0").binding("high", "37.7E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "17.1E0").binding("low", "17.1E0").binding("high", "17.1E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DOUBLE 'NaN'").binding("low", "17.1E0").binding("high", "37.7E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "17.1E0").binding("low", "DOUBLE '-NaN'").binding("high", "DOUBLE 'NaN'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "17.1E0").binding("low", "DOUBLE 'NaN'").binding("high", "DOUBLE '-NaN'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "17.1E0").binding("low", "17.1E0").binding("high", "DOUBLE 'NaN'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DOUBLE 'NaN'").binding("low", "DOUBLE 'NaN'").binding("high", "DOUBLE 'NaN'")))).isEqualTo(false);
    }

    @Test
    public void testCastToVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar)").binding("a", "37.7E0")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("3.77E1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar)").binding("a", "17.1E0")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1.71E1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(0E0 / 0E0 AS varchar)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("NaN");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(6))").binding("a", "12e2")))).hasType((Type)VarcharType.createVarcharType((int)6)).isEqualTo("1.2E3");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(50))").binding("a", "12e2")))).hasType((Type)VarcharType.createVarcharType((int)50)).isEqualTo("1.2E3");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(50))").binding("a", "12345678.9e0")))).hasType((Type)VarcharType.createVarcharType((int)50)).isEqualTo("1.23456789E7");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(3))").binding("a", "DOUBLE 'NaN'")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("NaN");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(50))").binding("a", "DOUBLE 'Infinity'")))).hasType((Type)VarcharType.createVarcharType((int)50)).isEqualTo("Infinity");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(5))").binding("a", "12e2")))).hasType((Type)VarcharType.createVarcharType((int)5)).isEqualTo("1.2E3");
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as varchar(4))").binding("a", "12e2").evaluate()).hasMessage("Value 1200.0 (1.2E3) cannot be represented as varchar(4)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as varchar(2))").binding("a", "0e0").evaluate()).hasMessage("Value 0.0 (0E0) cannot be represented as varchar(2)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as varchar(3))").binding("a", "-0e0").evaluate()).hasMessage("Value -0.0 (-0E0) cannot be represented as varchar(3)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(0e0 / 0e0 AS varchar(2))").evaluate()).hasMessage("Value NaN (NaN) cannot be represented as varchar(2)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as varchar(7))").binding("a", "DOUBLE 'Infinity'").evaluate()).hasMessage("Value Infinity (Infinity) cannot be represented as varchar(7)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testCastToBigint() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", "37.7E0")))).isEqualTo(38L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", "-37.7E0")))).isEqualTo(-38L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", "17.1E0")))).isEqualTo(17L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", "-17.1E0")))).isEqualTo(-17L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", "9.2E18")))).isEqualTo(9200000000000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", "-9.2E18")))).isEqualTo(-9200000000000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", "2.21E9")))).isEqualTo(2210000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", "-2.21E9")))).isEqualTo(-2210000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", "17.5E0")))).isEqualTo(18L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", "-17.5E0")))).isEqualTo(-18L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", Double.toString(Math.nextDown(9.223372036854776E18)))))).isEqualTo((long)Math.nextDown(9.223372036854776E18));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as bigint)").binding("a", Double.toString(9.223372036854776E18)).evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as bigint)").binding("a", Double.toString(Math.nextUp(9.223372036854776E18))).evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as bigint)").binding("a", Double.toString(Math.nextDown(-9.223372036854776E18))).evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", Double.toString(-9.223372036854776E18))))).isEqualTo(Long.MIN_VALUE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", Double.toString(Math.nextUp(-9.223372036854776E18)))))).isEqualTo((long)Math.nextUp(-9.223372036854776E18));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as bigint)").binding("a", "9.3E18").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as bigint)").binding("a", "-9.3E18").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as bigint)").binding("a", "infinity()").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as bigint)").binding("a", "-infinity()").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as bigint)").binding("a", "nan()").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testCastNaN() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as integer)").binding("a", "nan()").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as smallint)").binding("a", "nan()").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as tinyint)").binding("a", "nan()").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as real)").binding("a", "nan()")))).isEqualTo(Float.valueOf(Float.NaN));
    }

    @Test
    public void testCastToBoolean() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as boolean)").binding("a", "37.7E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as boolean)").binding("a", "17.1E0")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as boolean)").binding("a", "0.0E0")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as boolean)").binding("a", "nan()")))).isEqualTo(true);
    }

    @Test
    public void testCastToFloat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as real)").binding("a", "'754.1985'")))).isEqualTo(Float.valueOf(754.1985f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as real)").binding("a", "'-754.2008'")))).isEqualTo(Float.valueOf(-754.2008f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as real)").binding("a", "'0.0'")))).isEqualTo(Float.valueOf(0.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as real)").binding("a", "'-0.0'")))).isEqualTo(Float.valueOf(-0.0f));
    }

    @Test
    public void testCastFromVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as double)").binding("a", "'37.7'")))).isEqualTo(37.7);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as double)").binding("a", "'17.1'")))).isEqualTo(17.1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as double)").binding("a", "'NaN'")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as double precision)").binding("a", "'37.7'")))).isEqualTo(37.7);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as double precision)").binding("a", "'17.1'")))).isEqualTo(17.1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as double precision)").binding("a", "'NaN'")))).isEqualTo(Double.NaN);
    }

    @Test
    public void testIsDistinctFrom() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "cast(NULL as DOUBLE)", "CAST(NULL AS DOUBLE)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "37.7", "37.7")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "37", "37.8")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "NULL", "37.7")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "37.7", "NULL")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "nan()", "nan()")))).isEqualTo(false);
    }

    @Test
    public void testIndeterminate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(null as double)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "1.2")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(1.2 as double)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(1 as double)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "nan()")))).isEqualTo(false);
    }

    @Test
    public void testNanHash() throws Throwable {
        long[] nanRepresentations;
        for (long nanRepresentation : nanRepresentations = new long[]{Double.doubleToLongBits(Double.NaN), -2251799813685248L, 9221140251894092340L, -2231784960683468L}) {
            Assert.assertTrue((boolean)Double.isNaN(Double.longBitsToDouble(nanRepresentation)));
            Assert.assertTrue((nanRepresentation == nanRepresentations[0] || Double.doubleToRawLongBits(Double.longBitsToDouble(nanRepresentation)) != Double.doubleToRawLongBits(Double.longBitsToDouble(nanRepresentations[0])) ? 1 : 0) != 0);
            Assert.assertEquals((long)this.executeHashOperator(Double.longBitsToDouble(nanRepresentation)), (long)this.executeHashOperator(Double.longBitsToDouble(nanRepresentations[0])));
            Assert.assertEquals((long)this.executeXxHash64Operator(Double.longBitsToDouble(nanRepresentation)), (long)this.executeXxHash64Operator(Double.longBitsToDouble(nanRepresentations[0])));
        }
    }

    @Test
    public void testZeroHash() throws Throwable {
        double[] zeroes;
        for (double zero : zeroes = new double[]{0.0, -0.0}) {
            Assert.assertTrue((zero == 0.0 ? 1 : 0) != 0);
            Assert.assertEquals((long)this.executeHashOperator(zero), (long)this.executeHashOperator(zeroes[0]));
            Assert.assertEquals((long)this.executeXxHash64Operator(zero), (long)this.executeXxHash64Operator(zeroes[0]));
        }
    }

    private long executeHashOperator(double value) throws Throwable {
        MethodHandle hashCodeOperator = this.assertions.getQueryRunner().getTypeManager().getTypeOperators().getHashCodeOperator((Type)DoubleType.DOUBLE, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
        return hashCodeOperator.invokeExact(value);
    }

    private long executeXxHash64Operator(double value) throws Throwable {
        MethodHandle xxHash64Operator = this.assertions.getQueryRunner().getTypeManager().getTypeOperators().getXxHash64Operator((Type)DoubleType.DOUBLE, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
        return xxHash64Operator.invokeExact(value);
    }
}

