/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.likematcher.LikeMatcher;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.PageBuilderStatus;
import io.trino.type.LikePatternType;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLikePatternType {
    @Test
    public void testGetObject() {
        BlockBuilder blockBuilder = LikePatternType.LIKE_PATTERN.createBlockBuilder(new PageBuilderStatus().createBlockBuilderStatus(), 10);
        LikePatternType.LIKE_PATTERN.writeObject(blockBuilder, (Object)LikeMatcher.compile((String)"helloX_world", Optional.of(Character.valueOf('X'))));
        LikePatternType.LIKE_PATTERN.writeObject(blockBuilder, (Object)LikeMatcher.compile((String)"foo%_bar"));
        Block block = blockBuilder.build();
        LikeMatcher pattern = (LikeMatcher)LikePatternType.LIKE_PATTERN.getObject(block, 0);
        Assertions.assertThat((String)pattern.getPattern()).isEqualTo("helloX_world");
        Assertions.assertThat((Optional)pattern.getEscape()).isEqualTo(Optional.of(Character.valueOf('X')));
        pattern = (LikeMatcher)LikePatternType.LIKE_PATTERN.getObject(block, 1);
        Assertions.assertThat((String)pattern.getPattern()).isEqualTo("foo%_bar");
        Assertions.assertThat((Optional)pattern.getEscape()).isEqualTo(Optional.empty());
    }
}

