/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.Type;
import io.trino.type.AbstractTestType;
import java.math.BigDecimal;

public class TestLongDecimalType
extends AbstractTestType {
    private static final DecimalType LONG_DECIMAL_TYPE = DecimalType.createDecimalType((int)30, (int)10);

    public TestLongDecimalType() {
        super((Type)LONG_DECIMAL_TYPE, SqlDecimal.class, TestLongDecimalType.createTestBlock());
    }

    public static Block createTestBlock() {
        BlockBuilder blockBuilder = LONG_DECIMAL_TYPE.createBlockBuilder(null, 15);
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("-12345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("-12345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("-12345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("22345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("22345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("22345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("22345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("22345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("32345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("32345678901234567890.1234567890"));
        Decimals.writeBigDecimal((DecimalType)LONG_DECIMAL_TYPE, (BlockBuilder)blockBuilder, (BigDecimal)new BigDecimal("42345678901234567890.1234567890"));
        return blockBuilder.build();
    }

    @Override
    protected Object getNonNullValue() {
        return Int128.ZERO;
    }

    @Override
    protected Object getGreaterValue(Object value) {
        BigDecimal decimal = TestLongDecimalType.toBigDecimal((Int128)value, 10);
        BigDecimal greaterDecimal = decimal.add(BigDecimal.ONE);
        return Decimals.valueOf((BigDecimal)greaterDecimal);
    }

    private static BigDecimal toBigDecimal(Int128 value, int scale) {
        return new BigDecimal(value.toBigInteger(), scale);
    }
}

