/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.SingleRowBlockWriter;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.AbstractTestType;
import java.util.List;

public class TestSimpleRowType
extends AbstractTestType {
    private static final Type TYPE = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT), (Object)RowType.field((String)"b", (Type)VarcharType.VARCHAR)));

    public TestSimpleRowType() {
        super(TYPE, List.class, TestSimpleRowType.createTestBlock());
    }

    private static Block createTestBlock() {
        RowBlockBuilder blockBuilder = (RowBlockBuilder)TYPE.createBlockBuilder(null, 3);
        SingleRowBlockWriter singleRowBlockWriter = blockBuilder.beginBlockEntry();
        BigintType.BIGINT.writeLong((BlockBuilder)singleRowBlockWriter, 1L);
        VarcharType.VARCHAR.writeSlice((BlockBuilder)singleRowBlockWriter, Slices.utf8Slice((String)"cat"));
        blockBuilder.closeEntry();
        singleRowBlockWriter = blockBuilder.beginBlockEntry();
        BigintType.BIGINT.writeLong((BlockBuilder)singleRowBlockWriter, 2L);
        VarcharType.VARCHAR.writeSlice((BlockBuilder)singleRowBlockWriter, Slices.utf8Slice((String)"cats"));
        blockBuilder.closeEntry();
        singleRowBlockWriter = blockBuilder.beginBlockEntry();
        BigintType.BIGINT.writeLong((BlockBuilder)singleRowBlockWriter, 3L);
        VarcharType.VARCHAR.writeSlice((BlockBuilder)singleRowBlockWriter, Slices.utf8Slice((String)"dog"));
        blockBuilder.closeEntry();
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        RowBlockBuilder blockBuilder = (RowBlockBuilder)TYPE.createBlockBuilder(null, 1);
        Block block = (Block)value;
        SingleRowBlockWriter singleRowBlockWriter = blockBuilder.beginBlockEntry();
        BigintType.BIGINT.writeLong((BlockBuilder)singleRowBlockWriter, block.getSingleValueBlock(0).getLong(0, 0) + 1L);
        VarcharType.VARCHAR.writeSlice((BlockBuilder)singleRowBlockWriter, block.getSingleValueBlock(1).getSlice(0, 0, 1));
        blockBuilder.closeEntry();
        return TYPE.getObject(blockBuilder.build(), 0);
    }
}

