/*
 * Decompiled with CFR 0.152.
 */
package io.trino;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.FullConnectorSession;
import io.trino.NotInTransactionException;
import io.trino.SessionRepresentation;
import io.trino.client.ProtocolHeaders;
import io.trino.metadata.SessionPropertyManager;
import io.trino.security.AccessControl;
import io.trino.security.SecurityContext;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.session.ResourceEstimates;
import io.trino.spi.type.TimeZoneKey;
import io.trino.sql.SqlPath;
import io.trino.sql.tree.Execute;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import io.trino.util.Failures;
import java.security.Principal;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;

public final class Session {
    private final QueryId queryId;
    private final Optional<TransactionId> transactionId;
    private final boolean clientTransactionSupport;
    private final Identity identity;
    private final Optional<String> source;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final SqlPath path;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    private final Optional<String> remoteUserAddress;
    private final Optional<String> userAgent;
    private final Optional<String> clientInfo;
    private final Optional<String> traceToken;
    private final Set<String> clientTags;
    private final Set<String> clientCapabilities;
    private final ResourceEstimates resourceEstimates;
    private final Instant start;
    private final Map<String, String> systemProperties;
    private final Map<String, Map<String, String>> catalogProperties;
    private final SessionPropertyManager sessionPropertyManager;
    private final Map<String, String> preparedStatements;
    private final ProtocolHeaders protocolHeaders;
    private final Optional<Slice> exchangeEncryptionKey;

    public Session(QueryId queryId, Optional<TransactionId> transactionId, boolean clientTransactionSupport, Identity identity, Optional<String> source, Optional<String> catalog, Optional<String> schema, SqlPath path, Optional<String> traceToken, TimeZoneKey timeZoneKey, Locale locale, Optional<String> remoteUserAddress, Optional<String> userAgent, Optional<String> clientInfo, Set<String> clientTags, Set<String> clientCapabilities, ResourceEstimates resourceEstimates, Instant start, Map<String, String> systemProperties, Map<String, Map<String, String>> catalogProperties, SessionPropertyManager sessionPropertyManager, Map<String, String> preparedStatements, ProtocolHeaders protocolHeaders, Optional<Slice> exchangeEncryptionKey) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.clientTransactionSupport = clientTransactionSupport;
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.path = Objects.requireNonNull(path, "path is null");
        this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.remoteUserAddress = Objects.requireNonNull(remoteUserAddress, "remoteUserAddress is null");
        this.userAgent = Objects.requireNonNull(userAgent, "userAgent is null");
        this.clientInfo = Objects.requireNonNull(clientInfo, "clientInfo is null");
        this.clientTags = ImmutableSet.copyOf((Collection)Objects.requireNonNull(clientTags, "clientTags is null"));
        this.clientCapabilities = ImmutableSet.copyOf((Collection)Objects.requireNonNull(clientCapabilities, "clientCapabilities is null"));
        this.resourceEstimates = Objects.requireNonNull(resourceEstimates, "resourceEstimates is null");
        this.start = start;
        this.systemProperties = ImmutableMap.copyOf(Objects.requireNonNull(systemProperties, "systemProperties is null"));
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.preparedStatements = Objects.requireNonNull(preparedStatements, "preparedStatements is null");
        this.protocolHeaders = Objects.requireNonNull(protocolHeaders, "protocolHeaders is null");
        this.exchangeEncryptionKey = Objects.requireNonNull(exchangeEncryptionKey, "exchangeEncryptionKey is null");
        Objects.requireNonNull(catalogProperties, "catalogProperties is null");
        ImmutableMap.Builder catalogPropertiesBuilder = ImmutableMap.builder();
        catalogProperties.entrySet().stream().map(entry -> Maps.immutableEntry((Object)((String)entry.getKey()), (Object)ImmutableMap.copyOf((Map)((Map)entry.getValue())))).forEach(arg_0 -> ((ImmutableMap.Builder)catalogPropertiesBuilder).put(arg_0));
        this.catalogProperties = catalogPropertiesBuilder.buildOrThrow();
        Preconditions.checkArgument((catalog.isPresent() || schema.isEmpty() ? 1 : 0) != 0, (Object)"schema is set but catalog is not");
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public String getUser() {
        return this.identity.getUser();
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public Optional<String> getCatalog() {
        return this.catalog;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    public SqlPath getPath() {
        return this.path;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Optional<String> getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    public Optional<String> getUserAgent() {
        return this.userAgent;
    }

    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    public Set<String> getClientTags() {
        return this.clientTags;
    }

    public Set<String> getClientCapabilities() {
        return this.clientCapabilities;
    }

    public Optional<String> getTraceToken() {
        return this.traceToken;
    }

    public ResourceEstimates getResourceEstimates() {
        return this.resourceEstimates;
    }

    public Instant getStart() {
        return this.start;
    }

    public Optional<TransactionId> getTransactionId() {
        return this.transactionId;
    }

    public TransactionId getRequiredTransactionId() throws NotInTransactionException {
        return this.transactionId.orElseThrow(NotInTransactionException::new);
    }

    public boolean isClientTransactionSupport() {
        return this.clientTransactionSupport;
    }

    public <T> T getSystemProperty(String name, Class<T> type) {
        return this.sessionPropertyManager.decodeSystemPropertyValue(name, this.systemProperties.get(name), type);
    }

    public Map<String, Map<String, String>> getCatalogProperties() {
        return this.catalogProperties;
    }

    public Map<String, String> getCatalogProperties(String catalogName) {
        return this.catalogProperties.getOrDefault(catalogName, (Map<String, String>)ImmutableMap.of());
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, String> getPreparedStatements() {
        return this.preparedStatements;
    }

    public String getPreparedStatementFromExecute(Execute execute) {
        return this.getPreparedStatement(execute.getName().getValue());
    }

    public String getPreparedStatement(String name) {
        String sql = this.preparedStatements.get(name);
        Failures.checkCondition(sql != null, (ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Prepared statement not found: " + name, new Object[0]);
        return sql;
    }

    public ProtocolHeaders getProtocolHeaders() {
        return this.protocolHeaders;
    }

    public Optional<Slice> getExchangeEncryptionKey() {
        return this.exchangeEncryptionKey;
    }

    public Session beginTransactionId(TransactionId transactionId, TransactionManager transactionManager, AccessControl accessControl) {
        Objects.requireNonNull(transactionId, "transactionId is null");
        Preconditions.checkArgument((boolean)this.transactionId.isEmpty(), (Object)"Session already has an active transaction");
        Objects.requireNonNull(transactionManager, "transactionManager is null");
        Objects.requireNonNull(accessControl, "accessControl is null");
        this.validateSystemProperties(accessControl, this.systemProperties);
        ImmutableMap.Builder connectorProperties = ImmutableMap.builder();
        for (Map.Entry<String, Map<String, String>> catalogEntry : this.catalogProperties.entrySet()) {
            String catalogName = catalogEntry.getKey();
            Map<String, String> catalogProperties = catalogEntry.getValue();
            if (catalogProperties.isEmpty()) continue;
            CatalogHandle catalogHandle = transactionManager.getCatalogHandle(transactionId, catalogName).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Session property catalog does not exist: " + catalogName));
            this.validateCatalogProperties(Optional.of(transactionId), accessControl, catalogName, catalogHandle, catalogProperties);
            connectorProperties.put((Object)catalogName, catalogProperties);
        }
        ImmutableMap.Builder connectorRoles = ImmutableMap.builder();
        for (Map.Entry entry : this.identity.getCatalogRoles().entrySet()) {
            String catalogName = (String)entry.getKey();
            SelectedRole role = (SelectedRole)entry.getValue();
            if (transactionManager.getCatalogHandle(transactionId, catalogName).isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog for role does not exist: " + catalogName);
            }
            if (role.getType() == SelectedRole.Type.ROLE) {
                accessControl.checkCanSetCatalogRole(new SecurityContext(transactionId, this.identity, this.queryId), (String)role.getRole().orElseThrow(), catalogName);
            }
            connectorRoles.put((Object)catalogName, (Object)role);
        }
        return new Session(this.queryId, Optional.of(transactionId), this.clientTransactionSupport, Identity.from((Identity)this.identity).withConnectorRoles((Map)connectorRoles.buildOrThrow()).build(), this.source, this.catalog, this.schema, this.path, this.traceToken, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.clientInfo, this.clientTags, this.clientCapabilities, this.resourceEstimates, this.start, this.systemProperties, (Map<String, Map<String, String>>)connectorProperties.buildOrThrow(), this.sessionPropertyManager, this.preparedStatements, this.protocolHeaders, this.exchangeEncryptionKey);
    }

    public Session withDefaultProperties(Map<String, String> systemPropertyDefaults, Map<String, Map<String, String>> catalogPropertyDefaults, AccessControl accessControl) {
        Objects.requireNonNull(systemPropertyDefaults, "systemPropertyDefaults is null");
        Objects.requireNonNull(catalogPropertyDefaults, "catalogPropertyDefaults is null");
        Preconditions.checkState((boolean)this.transactionId.isEmpty(), (Object)"property defaults can not be added to a transaction already in progress");
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        systemProperties.putAll(systemPropertyDefaults);
        systemProperties.putAll(this.systemProperties);
        Map<String, Map<String, String>> catalogProperties = catalogPropertyDefaults.entrySet().stream().map(entry -> Maps.immutableEntry((Object)((String)entry.getKey()), new HashMap((Map)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<String, Map<String, String>> catalogEntry : this.catalogProperties.entrySet()) {
            catalogProperties.computeIfAbsent(catalogEntry.getKey(), id -> new HashMap()).putAll(catalogEntry.getValue());
        }
        return new Session(this.queryId, this.transactionId, this.clientTransactionSupport, this.identity, this.source, this.catalog, this.schema, this.path, this.traceToken, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.clientInfo, this.clientTags, this.clientCapabilities, this.resourceEstimates, this.start, systemProperties, catalogProperties, this.sessionPropertyManager, this.preparedStatements, this.protocolHeaders, this.exchangeEncryptionKey);
    }

    public Session withExchangeEncryption(Slice encryptionKey) {
        Preconditions.checkState((boolean)this.exchangeEncryptionKey.isEmpty(), (Object)"exchangeEncryptionKey is already present");
        return new Session(this.queryId, this.transactionId, this.clientTransactionSupport, this.identity, this.source, this.catalog, this.schema, this.path, this.traceToken, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.clientInfo, this.clientTags, this.clientCapabilities, this.resourceEstimates, this.start, this.systemProperties, this.catalogProperties, this.sessionPropertyManager, this.preparedStatements, this.protocolHeaders, Optional.of(encryptionKey));
    }

    public ConnectorSession toConnectorSession() {
        return new FullConnectorSession(this, this.identity.toConnectorIdentity());
    }

    public ConnectorSession toConnectorSession(CatalogHandle catalogHandle) {
        Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        String catalogName = catalogHandle.getCatalogName();
        return new FullConnectorSession(this, this.identity.toConnectorIdentity(catalogName), this.catalogProperties.getOrDefault(catalogName, (Map<String, String>)ImmutableMap.of()), catalogHandle, catalogName, this.sessionPropertyManager);
    }

    public SessionRepresentation toSessionRepresentation() {
        return new SessionRepresentation(this.queryId.toString(), this.transactionId, this.clientTransactionSupport, this.identity.getUser(), this.identity.getGroups(), this.identity.getPrincipal().map(Principal::toString), this.identity.getEnabledRoles(), this.source, this.catalog, this.schema, this.path, this.traceToken, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.clientInfo, this.clientTags, this.clientCapabilities, this.resourceEstimates, this.start, this.systemProperties, this.catalogProperties, this.identity.getCatalogRoles(), this.preparedStatements, this.protocolHeaders.getProtocolName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("transactionId", this.transactionId).add("user", (Object)this.getUser()).add("principal", this.getIdentity().getPrincipal().orElse(null)).add("source", this.source.orElse(null)).add("catalog", this.catalog.orElse(null)).add("schema", this.schema.orElse(null)).add("path", (Object)this.path).add("traceToken", this.traceToken.orElse(null)).add("timeZoneKey", (Object)this.timeZoneKey).add("locale", (Object)this.locale).add("remoteUserAddress", this.remoteUserAddress.orElse(null)).add("userAgent", this.userAgent.orElse(null)).add("clientInfo", this.clientInfo.orElse(null)).add("clientTags", this.clientTags).add("clientCapabilities", this.clientCapabilities).add("resourceEstimates", (Object)this.resourceEstimates).add("start", (Object)this.start).omitNullValues().toString();
    }

    private void validateCatalogProperties(Optional<TransactionId> transactionId, AccessControl accessControl, String catalogName, CatalogHandle catalogHandle, Map<String, String> catalogProperties) {
        for (Map.Entry<String, String> property : catalogProperties.entrySet()) {
            if (transactionId.isPresent()) {
                accessControl.checkCanSetCatalogSessionProperty(new SecurityContext(transactionId.get(), this.identity, this.queryId), catalogName, property.getKey());
            }
            this.sessionPropertyManager.validateCatalogSessionProperty(catalogName, catalogHandle, property.getKey(), property.getValue());
        }
    }

    private void validateSystemProperties(AccessControl accessControl, Map<String, String> systemProperties) {
        for (Map.Entry<String, String> property : systemProperties.entrySet()) {
            accessControl.checkCanSetSystemSessionProperty(this.identity, property.getKey());
            this.sessionPropertyManager.validateSystemSessionProperty(property.getKey(), property.getValue());
        }
    }

    public static SessionBuilder builder(SessionPropertyManager sessionPropertyManager) {
        return new SessionBuilder(sessionPropertyManager);
    }

    @VisibleForTesting
    public static SessionBuilder builder(Session session) {
        return new SessionBuilder(session);
    }

    public SecurityContext toSecurityContext() {
        return new SecurityContext(this.getRequiredTransactionId(), this.getIdentity(), this.queryId);
    }

    public static class SessionBuilder {
        private QueryId queryId;
        private TransactionId transactionId;
        private boolean clientTransactionSupport;
        private Identity identity;
        private String source;
        private String catalog;
        private String schema;
        private SqlPath path;
        private Optional<String> traceToken = Optional.empty();
        private TimeZoneKey timeZoneKey;
        private Locale locale;
        private String remoteUserAddress;
        private String userAgent;
        private String clientInfo;
        private Set<String> clientTags = ImmutableSet.of();
        private Set<String> clientCapabilities = ImmutableSet.of();
        private ResourceEstimates resourceEstimates;
        private Instant start = Instant.now();
        private final Map<String, String> systemProperties = new HashMap<String, String>();
        private final Map<String, Map<String, String>> catalogSessionProperties = new HashMap<String, Map<String, String>>();
        private final SessionPropertyManager sessionPropertyManager;
        private final Map<String, String> preparedStatements = new HashMap<String, String>();
        private ProtocolHeaders protocolHeaders = ProtocolHeaders.TRINO_HEADERS;

        private SessionBuilder(SessionPropertyManager sessionPropertyManager) {
            this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        }

        private SessionBuilder(Session session) {
            Objects.requireNonNull(session, "session is null");
            Preconditions.checkArgument((boolean)session.getTransactionId().isEmpty(), (Object)"Session builder cannot be created from a session in a transaction");
            this.sessionPropertyManager = session.sessionPropertyManager;
            this.queryId = session.queryId;
            this.transactionId = session.transactionId.orElse(null);
            this.clientTransactionSupport = session.clientTransactionSupport;
            this.identity = session.identity;
            this.source = session.source.orElse(null);
            this.catalog = session.catalog.orElse(null);
            this.path = session.path;
            this.schema = session.schema.orElse(null);
            this.traceToken = Objects.requireNonNull(session.traceToken, "traceToken is null");
            this.timeZoneKey = session.timeZoneKey;
            this.locale = session.locale;
            this.remoteUserAddress = session.remoteUserAddress.orElse(null);
            this.userAgent = session.userAgent.orElse(null);
            this.clientInfo = session.clientInfo.orElse(null);
            this.clientCapabilities = ImmutableSet.copyOf(session.clientCapabilities);
            this.clientTags = ImmutableSet.copyOf(session.clientTags);
            this.start = session.start;
            this.systemProperties.putAll(session.systemProperties);
            session.catalogProperties.forEach((catalog, properties) -> this.catalogSessionProperties.put((String)catalog, new HashMap(properties)));
            this.preparedStatements.putAll(session.preparedStatements);
            this.protocolHeaders = session.protocolHeaders;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setQueryId(QueryId queryId) {
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setTransactionId(TransactionId transactionId) {
            Preconditions.checkArgument((boolean)this.catalogSessionProperties.isEmpty(), (Object)"Catalog session properties cannot be set if there is an open transaction");
            this.transactionId = transactionId;
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setClientTransactionSupport() {
            this.clientTransactionSupport = true;
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setCatalog(Optional<String> catalog) {
            this.catalog = catalog.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setRemoteUserAddress(String remoteUserAddress) {
            this.remoteUserAddress = remoteUserAddress;
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setRemoteUserAddress(Optional<String> remoteUserAddress) {
            this.remoteUserAddress = remoteUserAddress.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setSchema(Optional<String> schema) {
            this.schema = schema.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setPath(SqlPath path) {
            this.path = path;
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setPath(Optional<SqlPath> path) {
            this.path = path.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setSource(Optional<String> source) {
            this.source = source.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setTraceToken(Optional<String> traceToken) {
            this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setStart(Instant start) {
            this.start = start;
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setTimeZoneKey(TimeZoneKey timeZoneKey) {
            this.timeZoneKey = timeZoneKey;
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setTimeZoneKey(Optional<TimeZoneKey> timeZoneKey) {
            this.timeZoneKey = timeZoneKey.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setIdentity(Identity identity) {
            this.identity = identity;
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setUserAgent(Optional<String> userAgent) {
            this.userAgent = userAgent.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setClientInfo(String clientInfo) {
            this.clientInfo = clientInfo;
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setClientInfo(Optional<String> clientInfo) {
            this.clientInfo = clientInfo.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setClientTags(Set<String> clientTags) {
            this.clientTags = ImmutableSet.copyOf(clientTags);
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setClientCapabilities(Set<String> clientCapabilities) {
            this.clientCapabilities = ImmutableSet.copyOf(clientCapabilities);
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setResourceEstimates(ResourceEstimates resourceEstimates) {
            this.resourceEstimates = resourceEstimates;
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setSystemProperty(String propertyName, String propertyValue) {
            this.systemProperties.put(propertyName, propertyValue);
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setSystemProperties(Map<String, String> systemProperties) {
            Objects.requireNonNull(systemProperties, "systemProperties is null");
            this.systemProperties.clear();
            this.systemProperties.putAll(systemProperties);
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setCatalogSessionProperty(String catalogName, String propertyName, String propertyValue) {
            Preconditions.checkArgument((this.transactionId == null ? 1 : 0) != 0, (Object)"Catalog session properties cannot be set if there is an open transaction");
            this.catalogSessionProperties.computeIfAbsent(catalogName, id -> new HashMap()).put(propertyName, propertyValue);
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder addPreparedStatement(String statementName, String query) {
            this.preparedStatements.put(statementName, query);
            return this;
        }

        @CanIgnoreReturnValue
        public SessionBuilder setProtocolHeaders(ProtocolHeaders protocolHeaders) {
            this.protocolHeaders = Objects.requireNonNull(protocolHeaders, "protocolHeaders is null");
            return this;
        }

        public Session build() {
            return new Session(this.queryId, Optional.ofNullable(this.transactionId), this.clientTransactionSupport, this.identity, Optional.ofNullable(this.source), Optional.ofNullable(this.catalog), Optional.ofNullable(this.schema), this.path != null ? this.path : new SqlPath(Optional.empty()), this.traceToken, this.timeZoneKey != null ? this.timeZoneKey : TimeZoneKey.getTimeZoneKey((String)TimeZone.getDefault().getID()), this.locale != null ? this.locale : Locale.getDefault(), Optional.ofNullable(this.remoteUserAddress), Optional.ofNullable(this.userAgent), Optional.ofNullable(this.clientInfo), this.clientTags, this.clientCapabilities, Optional.ofNullable(this.resourceEstimates).orElse(new ResourceEstimateBuilder().build()), this.start, this.systemProperties, this.catalogSessionProperties, this.sessionPropertyManager, this.preparedStatements, this.protocolHeaders, Optional.empty());
        }
    }

    public static class ResourceEstimateBuilder {
        private Optional<Duration> executionTime = Optional.empty();
        private Optional<Duration> cpuTime = Optional.empty();
        private Optional<DataSize> peakMemory = Optional.empty();

        public ResourceEstimateBuilder setExecutionTime(Duration executionTime) {
            this.executionTime = Optional.of(executionTime);
            return this;
        }

        public ResourceEstimateBuilder setCpuTime(Duration cpuTime) {
            this.cpuTime = Optional.of(cpuTime);
            return this;
        }

        public ResourceEstimateBuilder setPeakMemory(DataSize peakMemory) {
            this.peakMemory = Optional.of(peakMemory);
            return this;
        }

        public ResourceEstimates build() {
            return new ResourceEstimates(this.executionTime.map(Duration::toMillis).map(java.time.Duration::ofMillis), this.cpuTime.map(Duration::toMillis).map(java.time.Duration::ofMillis), this.peakMemory.map(DataSize::toBytes));
        }
    }
}

