/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.informationschema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.trino.connector.informationschema.InformationSchemaTable;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.spi.connector.ConnectorTableHandle;
import java.util.Collection;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;

public class InformationSchemaTableHandle
implements ConnectorTableHandle {
    private final String catalogName;
    private final InformationSchemaTable table;
    private final Set<QualifiedTablePrefix> prefixes;
    private final OptionalLong limit;

    @JsonCreator
    public InformationSchemaTableHandle(@JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="table") InformationSchemaTable table, @JsonProperty(value="prefixes") Set<QualifiedTablePrefix> prefixes, @JsonProperty(value="limit") OptionalLong limit) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.prefixes = ImmutableSet.copyOf((Collection)Objects.requireNonNull(prefixes, "prefixes is null"));
        this.limit = Objects.requireNonNull(limit, "limit is null");
    }

    @JsonProperty
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public InformationSchemaTable getTable() {
        return this.table;
    }

    @JsonProperty
    public Set<QualifiedTablePrefix> getPrefixes() {
        return this.prefixes;
    }

    @JsonProperty
    public OptionalLong getLimit() {
        return this.limit;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogName", (Object)this.catalogName).add("table", (Object)this.table).add("prefixes", this.prefixes).add("limit", (Object)this.limit).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.catalogName, this.table, this.prefixes, this.limit});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InformationSchemaTableHandle other = (InformationSchemaTableHandle)obj;
        return Objects.equals(this.catalogName, other.catalogName) && this.table == other.table && Objects.equals(this.prefixes, other.prefixes) && Objects.equals(this.limit, other.limit);
    }
}

