/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import io.trino.FullConnectorSession;
import io.trino.Session;
import io.trino.connector.system.jdbc.FilterUtil;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataListing;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.ViewInfo;
import io.trino.security.AccessControl;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.MaterializedViewNotFoundException;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class MaterializedViewSystemTable
implements SystemTable {
    private static final ConnectorTableMetadata TABLE_DEFINITION = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(new SchemaTableName("metadata", "materialized_views")).column("catalog_name", (Type)VarcharType.createUnboundedVarcharType()).column("schema_name", (Type)VarcharType.createUnboundedVarcharType()).column("name", (Type)VarcharType.createUnboundedVarcharType()).column("storage_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("storage_schema", (Type)VarcharType.createUnboundedVarcharType()).column("storage_table", (Type)VarcharType.createUnboundedVarcharType()).column("freshness", (Type)VarcharType.createUnboundedVarcharType()).column("last_fresh_time", (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9)).column("comment", (Type)VarcharType.createUnboundedVarcharType()).column("definition", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public MaterializedViewSystemTable(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return TABLE_DEFINITION;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        Session session = ((FullConnectorSession)connectorSession).getSession();
        InMemoryRecordSet.Builder displayTable = InMemoryRecordSet.builder((ConnectorTableMetadata)this.getTableMetadata());
        Optional<String> catalogFilter = FilterUtil.tryGetSingleVarcharValue(constraint, 0);
        Optional<String> schemaFilter = FilterUtil.tryGetSingleVarcharValue(constraint, 1);
        Optional<String> tableFilter = FilterUtil.tryGetSingleVarcharValue(constraint, 2);
        MetadataListing.listCatalogNames(session, this.metadata, this.accessControl, catalogFilter).forEach(catalogName -> {
            QualifiedTablePrefix tablePrefix = FilterUtil.tablePrefix(catalogName, schemaFilter, tableFilter);
            MetadataListing.getMaterializedViews(session, this.metadata, this.accessControl, tablePrefix).forEach((tableName, definition) -> {
                MaterializedViewFreshness freshness;
                QualifiedObjectName name = new QualifiedObjectName(tablePrefix.getCatalogName(), tableName.getSchemaName(), tableName.getTableName());
                try {
                    freshness = this.metadata.getMaterializedViewFreshness(session, name);
                }
                catch (MaterializedViewNotFoundException e) {
                    return;
                }
                Object[] materializedViewRow = MaterializedViewSystemTable.createMaterializedViewRow(name, freshness, definition);
                displayTable.addRow(materializedViewRow);
            });
        });
        return displayTable.build().cursor();
    }

    private static Object[] createMaterializedViewRow(QualifiedObjectName name, MaterializedViewFreshness freshness, ViewInfo definition) {
        return new Object[]{name.getCatalogName(), name.getSchemaName(), name.getObjectName(), definition.getStorageTable().map(CatalogSchemaTableName::getCatalogName).orElse(""), definition.getStorageTable().map(storageTable -> storageTable.getSchemaTableName().getSchemaName()).orElse(""), definition.getStorageTable().map(storageTable -> storageTable.getSchemaTableName().getTableName()).orElse(""), freshness.getFreshness().name(), freshness.getLastFreshTime().map(instant -> LongTimestampWithTimeZone.fromEpochSecondsAndFraction((long)instant.getEpochSecond(), (long)((long)instant.getNano() * 1000L), (TimeZoneKey)TimeZoneKey.UTC_KEY)).orElse(null), definition.getComment().orElse(""), definition.getOriginalSql()};
    }
}

