/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.RenameMaterializedView;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class RenameMaterializedViewTask
implements DataDefinitionTask<RenameMaterializedView> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public RenameMaterializedViewTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "RENAME MATERIALIZED VIEW";
    }

    @Override
    public ListenableFuture<Void> execute(RenameMaterializedView statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        QualifiedObjectName materializedViewName;
        Session session = stateMachine.getSession();
        if (!this.metadata.isMaterializedView(session, materializedViewName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getSource()))) {
            if (this.metadata.isView(session, materializedViewName)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Materialized View '%s' does not exist, but a view with that name exists. Did you mean ALTER VIEW %s RENAME TO ...?", materializedViewName, materializedViewName);
            }
            if (this.metadata.getTableHandle(session, materializedViewName).isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Materialized View '%s' does not exist, but a table with that name exists. Did you mean ALTER TABLE %s RENAME TO ...?", materializedViewName, materializedViewName);
            }
            if (statement.isExists()) {
                return Futures.immediateVoidFuture();
            }
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Materialized View '%s' does not exist", materializedViewName);
        }
        QualifiedObjectName target = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTarget());
        if (this.metadata.getCatalogHandle(session, target.getCatalogName()).isEmpty()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.CATALOG_NOT_FOUND, (Node)statement, "Target catalog '%s' does not exist", target.getCatalogName());
        }
        if (this.metadata.isMaterializedView(session, target)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Target materialized view '%s' already exists", target);
        }
        if (this.metadata.isView(session, target)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Target materialized view '%s' does not exist, but a view with that name exists.", target);
        }
        if (this.metadata.getTableHandle(session, target).isPresent()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Target materialized view '%s' does not exist, but a table with that name exists.", target);
        }
        if (!materializedViewName.getCatalogName().equals(target.getCatalogName())) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Materialized View rename across catalogs is not supported", new Object[0]);
        }
        this.accessControl.checkCanRenameMaterializedView(session.toSecurityContext(), materializedViewName, target);
        this.metadata.renameMaterializedView(session, materializedViewName, target);
        return Futures.immediateVoidFuture();
    }
}

