/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.SessionPropertyManager;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.CatalogHandle;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.ResetSession;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class ResetSessionTask
implements DataDefinitionTask<ResetSession> {
    private final Metadata metadata;
    private final SessionPropertyManager sessionPropertyManager;

    @Inject
    public ResetSessionTask(Metadata metadata, SessionPropertyManager sessionPropertyManager) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
    }

    @Override
    public String getName() {
        return "RESET SESSION";
    }

    @Override
    public ListenableFuture<Void> execute(ResetSession statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        CatalogHandle catalogHandle;
        List parts = statement.getName().getParts();
        if (parts.size() > 2) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Invalid session property '%s'", statement.getName());
        }
        if (parts.size() == 1 ? this.sessionPropertyManager.getSystemSessionPropertyMetadata((String)parts.get(0)).isEmpty() : this.sessionPropertyManager.getConnectorSessionPropertyMetadata(catalogHandle = MetadataUtil.getRequiredCatalogHandle(this.metadata, stateMachine.getSession(), (Node)statement, (String)parts.get(0)), (String)parts.get(1)).isEmpty()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Session property '%s' does not exist", statement.getName());
        }
        stateMachine.addResetSessionProperties(statement.getName().toString());
        return Futures.immediateVoidFuture();
    }
}

