/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SetColumnType;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class SetColumnTypeTask
implements DataDefinitionTask<SetColumnType> {
    private final Metadata metadata;
    private final TypeManager typeManager;
    private final AccessControl accessControl;

    @Inject
    public SetColumnTypeTask(Metadata metadata, TypeManager typeManager, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "SET COLUMN TYPE";
    }

    @Override
    public ListenableFuture<Void> execute(SetColumnType statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        QualifiedObjectName qualifiedObjectName;
        Session session = stateMachine.getSession();
        RedirectionAwareTableHandle redirectionAwareTableHandle = this.metadata.getRedirectionAwareTableHandle(session, qualifiedObjectName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTableName()));
        if (redirectionAwareTableHandle.getTableHandle().isEmpty()) {
            Object exceptionMessage = String.format("Table '%s' does not exist", qualifiedObjectName);
            if (this.metadata.getMaterializedView(session, qualifiedObjectName).isPresent()) {
                exceptionMessage = (String)exceptionMessage + ", but a materialized view with that name exists.";
            } else if (this.metadata.getView(session, qualifiedObjectName).isPresent()) {
                exceptionMessage = (String)exceptionMessage + ", but a view with that name exists.";
            }
            if (!statement.isTableExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, (String)exceptionMessage, new Object[0]);
            }
            return Futures.immediateVoidFuture();
        }
        this.accessControl.checkCanAlterColumn(session.toSecurityContext(), redirectionAwareTableHandle.getRedirectedTableName().orElse(qualifiedObjectName));
        TableHandle tableHandle = redirectionAwareTableHandle.getTableHandle().get();
        Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(session, tableHandle);
        ColumnHandle column = columnHandles.get(statement.getColumnName().getValue().toLowerCase(Locale.ENGLISH));
        if (column == null) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Column '%s' does not exist", statement.getColumnName());
        }
        this.metadata.setColumnType(session, tableHandle, column, this.getColumnType(statement));
        return Futures.immediateVoidFuture();
    }

    private Type getColumnType(SetColumnType statement) {
        Type type;
        try {
            type = this.typeManager.getType(TypeSignatureTranslator.toTypeSignature(statement.getType()));
        }
        catch (TypeNotFoundException e) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_NOT_FOUND, (Node)statement.getType(), "Unknown type '%s' for column '%s'", statement.getType(), statement.getColumnName());
        }
        if (type.equals((Object)UnknownType.UNKNOWN)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_TYPE_UNKNOWN, (Node)statement.getType(), "Unknown type '%s' for column '%s'", statement.getType(), statement.getColumnName());
        }
        return type;
    }
}

