/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.SetThreadName;
import io.airlift.units.Duration;
import io.trino.SystemSessionProperties;
import io.trino.event.SplitMonitor;
import io.trino.execution.ScheduledSplit;
import io.trino.execution.SplitAssignment;
import io.trino.execution.SplitRunner;
import io.trino.execution.StateMachine;
import io.trino.execution.TaskId;
import io.trino.execution.TaskState;
import io.trino.execution.TaskStateMachine;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.executor.TaskExecutor;
import io.trino.execution.executor.TaskHandle;
import io.trino.operator.Driver;
import io.trino.operator.DriverContext;
import io.trino.operator.DriverFactory;
import io.trino.operator.DriverStats;
import io.trino.operator.PipelineContext;
import io.trino.operator.TaskContext;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.SplitWeight;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.planner.LocalExecutionPlanner;
import io.trino.sql.planner.plan.PlanNodeId;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;

public class SqlTaskExecution {
    private final TaskId taskId;
    private final TaskStateMachine taskStateMachine;
    private final TaskContext taskContext;
    private final OutputBuffer outputBuffer;
    private final TaskHandle taskHandle;
    private final TaskExecutor taskExecutor;
    private final Executor notificationExecutor;
    private final SplitMonitor splitMonitor;
    private final DriverAndTaskTerminationTracker driverAndTaskTerminationTracker;
    private final Map<PlanNodeId, DriverSplitRunnerFactory> driverRunnerFactoriesWithSplitLifeCycle;
    private final List<DriverSplitRunnerFactory> driverRunnerFactoriesWithTaskLifeCycle;
    private final Map<PlanNodeId, DriverSplitRunnerFactory> driverRunnerFactoriesWithRemoteSource;
    private final List<DriverSplitRunnerFactory> allDriverRunnerFactories;
    @GuardedBy(value="this")
    private final Map<PlanNodeId, Long> maxAcknowledgedSplitByPlanNode = new HashMap<PlanNodeId, Long>();
    @GuardedBy(value="this")
    private final List<PlanNodeId> sourceStartOrder;
    @GuardedBy(value="this")
    private int schedulingPlanNodeOrdinal;
    @GuardedBy(value="this")
    private final Map<PlanNodeId, PendingSplitsForPlanNode> pendingSplitsByPlanNode;
    private final AtomicLong remainingSplitRunners = new AtomicLong();

    public SqlTaskExecution(TaskStateMachine taskStateMachine, TaskContext taskContext, OutputBuffer outputBuffer, LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan, TaskExecutor taskExecutor, SplitMonitor splitMonitor, Executor notificationExecutor) {
        this.taskStateMachine = Objects.requireNonNull(taskStateMachine, "taskStateMachine is null");
        this.taskId = taskStateMachine.getTaskId();
        this.taskContext = Objects.requireNonNull(taskContext, "taskContext is null");
        this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
        this.taskExecutor = Objects.requireNonNull(taskExecutor, "taskExecutor is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.splitMonitor = Objects.requireNonNull(splitMonitor, "splitMonitor is null");
        this.driverAndTaskTerminationTracker = new DriverAndTaskTerminationTracker(taskStateMachine);
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.taskId});){
            List<DriverFactory> driverFactories = localExecutionPlan.getDriverFactories();
            ImmutableSet partitionedSources = ImmutableSet.copyOf(localExecutionPlan.getPartitionedSourceOrder());
            ImmutableMap.Builder driverRunnerFactoriesWithSplitLifeCycle = ImmutableMap.builder();
            ImmutableList.Builder driverRunnerFactoriesWithTaskLifeCycle = ImmutableList.builder();
            ImmutableMap.Builder driverRunnerFactoriesWithRemoteSource = ImmutableMap.builder();
            for (DriverFactory driverFactory : driverFactories) {
                Optional<PlanNodeId> sourceId = driverFactory.getSourceId();
                if (sourceId.isPresent() && partitionedSources.contains(sourceId.get())) {
                    driverRunnerFactoriesWithSplitLifeCycle.put((Object)sourceId.get(), (Object)new DriverSplitRunnerFactory(driverFactory, true));
                    continue;
                }
                DriverSplitRunnerFactory runnerFactory = new DriverSplitRunnerFactory(driverFactory, false);
                sourceId.ifPresent(planNodeId -> driverRunnerFactoriesWithRemoteSource.put(planNodeId, (Object)runnerFactory));
                driverRunnerFactoriesWithTaskLifeCycle.add((Object)runnerFactory);
            }
            this.driverRunnerFactoriesWithSplitLifeCycle = driverRunnerFactoriesWithSplitLifeCycle.buildOrThrow();
            this.driverRunnerFactoriesWithTaskLifeCycle = driverRunnerFactoriesWithTaskLifeCycle.build();
            this.driverRunnerFactoriesWithRemoteSource = driverRunnerFactoriesWithRemoteSource.buildOrThrow();
            this.allDriverRunnerFactories = ImmutableList.builderWithExpectedSize((int)driverFactories.size()).addAll(this.driverRunnerFactoriesWithTaskLifeCycle).addAll(this.driverRunnerFactoriesWithSplitLifeCycle.values()).build();
            this.pendingSplitsByPlanNode = (Map)this.driverRunnerFactoriesWithSplitLifeCycle.keySet().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), ignore -> new PendingSplitsForPlanNode()));
            this.sourceStartOrder = localExecutionPlan.getPartitionedSourceOrder();
            Preconditions.checkArgument((boolean)this.driverRunnerFactoriesWithSplitLifeCycle.keySet().equals(partitionedSources), (Object)"Fragment is partitioned, but not all partitioned drivers were found");
            if (taskStateMachine.getState().isTerminatingOrDone()) {
                this.taskHandle = null;
                driverFactories.forEach(DriverFactory::noMoreDrivers);
            } else {
                this.taskHandle = SqlTaskExecution.createTaskHandle(taskStateMachine, taskContext, outputBuffer, driverFactories, taskExecutor, this.driverAndTaskTerminationTracker);
            }
        }
    }

    public synchronized void start() {
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.getTaskId()});){
            if (this.taskStateMachine.getState().isTerminating()) {
                this.taskStateMachine.terminationComplete();
            } else if (this.taskHandle != null) {
                this.scheduleDriversForTaskLifeCycle();
                this.outputBuffer.addStateChangeListener(new CheckTaskCompletionOnBufferFinish(this));
            }
        }
    }

    private static TaskHandle createTaskHandle(TaskStateMachine taskStateMachine, TaskContext taskContext, OutputBuffer outputBuffer, List<DriverFactory> driverFactories, TaskExecutor taskExecutor, DriverAndTaskTerminationTracker driverAndTaskTerminationTracker) {
        TaskHandle taskHandle = taskExecutor.addTask(taskStateMachine.getTaskId(), outputBuffer::getUtilization, SystemSessionProperties.getInitialSplitsPerNode(taskContext.getSession()), SystemSessionProperties.getSplitConcurrencyAdjustmentInterval(taskContext.getSession()), SystemSessionProperties.getMaxDriversPerTask(taskContext.getSession()));
        taskStateMachine.addStateChangeListener(state -> {
            if (state.isTerminatingOrDone()) {
                if (!taskHandle.isDestroyed()) {
                    taskExecutor.removeTask(taskHandle);
                    for (DriverFactory factory : driverFactories) {
                        factory.noMoreDrivers();
                    }
                }
                if (state.isTerminating()) {
                    driverAndTaskTerminationTracker.checkTaskTermination();
                }
            }
        });
        return taskHandle;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public void addSplitAssignments(List<SplitAssignment> splitAssignments) {
        Objects.requireNonNull(splitAssignments, "splitAssignments is null");
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (String)"Cannot add split assignments while holding a lock on the %s", (Object)this.getClass().getSimpleName());
        if (this.taskStateMachine.getState().isTerminatingOrDone()) {
            return;
        }
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.taskId});){
            Set<PlanNodeId> updatedUnpartitionedSources = this.updateSplitAssignments(splitAssignments);
            for (PlanNodeId planNodeId : updatedUnpartitionedSources) {
                DriverSplitRunnerFactory factory = this.driverRunnerFactoriesWithRemoteSource.get(planNodeId);
                factory.scheduleSplits();
            }
            this.checkTaskCompletion();
        }
    }

    private synchronized Set<PlanNodeId> updateSplitAssignments(List<SplitAssignment> splitAssignments) {
        ImmutableSet.Builder updatedUnpartitionedSources = ImmutableSet.builder();
        ArrayList<SplitAssignment> unacknowledgedSplitAssignment = new ArrayList<SplitAssignment>(splitAssignments.size());
        for (SplitAssignment splitAssignment : splitAssignments) {
            ImmutableSet newSplits;
            long currentMaxAcknowledgedSplit;
            if (splitAssignment.getSplits().isEmpty() && !splitAssignment.isNoMoreSplits()) continue;
            PlanNodeId planNodeId = splitAssignment.getPlanNodeId();
            long maxAcknowledgedSplit = currentMaxAcknowledgedSplit = this.maxAcknowledgedSplitByPlanNode.getOrDefault(planNodeId, Long.MIN_VALUE).longValue();
            ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)splitAssignment.getSplits().size());
            for (ScheduledSplit split : splitAssignment.getSplits()) {
                long sequenceId = split.getSequenceId();
                if (sequenceId > currentMaxAcknowledgedSplit) {
                    builder.add((Object)split);
                }
                if (sequenceId <= maxAcknowledgedSplit) continue;
                maxAcknowledgedSplit = sequenceId;
            }
            if (maxAcknowledgedSplit > currentMaxAcknowledgedSplit) {
                this.maxAcknowledgedSplitByPlanNode.put(planNodeId, maxAcknowledgedSplit);
            }
            if ((newSplits = builder.build()).isEmpty() && !splitAssignment.isNoMoreSplits()) continue;
            unacknowledgedSplitAssignment.add(new SplitAssignment(splitAssignment.getPlanNodeId(), (Set<ScheduledSplit>)newSplits, splitAssignment.isNoMoreSplits()));
        }
        for (SplitAssignment splitAssignment : unacknowledgedSplitAssignment) {
            if (this.driverRunnerFactoriesWithSplitLifeCycle.containsKey(splitAssignment.getPlanNodeId())) {
                this.schedulePartitionedSource(splitAssignment);
                continue;
            }
            DriverSplitRunnerFactory factory = this.driverRunnerFactoriesWithRemoteSource.get(splitAssignment.getPlanNodeId());
            factory.enqueueSplits(splitAssignment.getSplits(), splitAssignment.isNoMoreSplits());
            updatedUnpartitionedSources.add((Object)splitAssignment.getPlanNodeId());
        }
        return updatedUnpartitionedSources.build();
    }

    @GuardedBy(value="this")
    private void mergeIntoPendingSplits(PlanNodeId planNodeId, Set<ScheduledSplit> scheduledSplits, boolean noMoreSplits) {
        this.checkHoldsLock();
        DriverSplitRunnerFactory partitionedDriverFactory = this.driverRunnerFactoriesWithSplitLifeCycle.get(planNodeId);
        PendingSplitsForPlanNode pendingSplitsForPlanNode = this.pendingSplitsByPlanNode.get(planNodeId);
        partitionedDriverFactory.splitsAdded(scheduledSplits.size(), SplitWeight.rawValueSum(scheduledSplits, scheduledSplit -> scheduledSplit.getSplit().getSplitWeight()));
        for (ScheduledSplit scheduledSplit2 : scheduledSplits) {
            pendingSplitsForPlanNode.addSplit(scheduledSplit2);
        }
        if (noMoreSplits) {
            pendingSplitsForPlanNode.setNoMoreSplits();
        }
    }

    private synchronized void schedulePartitionedSource(SplitAssignment splitAssignmentUpdate) {
        this.mergeIntoPendingSplits(splitAssignmentUpdate.getPlanNodeId(), splitAssignmentUpdate.getSplits(), splitAssignmentUpdate.isNoMoreSplits());
        while (this.schedulingPlanNodeOrdinal < this.sourceStartOrder.size()) {
            PlanNodeId schedulingPlanNode = this.sourceStartOrder.get(this.schedulingPlanNodeOrdinal);
            DriverSplitRunnerFactory partitionedDriverRunnerFactory = this.driverRunnerFactoriesWithSplitLifeCycle.get(schedulingPlanNode);
            PendingSplitsForPlanNode pendingSplits = this.pendingSplitsByPlanNode.get(schedulingPlanNode);
            Set<ScheduledSplit> removed = pendingSplits.removeAllSplits();
            ImmutableList.Builder runners = ImmutableList.builderWithExpectedSize((int)removed.size());
            for (ScheduledSplit scheduledSplit : removed) {
                runners.add((Object)partitionedDriverRunnerFactory.createPartitionedDriverRunner(scheduledSplit));
            }
            this.enqueueDriverSplitRunner(false, (List<DriverSplitRunner>)runners.build());
            if (pendingSplits.getState() != SplitsState.NO_MORE_SPLITS) break;
            partitionedDriverRunnerFactory.noMoreDriverRunner();
            pendingSplits.markAsCleanedUp();
            ++this.schedulingPlanNodeOrdinal;
        }
    }

    private void scheduleDriversForTaskLifeCycle() {
        ArrayList<DriverSplitRunner> runners = new ArrayList<DriverSplitRunner>();
        for (DriverSplitRunnerFactory driverRunnerFactory : this.driverRunnerFactoriesWithTaskLifeCycle) {
            for (int i = 0; i < driverRunnerFactory.getDriverInstances().orElse(1); ++i) {
                runners.add(driverRunnerFactory.createUnpartitionedDriverRunner());
            }
        }
        this.enqueueDriverSplitRunner(true, runners);
        for (DriverSplitRunnerFactory driverRunnerFactory : this.driverRunnerFactoriesWithTaskLifeCycle) {
            driverRunnerFactory.noMoreDriverRunner();
            Verify.verify((boolean)driverRunnerFactory.isNoMoreDriverRunner());
        }
        this.checkTaskCompletion();
    }

    private synchronized void enqueueDriverSplitRunner(boolean forceRunSplit, List<DriverSplitRunner> runners) {
        List<ListenableFuture<Void>> finishedFutures = this.taskExecutor.enqueueSplits(this.taskHandle, forceRunSplit, runners);
        Preconditions.checkState((finishedFutures.size() == runners.size() ? 1 : 0) != 0, (String)"Expected %s futures but got %s", (int)runners.size(), (int)finishedFutures.size());
        this.remainingSplitRunners.addAndGet(runners.size());
        for (int i = 0; i < finishedFutures.size(); ++i) {
            ListenableFuture<Void> finishedFuture = finishedFutures.get(i);
            final DriverSplitRunner splitRunner = runners.get(i);
            Futures.addCallback(finishedFuture, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{SqlTaskExecution.this.taskId});){
                        if (SqlTaskExecution.this.remainingSplitRunners.decrementAndGet() == 0L) {
                            SqlTaskExecution.this.checkTaskCompletion();
                        }
                        SqlTaskExecution.this.splitMonitor.splitCompletedEvent(SqlTaskExecution.this.taskId, this.getDriverStats());
                    }
                }

                public void onFailure(Throwable cause) {
                    try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{SqlTaskExecution.this.taskId});){
                        SqlTaskExecution.this.taskStateMachine.failed(cause);
                        if (SqlTaskExecution.this.remainingSplitRunners.decrementAndGet() == 0L) {
                            SqlTaskExecution.this.checkTaskCompletion();
                        }
                        SqlTaskExecution.this.splitMonitor.splitFailedEvent(SqlTaskExecution.this.taskId, this.getDriverStats(), cause);
                    }
                }

                private DriverStats getDriverStats() {
                    DriverContext driverContext = splitRunner.getDriverContext();
                    DriverStats driverStats = driverContext != null ? driverContext.getDriverStats() : new DriverStats();
                    return driverStats;
                }
            }, (Executor)this.notificationExecutor);
        }
    }

    public synchronized Set<PlanNodeId> getNoMoreSplits() {
        ImmutableSet.Builder noMoreSplits = ImmutableSet.builder();
        for (Map.Entry<PlanNodeId, DriverSplitRunnerFactory> entry : this.driverRunnerFactoriesWithSplitLifeCycle.entrySet()) {
            if (!entry.getValue().isNoMoreDriverRunner()) continue;
            noMoreSplits.add((Object)entry.getKey());
        }
        for (Map.Entry<PlanNodeId, DriverSplitRunnerFactory> entry : this.driverRunnerFactoriesWithRemoteSource.entrySet()) {
            if (!entry.getValue().isNoMoreSplits()) continue;
            noMoreSplits.add((Object)entry.getKey());
        }
        return noMoreSplits.build();
    }

    private synchronized void checkTaskCompletion() {
        TaskState taskState = this.taskStateMachine.getState();
        if (taskState.isDone()) {
            return;
        }
        if (taskState.isTerminating()) {
            this.driverAndTaskTerminationTracker.checkTaskTermination();
            return;
        }
        if (this.remainingSplitRunners.get() != 0L) {
            return;
        }
        for (DriverSplitRunnerFactory driverSplitRunnerFactory : this.allDriverRunnerFactories) {
            if (driverSplitRunnerFactory.isNoMoreDrivers()) continue;
            return;
        }
        this.outputBuffer.setNoMorePages();
        BufferState bufferState = this.outputBuffer.getState();
        if (!bufferState.isTerminal()) {
            this.taskStateMachine.transitionToFlushing();
            return;
        }
        if (bufferState == BufferState.FINISHED) {
            this.taskStateMachine.finished();
            return;
        }
        if (bufferState == BufferState.FAILED) {
            Throwable failureCause = this.outputBuffer.getFailureCause().orElseGet(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Output buffer is failed but the failure cause is missing"));
            this.taskStateMachine.failed(failureCause);
            return;
        }
        this.taskStateMachine.failed(new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unexpected buffer state: " + bufferState));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).add("remainingSplitRunners", this.remainingSplitRunners.get()).add("liveCreatedDrivers", this.driverAndTaskTerminationTracker.getLiveCreatedDrivers()).toString();
    }

    private void checkHoldsLock() {
        if (!Thread.holdsLock(this)) {
            throw new IllegalStateException(String.format("Thread must hold a lock on the %s", this.getClass().getSimpleName()));
        }
    }

    private static final class DriverAndTaskTerminationTracker {
        private final TaskStateMachine taskStateMachine;
        private final AtomicLong liveCreatedDrivers = new AtomicLong();

        private DriverAndTaskTerminationTracker(TaskStateMachine taskStateMachine) {
            this.taskStateMachine = Objects.requireNonNull(taskStateMachine, "taskStateMachine is null");
        }

        public boolean tryCreateNewDriver() {
            this.liveCreatedDrivers.incrementAndGet();
            if (this.taskStateMachine.getState().isTerminatingOrDone()) {
                this.driverDestroyed();
                return false;
            }
            return true;
        }

        public void driverDestroyed() {
            if (this.liveCreatedDrivers.decrementAndGet() == 0L) {
                this.checkTaskTermination();
            }
        }

        public long getLiveCreatedDrivers() {
            return this.liveCreatedDrivers.get();
        }

        public void checkTaskTermination() {
            long liveCreatedDrivers;
            if (this.taskStateMachine.getState().isTerminating() && (liveCreatedDrivers = this.liveCreatedDrivers.get()) <= 0L) {
                this.taskStateMachine.terminationComplete();
                Preconditions.checkState((liveCreatedDrivers == 0L ? 1 : 0) != 0, (String)"liveCreatedDrivers is negative: %s", (long)liveCreatedDrivers);
            }
        }
    }

    private class DriverSplitRunnerFactory {
        private final DriverFactory driverFactory;
        private final PipelineContext pipelineContext;
        private final AtomicInteger pendingCreations = new AtomicInteger();
        private final AtomicBoolean noMoreDriverRunner = new AtomicBoolean();
        private final List<WeakReference<Driver>> driverReferences = new CopyOnWriteArrayList<WeakReference<Driver>>();
        private final Queue<ScheduledSplit> queuedSplits = new ConcurrentLinkedQueue<ScheduledSplit>();
        private final AtomicLong inFlightSplits = new AtomicLong();
        private final AtomicBoolean noMoreSplits = new AtomicBoolean();

        private DriverSplitRunnerFactory(DriverFactory driverFactory, boolean partitioned) {
            this.driverFactory = driverFactory;
            this.pipelineContext = SqlTaskExecution.this.taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver(), partitioned);
        }

        public DriverSplitRunner createPartitionedDriverRunner(ScheduledSplit partitionedSplit) {
            return this.createDriverRunner(partitionedSplit, partitionedSplit.getSplit().getSplitWeight().getRawValue());
        }

        public DriverSplitRunner createUnpartitionedDriverRunner() {
            return this.createDriverRunner(null, 0L);
        }

        public DriverSplitRunner createDriverRunner(@Nullable ScheduledSplit partitionedSplit, long splitWeight) {
            Preconditions.checkState((!this.noMoreDriverRunner.get() ? 1 : 0) != 0, (Object)"noMoreDriverRunner is set");
            this.pendingCreations.incrementAndGet();
            DriverContext driverContext = this.pipelineContext.addDriverContext(splitWeight);
            return new DriverSplitRunner(this, driverContext, partitionedSplit);
        }

        @Nullable
        public Driver createDriver(DriverContext driverContext, @Nullable ScheduledSplit partitionedSplit) {
            Driver driver;
            if (!SqlTaskExecution.this.driverAndTaskTerminationTracker.tryCreateNewDriver()) {
                return null;
            }
            try {
                driver = this.driverFactory.createDriver(driverContext);
            }
            catch (Throwable t) {
                try {
                    if (t instanceof Exception && this.driverFactory.isNoMoreDrivers()) {
                        Driver driver2 = null;
                        return driver2;
                    }
                    throw t;
                }
                finally {
                    SqlTaskExecution.this.driverAndTaskTerminationTracker.driverDestroyed();
                }
            }
            driver.getDestroyedFuture().addListener(SqlTaskExecution.this.driverAndTaskTerminationTracker::driverDestroyed, MoreExecutors.directExecutor());
            try {
                if (partitionedSplit != null) {
                    driver.updateSplitAssignment(new SplitAssignment(partitionedSplit.getPlanNodeId(), (Set<ScheduledSplit>)ImmutableSet.of((Object)partitionedSplit), true));
                }
                if (this.pendingCreations.decrementAndGet() == 0) {
                    this.closeDriverFactoryIfFullyCreated();
                }
                if (this.driverFactory.getSourceId().isPresent() && partitionedSplit == null) {
                    this.driverReferences.add(new WeakReference<Driver>(driver));
                    this.scheduleSplits();
                }
                return driver;
            }
            catch (Throwable failure) {
                block15: {
                    try {
                        driver.close();
                    }
                    catch (Throwable closeFailure) {
                        if (failure == closeFailure) break block15;
                        failure.addSuppressed(closeFailure);
                    }
                }
                throw failure;
            }
        }

        public void enqueueSplits(Set<ScheduledSplit> splits, boolean noMoreSplits) {
            Verify.verify((boolean)this.driverFactory.getSourceId().isPresent(), (String)"not a source driver", (Object[])new Object[0]);
            Verify.verify((!this.noMoreSplits.get() || splits.isEmpty() ? 1 : 0) != 0, (String)"cannot add splits after noMoreSplits is set", (Object[])new Object[0]);
            this.queuedSplits.addAll(splits);
            Verify.verify((!this.noMoreSplits.get() || noMoreSplits ? 1 : 0) != 0, (String)"cannot unset noMoreSplits", (Object[])new Object[0]);
            if (noMoreSplits) {
                this.noMoreSplits.set(true);
            }
        }

        public void scheduleSplits() {
            if (this.driverReferences.isEmpty()) {
                return;
            }
            PlanNodeId sourceId = this.driverFactory.getSourceId().orElseThrow();
            while (!this.queuedSplits.isEmpty()) {
                int activeDriversCount = 0;
                for (WeakReference<Driver> driverReference : this.driverReferences) {
                    Driver driver = (Driver)driverReference.get();
                    if (driver == null) continue;
                    ++activeDriversCount;
                    this.inFlightSplits.incrementAndGet();
                    ScheduledSplit split = this.queuedSplits.poll();
                    if (split == null) {
                        this.inFlightSplits.decrementAndGet();
                        break;
                    }
                    driver.updateSplitAssignment(new SplitAssignment(sourceId, (Set<ScheduledSplit>)ImmutableSet.of((Object)split), false));
                    this.inFlightSplits.decrementAndGet();
                }
                if (activeDriversCount != 0) continue;
                break;
            }
            if (this.noMoreSplits.get() && this.queuedSplits.isEmpty() && this.inFlightSplits.get() == 0L) {
                for (WeakReference<Driver> driverReference : this.driverReferences) {
                    Driver driver = (Driver)driverReference.get();
                    if (driver == null) continue;
                    driver.updateSplitAssignment(new SplitAssignment(sourceId, (Set<ScheduledSplit>)ImmutableSet.of(), true));
                }
            }
        }

        public boolean isNoMoreSplits() {
            return this.noMoreSplits.get();
        }

        public void noMoreDriverRunner() {
            this.noMoreDriverRunner.set(true);
            this.closeDriverFactoryIfFullyCreated();
        }

        public boolean isNoMoreDriverRunner() {
            return this.noMoreDriverRunner.get();
        }

        public void closeDriverFactoryIfFullyCreated() {
            if (this.driverFactory.isNoMoreDrivers()) {
                return;
            }
            if (this.isNoMoreDriverRunner() && this.pendingCreations.get() == 0) {
                this.driverFactory.noMoreDrivers();
            }
        }

        public boolean isNoMoreDrivers() {
            return this.driverFactory.isNoMoreDrivers();
        }

        public OptionalInt getDriverInstances() {
            return this.driverFactory.getDriverInstances();
        }

        public void splitsAdded(int count, long weightSum) {
            this.pipelineContext.splitsAdded(count, weightSum);
        }
    }

    private static final class CheckTaskCompletionOnBufferFinish
    implements StateMachine.StateChangeListener<BufferState> {
        private final WeakReference<SqlTaskExecution> sqlTaskExecutionReference;

        public CheckTaskCompletionOnBufferFinish(SqlTaskExecution sqlTaskExecution) {
            this.sqlTaskExecutionReference = new WeakReference<SqlTaskExecution>(sqlTaskExecution);
        }

        @Override
        public void stateChanged(BufferState newState) {
            SqlTaskExecution sqlTaskExecution;
            if (newState.isTerminal() && (sqlTaskExecution = (SqlTaskExecution)this.sqlTaskExecutionReference.get()) != null) {
                sqlTaskExecution.checkTaskCompletion();
            }
        }
    }

    @NotThreadSafe
    private static class PendingSplitsForPlanNode {
        private Set<ScheduledSplit> splits = new HashSet<ScheduledSplit>();
        private SplitsState state = SplitsState.ADDING_SPLITS;
        private boolean noMoreSplits;

        private PendingSplitsForPlanNode() {
        }

        public void setNoMoreSplits() {
            if (this.noMoreSplits) {
                return;
            }
            this.noMoreSplits = true;
            if (this.state == SplitsState.ADDING_SPLITS) {
                this.state = SplitsState.NO_MORE_SPLITS;
            }
        }

        public SplitsState getState() {
            return this.state;
        }

        public void addSplit(ScheduledSplit scheduledSplit) {
            Preconditions.checkState((this.state == SplitsState.ADDING_SPLITS ? 1 : 0) != 0);
            this.splits.add(scheduledSplit);
        }

        public Set<ScheduledSplit> removeAllSplits() {
            Preconditions.checkState((this.state == SplitsState.ADDING_SPLITS || this.state == SplitsState.NO_MORE_SPLITS ? 1 : 0) != 0);
            Set<ScheduledSplit> result = this.splits;
            this.splits = new HashSet<ScheduledSplit>();
            return result;
        }

        public void markAsCleanedUp() {
            Preconditions.checkState((boolean)this.splits.isEmpty());
            Preconditions.checkState((this.state == SplitsState.NO_MORE_SPLITS ? 1 : 0) != 0);
            this.state = SplitsState.FINISHED;
        }
    }

    private static class DriverSplitRunner
    implements SplitRunner {
        private final DriverSplitRunnerFactory driverSplitRunnerFactory;
        private final DriverContext driverContext;
        @GuardedBy(value="this")
        private boolean closed;
        @Nullable
        private final ScheduledSplit partitionedSplit;
        @GuardedBy(value="this")
        private Driver driver;

        private DriverSplitRunner(DriverSplitRunnerFactory driverSplitRunnerFactory, DriverContext driverContext, @Nullable ScheduledSplit partitionedSplit) {
            this.driverSplitRunnerFactory = Objects.requireNonNull(driverSplitRunnerFactory, "driverSplitRunnerFactory is null");
            this.driverContext = Objects.requireNonNull(driverContext, "driverContext is null");
            this.partitionedSplit = partitionedSplit;
        }

        public synchronized DriverContext getDriverContext() {
            if (this.driver == null) {
                return null;
            }
            return this.driver.getDriverContext();
        }

        @Override
        public synchronized boolean isFinished() {
            if (this.closed) {
                return true;
            }
            return this.driver != null && this.driver.isFinished();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListenableFuture<Void> processFor(Duration duration) {
            Driver driver;
            DriverSplitRunner driverSplitRunner = this;
            synchronized (driverSplitRunner) {
                if (this.closed) {
                    return Futures.immediateVoidFuture();
                }
                if (this.driver == null) {
                    this.driver = this.driverSplitRunnerFactory.createDriver(this.driverContext, this.partitionedSplit);
                    if (this.driver == null) {
                        this.closed = true;
                        return Futures.immediateVoidFuture();
                    }
                }
                driver = this.driver;
            }
            return driver.processForDuration(duration);
        }

        @Override
        public String getInfo() {
            return this.partitionedSplit == null ? "" : this.partitionedSplit.getSplit().getInfo().toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Driver driver;
            DriverSplitRunner driverSplitRunner = this;
            synchronized (driverSplitRunner) {
                this.closed = true;
                driver = this.driver;
            }
            if (driver != null) {
                driver.close();
            }
        }
    }

    static enum SplitsState {
        ADDING_SPLITS,
        NO_MORE_SPLITS,
        FINISHED;

    }
}

