/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.trino.execution.ManagedQueryExecution;
import io.trino.execution.resourcegroups.InternalResourceGroup;
import io.trino.execution.resourcegroups.LegacyResourceGroupConfigurationManager;
import io.trino.execution.resourcegroups.ResourceGroupConfigurationManagerContextInstance;
import io.trino.execution.resourcegroups.ResourceGroupManager;
import io.trino.server.ResourceGroupInfo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.memory.ClusterMemoryPoolManager;
import io.trino.spi.resourcegroups.ResourceGroup;
import io.trino.spi.resourcegroups.ResourceGroupConfigurationManager;
import io.trino.spi.resourcegroups.ResourceGroupConfigurationManagerContext;
import io.trino.spi.resourcegroups.ResourceGroupConfigurationManagerFactory;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.resourcegroups.SelectionContext;
import io.trino.spi.resourcegroups.SelectionCriteria;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.JmxException;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.Managed;

@ThreadSafe
public final class InternalResourceGroupManager<C>
implements ResourceGroupManager<C> {
    private static final Logger log = Logger.get(InternalResourceGroupManager.class);
    private static final File CONFIG_FILE = new File("etc/resource-groups.properties");
    private static final String NAME_PROPERTY = "resource-groups.configuration-manager";
    private final ScheduledExecutorService refreshExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"ResourceGroupManager"));
    private final List<InternalResourceGroup> rootGroups = new CopyOnWriteArrayList<InternalResourceGroup>();
    private final ConcurrentMap<ResourceGroupId, InternalResourceGroup> groups = new ConcurrentHashMap<ResourceGroupId, InternalResourceGroup>();
    private final AtomicReference<ResourceGroupConfigurationManager<C>> configurationManager;
    private final ResourceGroupConfigurationManagerContext configurationManagerContext;
    private final ResourceGroupConfigurationManager<?> legacyManager;
    private final MBeanExporter exporter;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicLong lastCpuQuotaGenerationNanos = new AtomicLong(System.nanoTime());
    private final Map<String, ResourceGroupConfigurationManagerFactory> configurationManagerFactories = new ConcurrentHashMap<String, ResourceGroupConfigurationManagerFactory>();

    @Inject
    public InternalResourceGroupManager(LegacyResourceGroupConfigurationManager legacyManager, ClusterMemoryPoolManager memoryPoolManager, NodeInfo nodeInfo, MBeanExporter exporter) {
        this.exporter = Objects.requireNonNull(exporter, "exporter is null");
        this.configurationManagerContext = new ResourceGroupConfigurationManagerContextInstance(memoryPoolManager, nodeInfo.getEnvironment());
        this.legacyManager = Objects.requireNonNull(legacyManager, "legacyManager is null");
        this.configurationManager = new AtomicReference<ResourceGroupConfigurationManager<C>>(InternalResourceGroupManager.cast(legacyManager));
    }

    @Override
    public Optional<ResourceGroupInfo> tryGetResourceGroupInfo(ResourceGroupId id) {
        InternalResourceGroup resourceGroup = (InternalResourceGroup)this.groups.get(id);
        return Optional.ofNullable(resourceGroup).map(InternalResourceGroup::getFullInfo);
    }

    @Override
    public Optional<List<ResourceGroupInfo>> tryGetPathToRoot(ResourceGroupId id) {
        InternalResourceGroup resourceGroup = (InternalResourceGroup)this.groups.get(id);
        return Optional.ofNullable(resourceGroup).map(InternalResourceGroup::getPathToRoot);
    }

    @Override
    public void submit(ManagedQueryExecution queryExecution, SelectionContext<C> selectionContext, Executor executor) {
        Preconditions.checkState((this.configurationManager.get() != null ? 1 : 0) != 0, (Object)"configurationManager not set");
        this.createGroupIfNecessary(selectionContext, executor);
        ((InternalResourceGroup)this.groups.get(selectionContext.getResourceGroupId())).run(queryExecution);
    }

    @Override
    public SelectionContext<C> selectGroup(SelectionCriteria criteria) {
        return (SelectionContext)this.configurationManager.get().match(criteria).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, "Query did not match any selection rule"));
    }

    @Override
    public void addConfigurationManagerFactory(ResourceGroupConfigurationManagerFactory factory) {
        if (this.configurationManagerFactories.putIfAbsent(factory.getName(), factory) != null) {
            throw new IllegalArgumentException(String.format("Resource group configuration manager '%s' is already registered", factory.getName()));
        }
    }

    @Override
    public void loadConfigurationManager() throws Exception {
        File configFile = CONFIG_FILE.getAbsoluteFile();
        if (!configFile.exists()) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>(ConfigurationLoader.loadPropertiesFrom((String)configFile.getPath()));
        String name = (String)properties.remove(NAME_PROPERTY);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (String)"Resource groups configuration %s does not contain '%s'", (Object)configFile, (Object)NAME_PROPERTY);
        this.setConfigurationManager(name, properties);
    }

    @VisibleForTesting
    public void setConfigurationManager(String name, Map<String, String> properties) {
        ResourceGroupConfigurationManager<C> configurationManager;
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(properties, "properties is null");
        log.info("-- Loading resource group configuration manager --");
        ResourceGroupConfigurationManagerFactory factory = this.configurationManagerFactories.get(name);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"Resource group configuration manager '%s' is not registered", (Object)name);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(factory.getClass().getClassLoader());){
            configurationManager = InternalResourceGroupManager.cast(factory.create((Map)ImmutableMap.copyOf(properties), this.configurationManagerContext));
        }
        Preconditions.checkState((boolean)this.configurationManager.compareAndSet(InternalResourceGroupManager.cast(this.legacyManager), configurationManager), (Object)"configurationManager already set");
        log.info("-- Loaded resource group configuration manager %s --", new Object[]{name});
    }

    @VisibleForTesting
    public ResourceGroupConfigurationManager<C> getConfigurationManager() {
        ResourceGroupConfigurationManager<C> manager = this.configurationManager.get();
        Preconditions.checkState((manager != this.legacyManager ? 1 : 0) != 0, (Object)"cannot fetch legacy manager");
        return manager;
    }

    @PreDestroy
    public void destroy() {
        this.refreshExecutor.shutdownNow();
    }

    @PostConstruct
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.refreshExecutor.scheduleWithFixedDelay(this::refreshAndStartQueries, 1L, 100L, TimeUnit.MILLISECONDS);
        }
    }

    private void refreshAndStartQueries() {
        long nanoTime = System.nanoTime();
        long elapsedSeconds = TimeUnit.NANOSECONDS.toSeconds(nanoTime - this.lastCpuQuotaGenerationNanos.get());
        if (elapsedSeconds > 0L) {
            this.lastCpuQuotaGenerationNanos.addAndGet(elapsedSeconds * 1000000000L);
        } else if (elapsedSeconds < 0L) {
            this.lastCpuQuotaGenerationNanos.set(nanoTime);
        }
        for (InternalResourceGroup group : this.rootGroups) {
            try {
                if (elapsedSeconds > 0L) {
                    group.generateCpuQuota(elapsedSeconds);
                }
            }
            catch (RuntimeException e) {
                log.error((Throwable)e, "Exception while generation cpu quota for %s", new Object[]{group});
            }
            try {
                group.updateGroupsAndProcessQueuedQueries();
            }
            catch (RuntimeException e) {
                log.error((Throwable)e, "Exception while processing queued queries for %s", new Object[]{group});
            }
        }
    }

    private synchronized void createGroupIfNecessary(SelectionContext<C> context, Executor executor) {
        ResourceGroupId id = context.getResourceGroupId();
        if (!this.groups.containsKey(id)) {
            InternalResourceGroup group;
            if (id.getParent().isPresent()) {
                this.createGroupIfNecessary(this.configurationManager.get().parentGroupContext(context), executor);
                InternalResourceGroup parent = (InternalResourceGroup)this.groups.get(id.getParent().get());
                Objects.requireNonNull(parent, "parent is null");
                group = parent.getOrCreateSubGroup(id.getLastSegment());
            } else {
                InternalResourceGroup root;
                group = root = new InternalResourceGroup((String)id.getSegments().get(0), this::exportGroup, executor);
                this.rootGroups.add(root);
            }
            this.configurationManager.get().configure((ResourceGroup)group, context);
            Preconditions.checkState((this.groups.put(id, group) == null ? 1 : 0) != 0, (Object)"Unexpected existing resource group");
        }
    }

    private void exportGroup(InternalResourceGroup group, Boolean export) {
        try {
            if (export.booleanValue()) {
                this.exporter.exportWithGeneratedName((Object)group, InternalResourceGroup.class, group.getId().toString());
            } else {
                this.exporter.unexportWithGeneratedName(InternalResourceGroup.class, group.getId().toString());
            }
        }
        catch (JmxException e) {
            log.error((Throwable)e, "Error %s resource group %s", new Object[]{export != false ? "exporting" : "unexporting", group.getId()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getQueriesQueuedOnInternal() {
        int queriesQueuedInternal = 0;
        Iterator<InternalResourceGroup> iterator = this.rootGroups.iterator();
        while (iterator.hasNext()) {
            InternalResourceGroup rootGroup;
            InternalResourceGroup internalResourceGroup = rootGroup = iterator.next();
            synchronized (internalResourceGroup) {
                queriesQueuedInternal += InternalResourceGroupManager.getQueriesQueuedOnInternal(rootGroup);
            }
        }
        return queriesQueuedInternal;
    }

    private static int getQueriesQueuedOnInternal(InternalResourceGroup resourceGroup) {
        if (resourceGroup.subGroups().isEmpty()) {
            return Math.min(resourceGroup.getQueuedQueries(), resourceGroup.getSoftConcurrencyLimit() - resourceGroup.getRunningQueries());
        }
        int queriesQueuedInternal = 0;
        for (InternalResourceGroup subGroup : resourceGroup.subGroups()) {
            queriesQueuedInternal += InternalResourceGroupManager.getQueriesQueuedOnInternal(subGroup);
        }
        return queriesQueuedInternal;
    }

    private static <C> ResourceGroupConfigurationManager<C> cast(ResourceGroupConfigurationManager<?> manager) {
        return manager;
    }
}

