/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import io.trino.exchange.SpoolingExchangeInput;
import io.trino.execution.scheduler.NodeRequirements;
import io.trino.execution.scheduler.SplitAssigner;
import io.trino.metadata.Split;
import io.trino.operator.ExchangeOperator;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.exchange.ExchangeSourceHandle;
import io.trino.split.RemoteSplit;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class ArbitraryDistributionSplitAssigner
implements SplitAssigner {
    private final Optional<CatalogHandle> catalogRequirement;
    private final Set<PlanNodeId> partitionedSources;
    private final Set<PlanNodeId> replicatedSources;
    private final Set<PlanNodeId> allSources;
    private final long targetPartitionSizeInBytes;
    private final long standardSplitSizeInBytes;
    private final int maxTaskSplitCount;
    private int nextPartitionId;
    private final List<PartitionAssignment> allAssignments = new ArrayList<PartitionAssignment>();
    private final Map<Optional<HostAddress>, PartitionAssignment> openAssignments = new HashMap<Optional<HostAddress>, PartitionAssignment>();
    private final Set<PlanNodeId> completedSources = new HashSet<PlanNodeId>();
    private final ListMultimap<PlanNodeId, Split> replicatedSplits = ArrayListMultimap.create();
    private boolean noMoreReplicatedSplits;

    ArbitraryDistributionSplitAssigner(Optional<CatalogHandle> catalogRequirement, Set<PlanNodeId> partitionedSources, Set<PlanNodeId> replicatedSources, long targetPartitionSizeInBytes, long standardSplitSizeInBytes, int maxTaskSplitCount) {
        this.catalogRequirement = Objects.requireNonNull(catalogRequirement, "catalogRequirement is null");
        this.partitionedSources = ImmutableSet.copyOf((Collection)Objects.requireNonNull(partitionedSources, "partitionedSources is null"));
        this.replicatedSources = ImmutableSet.copyOf((Collection)Objects.requireNonNull(replicatedSources, "replicatedSources is null"));
        this.allSources = ImmutableSet.builder().addAll(partitionedSources).addAll(replicatedSources).build();
        this.targetPartitionSizeInBytes = targetPartitionSizeInBytes;
        this.standardSplitSizeInBytes = standardSplitSizeInBytes;
        this.maxTaskSplitCount = maxTaskSplitCount;
    }

    @Override
    public SplitAssigner.AssignmentResult assign(PlanNodeId planNodeId, ListMultimap<Integer, Split> splits, boolean noMoreSplits) {
        for (Split split : splits.values()) {
            Optional<CatalogHandle> splitCatalogRequirement = Optional.of(split.getCatalogHandle()).filter(catalog -> !catalog.getType().isInternal() && !catalog.equals((Object)ExchangeOperator.REMOTE_CATALOG_HANDLE));
            Preconditions.checkArgument((this.catalogRequirement.isEmpty() || this.catalogRequirement.equals(splitCatalogRequirement) ? 1 : 0) != 0, (String)"unexpected split catalog requirement: %s", splitCatalogRequirement);
        }
        if (this.replicatedSources.contains(planNodeId)) {
            return this.assignReplicatedSplits(planNodeId, (List<Split>)ImmutableList.copyOf((Collection)splits.values()), noMoreSplits);
        }
        return this.assignPartitionedSplits(planNodeId, (List<Split>)ImmutableList.copyOf((Collection)splits.values()), noMoreSplits);
    }

    @Override
    public SplitAssigner.AssignmentResult finish() {
        Preconditions.checkState((!this.allAssignments.isEmpty() ? 1 : 0) != 0, (Object)"allAssignments is not expected to be empty");
        return SplitAssigner.AssignmentResult.builder().build();
    }

    private SplitAssigner.AssignmentResult assignReplicatedSplits(PlanNodeId planNodeId, List<Split> splits, boolean noMoreSplits) {
        SplitAssigner.AssignmentResult.Builder assignment = SplitAssigner.AssignmentResult.builder();
        this.replicatedSplits.putAll((Object)planNodeId, splits);
        for (PartitionAssignment partitionAssignment : this.allAssignments) {
            assignment.updatePartition(new SplitAssigner.PartitionUpdate(partitionAssignment.getPartitionId(), planNodeId, splits, noMoreSplits));
        }
        if (noMoreSplits) {
            this.completedSources.add(planNodeId);
            if (this.completedSources.containsAll(this.replicatedSources)) {
                this.noMoreReplicatedSplits = true;
            }
        }
        if (this.noMoreReplicatedSplits) {
            for (PartitionAssignment partitionAssignment : this.allAssignments) {
                if (!partitionAssignment.isFull()) continue;
                assignment.sealPartition(partitionAssignment.getPartitionId());
            }
        }
        if (this.completedSources.containsAll(this.allSources)) {
            if (this.allAssignments.isEmpty()) {
                this.allAssignments.add(new PartitionAssignment(0));
                assignment.addPartition(new SplitAssigner.Partition(0, new NodeRequirements(this.catalogRequirement, (Set<HostAddress>)ImmutableSet.of())));
                for (PlanNodeId replicatedSourceId : this.replicatedSources) {
                    assignment.updatePartition(new SplitAssigner.PartitionUpdate(0, replicatedSourceId, this.replicatedSplits.get((Object)replicatedSourceId), true));
                }
                for (PlanNodeId partitionedSourceId : this.partitionedSources) {
                    assignment.updatePartition(new SplitAssigner.PartitionUpdate(0, partitionedSourceId, (List<Split>)ImmutableList.of(), true));
                }
                assignment.sealPartition(0);
            } else {
                for (PartitionAssignment partitionAssignment : this.allAssignments) {
                    if (partitionAssignment.isFull()) continue;
                    for (PlanNodeId partitionedSourceNodeId : this.partitionedSources) {
                        assignment.updatePartition(new SplitAssigner.PartitionUpdate(partitionAssignment.getPartitionId(), partitionedSourceNodeId, (List<Split>)ImmutableList.of(), true));
                    }
                    assignment.sealPartition(partitionAssignment.getPartitionId());
                }
            }
            this.replicatedSplits.clear();
            assignment.setNoMorePartitions();
        }
        return assignment.build();
    }

    private SplitAssigner.AssignmentResult assignPartitionedSplits(PlanNodeId planNodeId, List<Split> splits, boolean noMoreSplits) {
        SplitAssigner.AssignmentResult.Builder assignment = SplitAssigner.AssignmentResult.builder();
        for (Split split : splits) {
            Optional<HostAddress> hostRequirement = this.getHostRequirement(split);
            PartitionAssignment partitionAssignment = this.openAssignments.get(hostRequirement);
            long splitSizeInBytes = this.getSplitSizeInBytes(split);
            if (partitionAssignment != null && (partitionAssignment.getAssignedDataSizeInBytes() + splitSizeInBytes > this.targetPartitionSizeInBytes || partitionAssignment.getAssignedSplitCount() + 1 > this.maxTaskSplitCount)) {
                partitionAssignment.setFull(true);
                for (PlanNodeId partitionedSourceNodeId : this.partitionedSources) {
                    assignment.updatePartition(new SplitAssigner.PartitionUpdate(partitionAssignment.getPartitionId(), partitionedSourceNodeId, (List<Split>)ImmutableList.of(), true));
                }
                if (this.completedSources.containsAll(this.replicatedSources)) {
                    assignment.sealPartition(partitionAssignment.getPartitionId());
                }
                partitionAssignment = null;
                this.openAssignments.remove(hostRequirement);
            }
            if (partitionAssignment == null) {
                partitionAssignment = new PartitionAssignment(this.nextPartitionId++);
                this.allAssignments.add(partitionAssignment);
                this.openAssignments.put(hostRequirement, partitionAssignment);
                assignment.addPartition(new SplitAssigner.Partition(partitionAssignment.getPartitionId(), new NodeRequirements(this.catalogRequirement, (Set)hostRequirement.map(ImmutableSet::of).orElseGet(ImmutableSet::of))));
                for (PlanNodeId replicatedSourceId : this.replicatedSources) {
                    assignment.updatePartition(new SplitAssigner.PartitionUpdate(partitionAssignment.getPartitionId(), replicatedSourceId, this.replicatedSplits.get((Object)replicatedSourceId), this.completedSources.contains(replicatedSourceId)));
                }
            }
            assignment.updatePartition(new SplitAssigner.PartitionUpdate(partitionAssignment.getPartitionId(), planNodeId, (List<Split>)ImmutableList.of((Object)split), false));
            partitionAssignment.assignSplit(splitSizeInBytes);
        }
        if (noMoreSplits) {
            this.completedSources.add(planNodeId);
        }
        if (this.completedSources.containsAll(this.allSources)) {
            if (this.allAssignments.isEmpty()) {
                this.allAssignments.add(new PartitionAssignment(0));
                assignment.addPartition(new SplitAssigner.Partition(0, new NodeRequirements(this.catalogRequirement, (Set<HostAddress>)ImmutableSet.of())));
                for (PlanNodeId replicatedSourceId : this.replicatedSources) {
                    assignment.updatePartition(new SplitAssigner.PartitionUpdate(0, replicatedSourceId, this.replicatedSplits.get((Object)replicatedSourceId), true));
                }
                for (PlanNodeId partitionedSourceId : this.partitionedSources) {
                    assignment.updatePartition(new SplitAssigner.PartitionUpdate(0, partitionedSourceId, (List<Split>)ImmutableList.of(), true));
                }
                assignment.sealPartition(0);
            } else {
                for (PartitionAssignment partitionAssignment : this.openAssignments.values()) {
                    for (PlanNodeId partitionedSourceNodeId : this.partitionedSources) {
                        assignment.updatePartition(new SplitAssigner.PartitionUpdate(partitionAssignment.getPartitionId(), partitionedSourceNodeId, (List<Split>)ImmutableList.of(), true));
                    }
                    assignment.sealPartition(partitionAssignment.getPartitionId());
                }
                this.openAssignments.clear();
            }
            this.replicatedSplits.clear();
            assignment.setNoMorePartitions();
        }
        return assignment.build();
    }

    private Optional<HostAddress> getHostRequirement(Split split) {
        if (split.getConnectorSplit().isRemotelyAccessible()) {
            return Optional.empty();
        }
        List<HostAddress> addresses = split.getAddresses();
        Preconditions.checkArgument((!addresses.isEmpty() ? 1 : 0) != 0, (String)"split is not remotely accessible but the list of hosts is empty: %s", (Object)split);
        HostAddress selectedAddress = null;
        long selectedAssignmentDataSize = Long.MAX_VALUE;
        for (HostAddress address : addresses) {
            PartitionAssignment assignment = this.openAssignments.get(Optional.of(address));
            if (assignment == null) {
                selectedAddress = address;
                break;
            }
            if (assignment.getAssignedDataSizeInBytes() >= selectedAssignmentDataSize) continue;
            selectedAddress = address;
            selectedAssignmentDataSize = assignment.getAssignedDataSizeInBytes();
        }
        Verify.verify((selectedAddress != null ? 1 : 0) != 0, (String)"selectedAddress is null", (Object[])new Object[0]);
        return Optional.of(selectedAddress);
    }

    private long getSplitSizeInBytes(Split split) {
        if (split.getCatalogHandle().equals((Object)ExchangeOperator.REMOTE_CATALOG_HANDLE)) {
            RemoteSplit remoteSplit = (RemoteSplit)split.getConnectorSplit();
            SpoolingExchangeInput exchangeInput = (SpoolingExchangeInput)remoteSplit.getExchangeInput();
            long size = 0L;
            for (ExchangeSourceHandle handle : exchangeInput.getExchangeSourceHandles()) {
                size += handle.getDataSizeInBytes();
            }
            return size;
        }
        return Math.round((double)split.getSplitWeight().getRawValue() * 1.0 / (double)SplitWeight.standard().getRawValue() * (double)this.standardSplitSizeInBytes);
    }

    private static class PartitionAssignment {
        private final int partitionId;
        private long assignedDataSizeInBytes;
        private int assignedSplitCount;
        private boolean full;

        private PartitionAssignment(int partitionId) {
            this.partitionId = partitionId;
        }

        public int getPartitionId() {
            return this.partitionId;
        }

        public void assignSplit(long sizeInBytes) {
            this.assignedDataSizeInBytes += sizeInBytes;
            ++this.assignedSplitCount;
        }

        public long getAssignedDataSizeInBytes() {
            return this.assignedDataSizeInBytes;
        }

        public int getAssignedSplitCount() {
            return this.assignedSplitCount;
        }

        public boolean isFull() {
            return this.full;
        }

        public void setFull(boolean full) {
            this.full = full;
        }
    }
}

