/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.execution.scheduler.FaultTolerantPartitioningScheme;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import io.trino.spi.Node;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.sql.planner.MergePartitioningHandle;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.SystemPartitioningHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FaultTolerantPartitioningSchemeFactory {
    private final NodePartitioningManager nodePartitioningManager;
    private final Session session;
    private final int partitionCount;
    private final Map<PartitioningHandle, FaultTolerantPartitioningScheme> cache = new HashMap<PartitioningHandle, FaultTolerantPartitioningScheme>();

    public FaultTolerantPartitioningSchemeFactory(NodePartitioningManager nodePartitioningManager, Session session, int partitionCount) {
        this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.partitionCount = partitionCount;
    }

    public FaultTolerantPartitioningScheme get(PartitioningHandle handle) {
        FaultTolerantPartitioningScheme result = this.cache.get(handle);
        if (result == null) {
            result = this.create(handle);
            this.cache.put(handle, result);
        }
        return result;
    }

    private FaultTolerantPartitioningScheme create(PartitioningHandle partitioningHandle) {
        ConnectorPartitioningHandle connectorPartitioningHandle = partitioningHandle.getConnectorHandle();
        if (connectorPartitioningHandle instanceof MergePartitioningHandle) {
            MergePartitioningHandle mergePartitioningHandle = (MergePartitioningHandle)connectorPartitioningHandle;
            return mergePartitioningHandle.getFaultTolerantPartitioningScheme(this::get);
        }
        if (partitioningHandle.equals(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION) || partitioningHandle.equals(SystemPartitioningHandle.SCALED_WRITER_HASH_DISTRIBUTION)) {
            return FaultTolerantPartitioningSchemeFactory.createSystemSchema(this.partitionCount);
        }
        if (partitioningHandle.getCatalogHandle().isPresent()) {
            Optional<ConnectorBucketNodeMap> connectorBucketNodeMap = this.nodePartitioningManager.getConnectorBucketNodeMap(this.session, partitioningHandle);
            if (connectorBucketNodeMap.isEmpty()) {
                return FaultTolerantPartitioningSchemeFactory.createSystemSchema(this.partitionCount);
            }
            ToIntFunction<Split> splitToBucket = this.nodePartitioningManager.getSplitToBucket(this.session, partitioningHandle);
            return FaultTolerantPartitioningSchemeFactory.createConnectorSpecificSchema(this.partitionCount, connectorBucketNodeMap.get(), splitToBucket);
        }
        return new FaultTolerantPartitioningScheme(1, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static FaultTolerantPartitioningScheme createSystemSchema(int partitionCount) {
        return new FaultTolerantPartitioningScheme(partitionCount, Optional.of(IntStream.range(0, partitionCount).toArray()), Optional.empty(), Optional.empty());
    }

    private static FaultTolerantPartitioningScheme createConnectorSpecificSchema(int partitionCount, ConnectorBucketNodeMap bucketNodeMap, ToIntFunction<Split> splitToBucket) {
        if (bucketNodeMap.hasFixedMapping()) {
            return FaultTolerantPartitioningSchemeFactory.createFixedConnectorSpecificSchema(bucketNodeMap.getFixedMapping(), splitToBucket);
        }
        return FaultTolerantPartitioningSchemeFactory.createArbitraryConnectorSpecificSchema(partitionCount, bucketNodeMap.getBucketCount(), splitToBucket);
    }

    private static FaultTolerantPartitioningScheme createFixedConnectorSpecificSchema(List<Node> fixedMapping, ToIntFunction<Split> splitToBucket) {
        int bucketCount = fixedMapping.size();
        int[] bucketToPartition = new int[bucketCount];
        HashMap<InternalNode, Integer> nodeToPartition = new HashMap<InternalNode, Integer>();
        ArrayList<InternalNode> partitionToNodeMap = new ArrayList<InternalNode>();
        for (int bucket = 0; bucket < bucketCount; ++bucket) {
            InternalNode node = (InternalNode)fixedMapping.get(bucket);
            Integer partitionId = (Integer)nodeToPartition.get(node);
            if (partitionId == null) {
                partitionId = partitionToNodeMap.size();
                nodeToPartition.put(node, partitionId);
                partitionToNodeMap.add(node);
            }
            bucketToPartition[bucket] = partitionId;
        }
        return new FaultTolerantPartitioningScheme(partitionToNodeMap.size(), Optional.of(bucketToPartition), Optional.of(splitToBucket), Optional.of(ImmutableList.copyOf(partitionToNodeMap)));
    }

    private static FaultTolerantPartitioningScheme createArbitraryConnectorSpecificSchema(int partitionCount, int bucketCount, ToIntFunction<Split> splitToBucket) {
        int[] bucketToPartition = new int[bucketCount];
        for (int bucket = 0; bucket < bucketCount; ++bucket) {
            bucketToPartition[bucket] = bucket % partitionCount;
        }
        return new FaultTolerantPartitioningScheme(partitionCount, Optional.of(bucketToPartition), Optional.of(splitToBucket), Optional.empty());
    }
}

