/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.collect.cache.CacheUtils;
import io.trino.collect.cache.NonEvictableCache;
import io.trino.collect.cache.SafeCaches;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.scheduler.NetworkLocation;
import io.trino.execution.scheduler.NodeMap;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.NodeSelector;
import io.trino.execution.scheduler.NodeSelectorFactory;
import io.trino.execution.scheduler.UniformNodeSelector;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.NodeState;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.CatalogHandle;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class UniformNodeSelectorFactory
implements NodeSelectorFactory {
    private static final Logger LOG = Logger.get(UniformNodeSelectorFactory.class);
    private final NonEvictableCache<InternalNode, Object> inaccessibleNodeLogCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS));
    private final InternalNodeManager nodeManager;
    private final int minCandidates;
    private final boolean includeCoordinator;
    private final long maxSplitsWeightPerNode;
    private final long minPendingSplitsWeightPerTask;
    private final long maxAdjustedPendingSplitsWeightPerTask;
    private final NodeSchedulerConfig.SplitsBalancingPolicy splitsBalancingPolicy;
    private final boolean optimizedLocalScheduling;
    private final NodeTaskMap nodeTaskMap;
    private final Duration nodeMapMemoizationDuration;

    @Inject
    public UniformNodeSelectorFactory(InternalNodeManager nodeManager, NodeSchedulerConfig config, NodeTaskMap nodeTaskMap) {
        this(nodeManager, config, nodeTaskMap, new Duration(5.0, TimeUnit.SECONDS));
    }

    @VisibleForTesting
    UniformNodeSelectorFactory(InternalNodeManager nodeManager, NodeSchedulerConfig config, NodeTaskMap nodeTaskMap, Duration nodeMapMemoizationDuration) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.minCandidates = config.getMinCandidates();
        this.includeCoordinator = config.isIncludeCoordinator();
        this.splitsBalancingPolicy = config.getSplitsBalancingPolicy();
        this.optimizedLocalScheduling = config.getOptimizedLocalScheduling();
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        int maxSplitsPerNode = config.getMaxSplitsPerNode();
        int minPendingSplitsPerTask = config.getMinPendingSplitsPerTask();
        int maxAdjustedPendingSplitsWeightPerTask = config.getMaxAdjustedPendingSplitsWeightPerTask();
        Preconditions.checkArgument((maxSplitsPerNode >= minPendingSplitsPerTask ? 1 : 0) != 0, (Object)"maxSplitsPerNode must be > minPendingSplitsPerTask");
        Preconditions.checkArgument((maxAdjustedPendingSplitsWeightPerTask >= minPendingSplitsPerTask ? 1 : 0) != 0, (Object)"maxPendingSplitsPerTask must be >= minPendingSplitsPerTask");
        this.maxSplitsWeightPerNode = SplitWeight.rawValueForStandardSplitCount((int)maxSplitsPerNode);
        this.minPendingSplitsWeightPerTask = SplitWeight.rawValueForStandardSplitCount((int)minPendingSplitsPerTask);
        this.maxAdjustedPendingSplitsWeightPerTask = SplitWeight.rawValueForStandardSplitCount((int)maxAdjustedPendingSplitsWeightPerTask);
        this.nodeMapMemoizationDuration = nodeMapMemoizationDuration;
    }

    @Override
    public NodeSelector createNodeSelector(Session session, Optional<CatalogHandle> catalogHandle) {
        Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        Supplier nodeMap = this.nodeMapMemoizationDuration.toMillis() > 0L ? Suppliers.memoizeWithExpiration(() -> this.createNodeMap(catalogHandle), (long)this.nodeMapMemoizationDuration.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS) : () -> this.createNodeMap(catalogHandle);
        return new UniformNodeSelector(this.nodeManager, this.nodeTaskMap, this.includeCoordinator, (java.util.function.Supplier<NodeMap>)nodeMap, this.minCandidates, this.maxSplitsWeightPerNode, this.minPendingSplitsWeightPerTask, this.maxAdjustedPendingSplitsWeightPerTask, SystemSessionProperties.getMaxUnacknowledgedSplitsPerTask(session), this.splitsBalancingPolicy, this.optimizedLocalScheduling);
    }

    private NodeMap createNodeMap(Optional<CatalogHandle> catalogHandle) {
        Set nodes = catalogHandle.map(this.nodeManager::getActiveCatalogNodes).orElseGet(() -> this.nodeManager.getNodes(NodeState.ACTIVE));
        Set coordinatorNodeIds = (Set)this.nodeManager.getCoordinators().stream().map(InternalNode::getNodeIdentifier).collect(ImmutableSet.toImmutableSet());
        ImmutableSetMultimap.Builder byHostAndPort = ImmutableSetMultimap.builder();
        ImmutableSetMultimap.Builder byHost = ImmutableSetMultimap.builder();
        for (InternalNode node : nodes) {
            try {
                byHostAndPort.put((Object)node.getHostAndPort(), (Object)node);
                byHost.put((Object)node.getInternalAddress(), (Object)node);
            }
            catch (UnknownHostException e) {
                if (!this.markInaccessibleNode(node)) continue;
                LOG.warn((Throwable)e, "Unable to resolve host name for node: %s", new Object[]{node});
            }
        }
        return new NodeMap((SetMultimap<HostAddress, InternalNode>)byHostAndPort.build(), (SetMultimap<InetAddress, InternalNode>)byHost.build(), (SetMultimap<NetworkLocation, InternalNode>)ImmutableSetMultimap.of(), coordinatorNodeIds);
    }

    private boolean markInaccessibleNode(InternalNode node) {
        Object marker = new Object();
        return CacheUtils.uncheckedCacheGet(this.inaccessibleNodeLogCache, (Object)node, () -> marker) == marker;
    }
}

