/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.json.CachingResolver;
import io.trino.json.JsonEmptySequenceNode;
import io.trino.json.JsonPathEvaluator;
import io.trino.json.PathEvaluationContext;
import io.trino.json.PathEvaluationError;
import io.trino.json.PathEvaluationUtil;
import io.trino.json.PathPredicateEvaluationVisitor;
import io.trino.json.ir.IrAbsMethod;
import io.trino.json.ir.IrArithmeticBinary;
import io.trino.json.ir.IrArithmeticUnary;
import io.trino.json.ir.IrArrayAccessor;
import io.trino.json.ir.IrCeilingMethod;
import io.trino.json.ir.IrConstantJsonSequence;
import io.trino.json.ir.IrContextVariable;
import io.trino.json.ir.IrDatetimeMethod;
import io.trino.json.ir.IrDoubleMethod;
import io.trino.json.ir.IrFilter;
import io.trino.json.ir.IrFloorMethod;
import io.trino.json.ir.IrJsonNull;
import io.trino.json.ir.IrJsonPathVisitor;
import io.trino.json.ir.IrKeyValueMethod;
import io.trino.json.ir.IrLastIndexVariable;
import io.trino.json.ir.IrLiteral;
import io.trino.json.ir.IrMemberAccessor;
import io.trino.json.ir.IrNamedJsonVariable;
import io.trino.json.ir.IrNamedValueVariable;
import io.trino.json.ir.IrPathNode;
import io.trino.json.ir.IrPredicateCurrentItemVariable;
import io.trino.json.ir.IrSizeMethod;
import io.trino.json.ir.IrTypeMethod;
import io.trino.json.ir.SqlJsonLiteralConverter;
import io.trino.json.ir.TypedValue;
import io.trino.operator.scalar.MathFunctions;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalConversions;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.Int128Math;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.BigintOperators;
import io.trino.type.DecimalCasts;
import io.trino.type.DecimalOperators;
import io.trino.type.DoubleOperators;
import io.trino.type.IntegerOperators;
import io.trino.type.RealOperators;
import io.trino.type.SmallintOperators;
import io.trino.type.TinyintOperators;
import io.trino.type.VarcharOperators;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class PathEvaluationVisitor
extends IrJsonPathVisitor<List<Object>, PathEvaluationContext> {
    private final boolean lax;
    private final JsonNode input;
    private final Object[] parameters;
    private final PathPredicateEvaluationVisitor predicateVisitor;
    private final JsonPathEvaluator.Invoker invoker;
    private final CachingResolver resolver;
    private int objectId;

    public PathEvaluationVisitor(boolean lax, JsonNode input, Object[] parameters, JsonPathEvaluator.Invoker invoker, CachingResolver resolver) {
        this.lax = lax;
        this.input = Objects.requireNonNull(input, "input is null");
        this.parameters = Objects.requireNonNull(parameters, "parameters is null");
        this.invoker = Objects.requireNonNull(invoker, "invoker is null");
        this.resolver = Objects.requireNonNull(resolver, "resolver is null");
        this.predicateVisitor = new PathPredicateEvaluationVisitor(lax, this, invoker, resolver);
    }

    @Override
    protected List<Object> visitIrPathNode(IrPathNode node, PathEvaluationContext context) {
        throw new UnsupportedOperationException("JSON path evaluating visitor not implemented for " + node.getClass().getSimpleName());
    }

    @Override
    protected List<Object> visitIrAbsMethod(IrAbsMethod node, PathEvaluationContext context) {
        List<Object> sequence = (List<Object>)this.process(node.getBase(), context);
        if (this.lax) {
            sequence = PathEvaluationUtil.unwrapArrays(sequence);
        }
        ImmutableList.Builder outputSequence = ImmutableList.builder();
        for (Object object : sequence) {
            TypedValue value = object instanceof JsonNode ? PathEvaluationVisitor.getNumericTypedValue((JsonNode)object).orElseThrow(() -> PathEvaluationError.itemTypeError("NUMBER", ((JsonNode)object).getNodeType().name())) : (TypedValue)object;
            outputSequence.add((Object)PathEvaluationVisitor.getAbsoluteValue(value));
        }
        return outputSequence.build();
    }

    private static TypedValue getAbsoluteValue(TypedValue typedValue) {
        Type type = typedValue.getType();
        if (type.equals(BigintType.BIGINT)) {
            long absValue;
            long value = typedValue.getLongValue();
            if (value >= 0L) {
                return typedValue;
            }
            try {
                absValue = MathFunctions.abs(value);
            }
            catch (Exception e) {
                throw new PathEvaluationError(e);
            }
            return new TypedValue(type, absValue);
        }
        if (type.equals(IntegerType.INTEGER)) {
            long absValue;
            long value = typedValue.getLongValue();
            if (value >= 0L) {
                return typedValue;
            }
            try {
                absValue = MathFunctions.absInteger(value);
            }
            catch (Exception e) {
                throw new PathEvaluationError(e);
            }
            return new TypedValue(type, absValue);
        }
        if (type.equals(SmallintType.SMALLINT)) {
            long absValue;
            long value = typedValue.getLongValue();
            if (value >= 0L) {
                return typedValue;
            }
            try {
                absValue = MathFunctions.absSmallint(value);
            }
            catch (Exception e) {
                throw new PathEvaluationError(e);
            }
            return new TypedValue(type, absValue);
        }
        if (type.equals(TinyintType.TINYINT)) {
            long absValue;
            long value = typedValue.getLongValue();
            if (value >= 0L) {
                return typedValue;
            }
            try {
                absValue = MathFunctions.absTinyint(value);
            }
            catch (Exception e) {
                throw new PathEvaluationError(e);
            }
            return new TypedValue(type, absValue);
        }
        if (type.equals(DoubleType.DOUBLE)) {
            double value = typedValue.getDoubleValue();
            if (value >= 0.0) {
                return typedValue;
            }
            return new TypedValue(type, MathFunctions.abs(value));
        }
        if (type.equals(RealType.REAL)) {
            float value = Float.intBitsToFloat((int)typedValue.getLongValue());
            if (value > 0.0f) {
                return typedValue;
            }
            return new TypedValue(type, Float.floatToRawIntBits(Math.abs(value)));
        }
        if (type instanceof DecimalType) {
            if (((DecimalType)type).isShort()) {
                long value = typedValue.getLongValue();
                if (value > 0L) {
                    return typedValue;
                }
                return new TypedValue(type, -value);
            }
            Int128 value = (Int128)typedValue.getObjectValue();
            if (value.isNegative()) {
                Int128 result;
                try {
                    result = DecimalOperators.Negation.negate((Int128)typedValue.getObjectValue());
                }
                catch (Exception e) {
                    throw new PathEvaluationError(e);
                }
                return new TypedValue(type, result);
            }
            return typedValue;
        }
        throw PathEvaluationError.itemTypeError("NUMBER", type.getDisplayName());
    }

    @Override
    protected List<Object> visitIrArithmeticBinary(IrArithmeticBinary node, PathEvaluationContext context) {
        Object result;
        List<Object> leftSequence = (List<Object>)this.process(node.getLeft(), context);
        List<Object> rightSequence = (List<Object>)this.process(node.getRight(), context);
        if (this.lax) {
            leftSequence = PathEvaluationUtil.unwrapArrays(leftSequence);
            rightSequence = PathEvaluationUtil.unwrapArrays(rightSequence);
        }
        if (leftSequence.size() != 1 || rightSequence.size() != 1) {
            throw new PathEvaluationError("arithmetic binary expression requires singleton operands");
        }
        Object leftObject = Iterables.getOnlyElement(leftSequence);
        TypedValue left = leftObject instanceof JsonNode ? PathEvaluationVisitor.getNumericTypedValue((JsonNode)leftObject).orElseThrow(() -> PathEvaluationError.itemTypeError("NUMBER", ((JsonNode)leftObject).getNodeType().name())) : (TypedValue)leftObject;
        Object rightObject = Iterables.getOnlyElement(rightSequence);
        TypedValue right = rightObject instanceof JsonNode ? PathEvaluationVisitor.getNumericTypedValue((JsonNode)rightObject).orElseThrow(() -> PathEvaluationError.itemTypeError("NUMBER", ((JsonNode)rightObject).getNodeType().name())) : (TypedValue)rightObject;
        CachingResolver.ResolvedOperatorAndCoercions operators = this.resolver.getOperators(node, OperatorType.valueOf((String)node.getOperator().name()), left.getType(), right.getType());
        if (operators == CachingResolver.ResolvedOperatorAndCoercions.RESOLUTION_ERROR) {
            throw new PathEvaluationError(String.format("invalid operand types to %s operator (%s, %s)", node.getOperator().name(), left.getType(), right.getType()));
        }
        Object leftInput = left.getValueAsObject();
        if (operators.getLeftCoercion().isPresent()) {
            try {
                leftInput = this.invoker.invoke(operators.getLeftCoercion().get(), (List<Object>)ImmutableList.of((Object)leftInput));
            }
            catch (RuntimeException e) {
                throw new PathEvaluationError(e);
            }
        }
        Object rightInput = right.getValueAsObject();
        if (operators.getRightCoercion().isPresent()) {
            try {
                rightInput = this.invoker.invoke(operators.getRightCoercion().get(), (List<Object>)ImmutableList.of((Object)rightInput));
            }
            catch (RuntimeException e) {
                throw new PathEvaluationError(e);
            }
        }
        try {
            result = this.invoker.invoke(operators.getOperator(), (List<Object>)ImmutableList.of((Object)leftInput, (Object)rightInput));
        }
        catch (RuntimeException e) {
            throw new PathEvaluationError(e);
        }
        return ImmutableList.of((Object)TypedValue.fromValueAsObject(operators.getOperator().getSignature().getReturnType(), result));
    }

    @Override
    protected List<Object> visitIrArithmeticUnary(IrArithmeticUnary node, PathEvaluationContext context) {
        List<Object> sequence = (List<Object>)this.process(node.getBase(), context);
        if (this.lax) {
            sequence = PathEvaluationUtil.unwrapArrays(sequence);
        }
        ImmutableList.Builder outputSequence = ImmutableList.builder();
        for (Object object : sequence) {
            TypedValue value;
            if (object instanceof JsonNode) {
                value = PathEvaluationVisitor.getNumericTypedValue((JsonNode)object).orElseThrow(() -> PathEvaluationError.itemTypeError("NUMBER", ((JsonNode)object).getNodeType().name()));
            } else {
                value = (TypedValue)object;
                Type type = value.getType();
                if (!(type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT) || type.equals(DoubleType.DOUBLE) || type.equals(RealType.REAL) || type instanceof DecimalType)) {
                    throw PathEvaluationError.itemTypeError("NUMBER", type.getDisplayName());
                }
            }
            if (node.getSign() == IrArithmeticUnary.Sign.PLUS) {
                outputSequence.add((Object)value);
                continue;
            }
            outputSequence.add((Object)PathEvaluationVisitor.negate(value));
        }
        return outputSequence.build();
    }

    private static TypedValue negate(TypedValue typedValue) {
        Type type = typedValue.getType();
        if (type.equals(BigintType.BIGINT)) {
            long negatedValue;
            try {
                negatedValue = BigintOperators.negate(typedValue.getLongValue());
            }
            catch (Exception e) {
                throw new PathEvaluationError(e);
            }
            return new TypedValue(type, negatedValue);
        }
        if (type.equals(IntegerType.INTEGER)) {
            long negatedValue;
            try {
                negatedValue = IntegerOperators.negate(typedValue.getLongValue());
            }
            catch (Exception e) {
                throw new PathEvaluationError(e);
            }
            return new TypedValue(type, negatedValue);
        }
        if (type.equals(SmallintType.SMALLINT)) {
            long negatedValue;
            try {
                negatedValue = SmallintOperators.negate(typedValue.getLongValue());
            }
            catch (Exception e) {
                throw new PathEvaluationError(e);
            }
            return new TypedValue(type, negatedValue);
        }
        if (type.equals(TinyintType.TINYINT)) {
            long negatedValue;
            try {
                negatedValue = TinyintOperators.negate(typedValue.getLongValue());
            }
            catch (Exception e) {
                throw new PathEvaluationError(e);
            }
            return new TypedValue(type, negatedValue);
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return new TypedValue(type, -typedValue.getDoubleValue());
        }
        if (type.equals(RealType.REAL)) {
            return new TypedValue(type, RealOperators.negate(typedValue.getLongValue()));
        }
        if (type instanceof DecimalType) {
            Int128 negatedValue;
            if (((DecimalType)type).isShort()) {
                return new TypedValue(type, -typedValue.getLongValue());
            }
            try {
                negatedValue = DecimalOperators.Negation.negate((Int128)typedValue.getObjectValue());
            }
            catch (Exception e) {
                throw new PathEvaluationError(e);
            }
            return new TypedValue(type, negatedValue);
        }
        throw new IllegalStateException("unexpected type" + type.getDisplayName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected List<Object> visitIrArrayAccessor(IrArrayAccessor node, PathEvaluationContext context) {
        List sequence = (List)this.process(node.getBase(), context);
        ImmutableList.Builder outputSequence = ImmutableList.builder();
        for (Object object : sequence) {
            ImmutableList elements;
            if (object instanceof JsonNode) {
                if (((JsonNode)object).isArray()) {
                    elements = ImmutableList.copyOf((Iterator)((JsonNode)object).elements());
                } else {
                    if (!this.lax) throw PathEvaluationError.itemTypeError("ARRAY", ((JsonNode)object).getNodeType().name());
                    elements = ImmutableList.of(object);
                }
            } else {
                if (!this.lax) throw PathEvaluationError.itemTypeError("ARRAY", ((TypedValue)object).getType().getDisplayName());
                elements = ImmutableList.of(object);
            }
            if (node.getSubscripts().isEmpty()) {
                outputSequence.addAll((Iterable)elements);
                continue;
            }
            if (elements.isEmpty()) {
                if (this.lax) continue;
                throw PathEvaluationError.structuralError("invalid array subscript for empty array", new Object[0]);
            }
            PathEvaluationContext arrayContext = context.withLast(elements.size() - 1);
            for (IrArrayAccessor.Subscript subscript : node.getSubscripts()) {
                Range resultRange;
                List from = (List)this.process(subscript.getFrom(), arrayContext);
                Optional<List> to = subscript.getTo().map(path -> (List)this.process((IrPathNode)path, arrayContext));
                if (from.size() != 1) {
                    throw new PathEvaluationError("array subscript 'from' value must be singleton numeric");
                }
                if (to.isPresent() && to.get().size() != 1) {
                    throw new PathEvaluationError("array subscript 'to' value must be singleton numeric");
                }
                long fromIndex = PathEvaluationVisitor.asArrayIndex(Iterables.getOnlyElement((Iterable)from));
                long toIndex = to.map(Iterables::getOnlyElement).map(PathEvaluationVisitor::asArrayIndex).orElse(fromIndex);
                if (!(this.lax || fromIndex >= 0L && fromIndex < (long)elements.size() && toIndex >= 0L && toIndex < (long)elements.size() && fromIndex <= toIndex)) {
                    throw PathEvaluationError.structuralError("invalid array subscript: [%s, %s] for array of size %s", fromIndex, toIndex, elements.size());
                }
                if (fromIndex > toIndex) continue;
                Range allElementsRange = Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf((long)elements.size() - 1L));
                Range subscriptRange = Range.closed((Comparable)Long.valueOf(fromIndex), (Comparable)Long.valueOf(toIndex));
                if (!subscriptRange.isConnected(allElementsRange) || (resultRange = subscriptRange.intersection(allElementsRange)).isEmpty()) continue;
                for (long i = ((Long)resultRange.lowerEndpoint()).longValue(); i <= (Long)resultRange.upperEndpoint(); ++i) {
                    outputSequence.add(elements.get((int)i));
                }
            }
        }
        return outputSequence.build();
    }

    private static long asArrayIndex(Object object) {
        if (object instanceof JsonNode) {
            JsonNode jsonNode = (JsonNode)object;
            if (jsonNode.getNodeType() != JsonNodeType.NUMBER) {
                throw PathEvaluationError.itemTypeError("NUMBER", jsonNode.getNodeType().name());
            }
            if (!jsonNode.canConvertToLong()) {
                throw new PathEvaluationError(String.format("cannot convert value %s to long", jsonNode));
            }
            return jsonNode.longValue();
        }
        TypedValue value = (TypedValue)object;
        Type type = value.getType();
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT)) {
            return value.getLongValue();
        }
        if (type.equals(DoubleType.DOUBLE)) {
            try {
                return DoubleOperators.castToLong(value.getDoubleValue());
            }
            catch (Exception e) {
                throw new PathEvaluationError(e);
            }
        }
        if (type.equals(RealType.REAL)) {
            try {
                return RealOperators.castToLong(value.getLongValue());
            }
            catch (Exception e) {
                throw new PathEvaluationError(e);
            }
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            int precision = decimalType.getPrecision();
            int scale = decimalType.getScale();
            if (((DecimalType)type).isShort()) {
                long tenToScale = Decimals.longTenToNth((int)DecimalConversions.intScale((long)scale));
                return DecimalCasts.shortDecimalToBigint(value.getLongValue(), precision, scale, tenToScale);
            }
            Int128 tenToScale = Int128Math.powerOfTen((int)DecimalConversions.intScale((long)scale));
            try {
                return DecimalCasts.longDecimalToBigint((Int128)value.getObjectValue(), precision, scale, tenToScale);
            }
            catch (Exception e) {
                throw new PathEvaluationError(e);
            }
        }
        throw PathEvaluationError.itemTypeError("NUMBER", type.getDisplayName());
    }

    @Override
    protected List<Object> visitIrCeilingMethod(IrCeilingMethod node, PathEvaluationContext context) {
        List<Object> sequence = (List<Object>)this.process(node.getBase(), context);
        if (this.lax) {
            sequence = PathEvaluationUtil.unwrapArrays(sequence);
        }
        ImmutableList.Builder outputSequence = ImmutableList.builder();
        for (Object object : sequence) {
            TypedValue value = object instanceof JsonNode ? PathEvaluationVisitor.getNumericTypedValue((JsonNode)object).orElseThrow(() -> PathEvaluationError.itemTypeError("NUMBER", ((JsonNode)object).getNodeType().name())) : (TypedValue)object;
            outputSequence.add((Object)PathEvaluationVisitor.getCeiling(value));
        }
        return outputSequence.build();
    }

    private static TypedValue getCeiling(TypedValue typedValue) {
        Type type = typedValue.getType();
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT)) {
            return typedValue;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return new TypedValue(type, Math.ceil(typedValue.getDoubleValue()));
        }
        if (type.equals(RealType.REAL)) {
            return new TypedValue(type, MathFunctions.ceilingFloat(typedValue.getLongValue()));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            int scale = decimalType.getScale();
            DecimalType resultType = DecimalType.createDecimalType((int)(decimalType.getPrecision() - scale + Math.min(scale, 1)), (int)0);
            if (decimalType.isShort()) {
                return new TypedValue((Type)resultType, MathFunctions.Ceiling.ceilingShort(scale, typedValue.getLongValue()));
            }
            if (resultType.isShort()) {
                try {
                    return new TypedValue((Type)resultType, MathFunctions.Ceiling.ceilingLongShort(scale, (Int128)typedValue.getObjectValue()));
                }
                catch (Exception e) {
                    throw new PathEvaluationError(e);
                }
            }
            try {
                return new TypedValue((Type)resultType, MathFunctions.Ceiling.ceilingLong(scale, (Int128)typedValue.getObjectValue()));
            }
            catch (Exception e) {
                throw new PathEvaluationError(e);
            }
        }
        throw PathEvaluationError.itemTypeError("NUMBER", type.getDisplayName());
    }

    @Override
    protected List<Object> visitIrConstantJsonSequence(IrConstantJsonSequence node, PathEvaluationContext context) {
        return ImmutableList.copyOf(node.getSequence());
    }

    @Override
    protected List<Object> visitIrContextVariable(IrContextVariable node, PathEvaluationContext context) {
        return ImmutableList.of((Object)this.input);
    }

    @Override
    protected List<Object> visitIrDatetimeMethod(IrDatetimeMethod node, PathEvaluationContext context) {
        throw new UnsupportedOperationException("date method is not yet supported");
    }

    @Override
    protected List<Object> visitIrDoubleMethod(IrDoubleMethod node, PathEvaluationContext context) {
        List<Object> sequence = (List<Object>)this.process(node.getBase(), context);
        if (this.lax) {
            sequence = PathEvaluationUtil.unwrapArrays(sequence);
        }
        ImmutableList.Builder outputSequence = ImmutableList.builder();
        for (Object object : sequence) {
            TypedValue value = object instanceof JsonNode ? PathEvaluationVisitor.getNumericTypedValue((JsonNode)object).orElseGet(() -> SqlJsonLiteralConverter.getTextTypedValue((JsonNode)object).orElseThrow(() -> PathEvaluationError.itemTypeError("NUMBER or TEXT", ((JsonNode)object).getNodeType().name()))) : (TypedValue)object;
            outputSequence.add((Object)PathEvaluationVisitor.getDouble(value));
        }
        return outputSequence.build();
    }

    private static TypedValue getDouble(TypedValue typedValue) {
        Type type = typedValue.getType();
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT)) {
            return new TypedValue((Type)DoubleType.DOUBLE, (double)typedValue.getLongValue());
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return typedValue;
        }
        if (type.equals(RealType.REAL)) {
            return new TypedValue((Type)DoubleType.DOUBLE, RealOperators.castToDouble(typedValue.getLongValue()));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            int precision = decimalType.getPrecision();
            int scale = decimalType.getScale();
            if (((DecimalType)type).isShort()) {
                long tenToScale = Decimals.longTenToNth((int)DecimalConversions.intScale((long)scale));
                return new TypedValue((Type)DoubleType.DOUBLE, DecimalCasts.shortDecimalToDouble(typedValue.getLongValue(), precision, scale, tenToScale));
            }
            Int128 tenToScale = Int128Math.powerOfTen((int)DecimalConversions.intScale((long)scale));
            return new TypedValue((Type)DoubleType.DOUBLE, DecimalCasts.longDecimalToDouble((Int128)typedValue.getObjectValue(), precision, scale, tenToScale));
        }
        if (type instanceof VarcharType || type instanceof CharType) {
            try {
                return new TypedValue((Type)DoubleType.DOUBLE, VarcharOperators.castToDouble((Slice)typedValue.getObjectValue()));
            }
            catch (Exception e) {
                throw new PathEvaluationError(e);
            }
        }
        throw PathEvaluationError.itemTypeError("NUMBER or TEXT", type.getDisplayName());
    }

    @Override
    protected List<Object> visitIrFilter(IrFilter node, PathEvaluationContext context) {
        List<Object> sequence = (List<Object>)this.process(node.getBase(), context);
        if (this.lax) {
            sequence = PathEvaluationUtil.unwrapArrays(sequence);
        }
        ImmutableList.Builder outputSequence = ImmutableList.builder();
        for (Object object : sequence) {
            PathEvaluationContext currentItemContext = context.withCurrentItem(object);
            Boolean result = (Boolean)this.predicateVisitor.process(node.getPredicate(), currentItemContext);
            if (!Boolean.TRUE.equals(result)) continue;
            outputSequence.add(object);
        }
        return outputSequence.build();
    }

    @Override
    protected List<Object> visitIrFloorMethod(IrFloorMethod node, PathEvaluationContext context) {
        List<Object> sequence = (List<Object>)this.process(node.getBase(), context);
        if (this.lax) {
            sequence = PathEvaluationUtil.unwrapArrays(sequence);
        }
        ImmutableList.Builder outputSequence = ImmutableList.builder();
        for (Object object : sequence) {
            TypedValue value = object instanceof JsonNode ? PathEvaluationVisitor.getNumericTypedValue((JsonNode)object).orElseThrow(() -> PathEvaluationError.itemTypeError("NUMBER", ((JsonNode)object).getNodeType().name())) : (TypedValue)object;
            outputSequence.add((Object)PathEvaluationVisitor.getFloor(value));
        }
        return outputSequence.build();
    }

    private static TypedValue getFloor(TypedValue typedValue) {
        Type type = typedValue.getType();
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT)) {
            return typedValue;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return new TypedValue(type, Math.floor(typedValue.getDoubleValue()));
        }
        if (type.equals(RealType.REAL)) {
            return new TypedValue(type, MathFunctions.floorFloat(typedValue.getLongValue()));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            int scale = decimalType.getScale();
            DecimalType resultType = DecimalType.createDecimalType((int)(decimalType.getPrecision() - scale + Math.min(scale, 1)), (int)0);
            if (((DecimalType)type).isShort()) {
                return new TypedValue((Type)resultType, MathFunctions.Floor.floorShort(scale, typedValue.getLongValue()));
            }
            if (resultType.isShort()) {
                try {
                    return new TypedValue((Type)resultType, MathFunctions.Floor.floorLongShort(scale, (Int128)typedValue.getObjectValue()));
                }
                catch (Exception e) {
                    throw new PathEvaluationError(e);
                }
            }
            try {
                return new TypedValue((Type)resultType, MathFunctions.Floor.floorLong(scale, (Int128)typedValue.getObjectValue()));
            }
            catch (Exception e) {
                throw new PathEvaluationError(e);
            }
        }
        throw PathEvaluationError.itemTypeError("NUMBER", type.getDisplayName());
    }

    @Override
    protected List<Object> visitIrJsonNull(IrJsonNull node, PathEvaluationContext context) {
        return ImmutableList.of((Object)NullNode.getInstance());
    }

    @Override
    protected List<Object> visitIrKeyValueMethod(IrKeyValueMethod node, PathEvaluationContext context) {
        List<Object> sequence = (List<Object>)this.process(node.getBase(), context);
        if (this.lax) {
            sequence = PathEvaluationUtil.unwrapArrays(sequence);
        }
        ImmutableList.Builder outputSequence = ImmutableList.builder();
        for (Object object : sequence) {
            if (!(object instanceof JsonNode)) {
                throw PathEvaluationError.itemTypeError("OBJECT", ((TypedValue)object).getType().getDisplayName());
            }
            if (!((JsonNode)object).isObject()) {
                throw PathEvaluationError.itemTypeError("OBJECT", ((JsonNode)object).getNodeType().name());
            }
            ((JsonNode)object).fields().forEachRemaining(field -> outputSequence.add((Object)new ObjectNode(JsonNodeFactory.instance, (Map)ImmutableMap.of((Object)"name", (Object)TextNode.valueOf((String)((String)field.getKey())), (Object)"value", (Object)((JsonNode)field.getValue()), (Object)"id", (Object)IntNode.valueOf((int)this.objectId)))));
            ++this.objectId;
        }
        return outputSequence.build();
    }

    @Override
    protected List<Object> visitIrLastIndexVariable(IrLastIndexVariable node, PathEvaluationContext context) {
        return ImmutableList.of((Object)context.getLast());
    }

    @Override
    protected List<Object> visitIrLiteral(IrLiteral node, PathEvaluationContext context) {
        return ImmutableList.of((Object)TypedValue.fromValueAsObject(node.getType().orElseThrow(), node.getValue()));
    }

    @Override
    protected List<Object> visitIrMemberAccessor(IrMemberAccessor node, PathEvaluationContext context) {
        List<Object> sequence = (List<Object>)this.process(node.getBase(), context);
        if (this.lax) {
            sequence = PathEvaluationUtil.unwrapArrays(sequence);
        }
        ImmutableList.Builder outputSequence = ImmutableList.builder();
        for (Object object : sequence) {
            JsonNode jsonNode;
            if (!this.lax) {
                if (!(object instanceof JsonNode)) {
                    throw PathEvaluationError.itemTypeError("OBJECT", ((TypedValue)object).getType().getDisplayName());
                }
                jsonNode = (JsonNode)object;
                if (!jsonNode.isObject()) {
                    throw PathEvaluationError.itemTypeError("OBJECT", jsonNode.getNodeType().name());
                }
            }
            if (!(object instanceof JsonNode) || !(jsonNode = (JsonNode)object).isObject()) continue;
            if (node.getKey().isEmpty()) {
                outputSequence.addAll(jsonNode.elements());
                continue;
            }
            JsonNode boundValue = jsonNode.get(node.getKey().get());
            if (boundValue == null) {
                if (this.lax) continue;
                throw PathEvaluationError.structuralError("missing member '%s' in JSON object", node.getKey().get());
            }
            outputSequence.add((Object)boundValue);
        }
        return outputSequence.build();
    }

    @Override
    protected List<Object> visitIrNamedJsonVariable(IrNamedJsonVariable node, PathEvaluationContext context) {
        Object value = this.parameters[node.getIndex()];
        Preconditions.checkState((value != null ? 1 : 0) != 0, (Object)"missing value for parameter");
        Preconditions.checkState((boolean)(value instanceof JsonNode), (Object)"expected JSON, got SQL value");
        if (value.equals((Object)JsonEmptySequenceNode.EMPTY_SEQUENCE)) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)value);
    }

    @Override
    protected List<Object> visitIrNamedValueVariable(IrNamedValueVariable node, PathEvaluationContext context) {
        Object value = this.parameters[node.getIndex()];
        Preconditions.checkState((value != null ? 1 : 0) != 0, (Object)"missing value for parameter");
        Preconditions.checkState((value instanceof TypedValue || value instanceof NullNode ? 1 : 0) != 0, (Object)"expected SQL value or JSON null, got non-null JSON");
        return ImmutableList.of((Object)value);
    }

    @Override
    protected List<Object> visitIrPredicateCurrentItemVariable(IrPredicateCurrentItemVariable node, PathEvaluationContext context) {
        return ImmutableList.of((Object)context.getCurrentItem());
    }

    @Override
    protected List<Object> visitIrSizeMethod(IrSizeMethod node, PathEvaluationContext context) {
        List sequence = (List)this.process(node.getBase(), context);
        ImmutableList.Builder outputSequence = ImmutableList.builder();
        for (Object object : sequence) {
            if (object instanceof JsonNode && ((JsonNode)object).isArray()) {
                outputSequence.add((Object)new TypedValue((Type)IntegerType.INTEGER, ((JsonNode)object).size()));
                continue;
            }
            if (this.lax) {
                outputSequence.add((Object)new TypedValue((Type)IntegerType.INTEGER, 1L));
                continue;
            }
            String type = object instanceof JsonNode ? ((JsonNode)object).getNodeType().name() : ((TypedValue)object).getType().getDisplayName();
            throw PathEvaluationError.itemTypeError("ARRAY", type);
        }
        return outputSequence.build();
    }

    @Override
    protected List<Object> visitIrTypeMethod(IrTypeMethod node, PathEvaluationContext context) {
        List sequence = (List)this.process(node.getBase(), context);
        Type resultType = node.getType().orElseThrow();
        ImmutableList.Builder outputSequence = ImmutableList.builder();
        block8: for (Object object : sequence) {
            if (object instanceof JsonNode) {
                switch (((JsonNode)object).getNodeType()) {
                    case NUMBER: {
                        outputSequence.add((Object)new TypedValue(resultType, Slices.utf8Slice((String)"number")));
                        continue block8;
                    }
                    case STRING: {
                        outputSequence.add((Object)new TypedValue(resultType, Slices.utf8Slice((String)"string")));
                        continue block8;
                    }
                    case BOOLEAN: {
                        outputSequence.add((Object)new TypedValue(resultType, Slices.utf8Slice((String)"boolean")));
                        continue block8;
                    }
                    case ARRAY: {
                        outputSequence.add((Object)new TypedValue(resultType, Slices.utf8Slice((String)"array")));
                        continue block8;
                    }
                    case OBJECT: {
                        outputSequence.add((Object)new TypedValue(resultType, Slices.utf8Slice((String)"object")));
                        continue block8;
                    }
                    case NULL: {
                        outputSequence.add((Object)new TypedValue(resultType, Slices.utf8Slice((String)"null")));
                        continue block8;
                    }
                }
                throw new IllegalArgumentException("unexpected Json node type: " + ((JsonNode)object).getNodeType());
            }
            Type type = ((TypedValue)object).getType();
            if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT) || type.equals(DoubleType.DOUBLE) || type.equals(RealType.REAL) || type instanceof DecimalType) {
                outputSequence.add((Object)new TypedValue(resultType, Slices.utf8Slice((String)"number")));
                continue;
            }
            if (type instanceof VarcharType || type instanceof CharType) {
                outputSequence.add((Object)new TypedValue(resultType, Slices.utf8Slice((String)"string")));
                continue;
            }
            if (type.equals(BooleanType.BOOLEAN)) {
                outputSequence.add((Object)new TypedValue(resultType, Slices.utf8Slice((String)"boolean")));
                continue;
            }
            if (type.equals(DateType.DATE)) {
                outputSequence.add((Object)new TypedValue(resultType, Slices.utf8Slice((String)"date")));
                continue;
            }
            if (type instanceof TimeType) {
                outputSequence.add((Object)new TypedValue(resultType, Slices.utf8Slice((String)"time without time zone")));
                continue;
            }
            if (type instanceof TimeWithTimeZoneType) {
                outputSequence.add((Object)new TypedValue(resultType, Slices.utf8Slice((String)"time with time zone")));
                continue;
            }
            if (type instanceof TimestampType) {
                outputSequence.add((Object)new TypedValue(resultType, Slices.utf8Slice((String)"timestamp without time zone")));
                continue;
            }
            if (!(type instanceof TimestampWithTimeZoneType)) continue;
            outputSequence.add((Object)new TypedValue(resultType, Slices.utf8Slice((String)"timestamp with time zone")));
        }
        return outputSequence.build();
    }

    private static Optional<TypedValue> getNumericTypedValue(JsonNode jsonNode) {
        try {
            return SqlJsonLiteralConverter.getNumericTypedValue(jsonNode);
        }
        catch (SqlJsonLiteralConverter.JsonLiteralConversionError e) {
            throw new PathEvaluationError((Throwable)((Object)e));
        }
    }
}

