/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.json.ir.IrJsonPathVisitor;
import io.trino.json.ir.IrMethod;
import io.trino.json.ir.IrPathNode;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public class IrDatetimeMethod
extends IrMethod {
    private final Optional<String> format;

    @JsonCreator
    public IrDatetimeMethod(@JsonProperty(value="base") IrPathNode base, @JsonProperty(value="format") Optional<String> format, @JsonProperty(value="type") Optional<Type> type) {
        super(base, type);
        this.format = Objects.requireNonNull(format, "format is null");
    }

    @Override
    protected <R, C> R accept(IrJsonPathVisitor<R, C> visitor, C context) {
        return visitor.visitIrDatetimeMethod(this, context);
    }

    @JsonProperty
    public Optional<String> getFormat() {
        return this.format;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrDatetimeMethod other = (IrDatetimeMethod)obj;
        return Objects.equals(this.base, other.base) && Objects.equals(this.format, other.format);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base, this.format);
    }
}

