/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.json.ir.IrAccessor;
import io.trino.json.ir.IrJsonPathVisitor;
import io.trino.json.ir.IrPathNode;
import io.trino.json.ir.IrPredicate;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public class IrFilter
extends IrAccessor {
    private final IrPredicate predicate;

    @JsonCreator
    public IrFilter(@JsonProperty(value="base") IrPathNode base, @JsonProperty(value="predicate") IrPredicate predicate, @JsonProperty(value="type") Optional<Type> type) {
        super(base, type);
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
    }

    @Override
    protected <R, C> R accept(IrJsonPathVisitor<R, C> visitor, C context) {
        return visitor.visitIrFilter(this, context);
    }

    @JsonProperty
    public IrPredicate getPredicate() {
        return this.predicate;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrFilter other = (IrFilter)obj;
        return Objects.equals(this.base, other.base) && Objects.equals(this.predicate, other.predicate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base, this.predicate);
    }
}

