/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.json.ir.IrAccessor;
import io.trino.json.ir.IrJsonPathVisitor;
import io.trino.json.ir.IrPathNode;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public class IrMemberAccessor
extends IrAccessor {
    private final Optional<String> key;

    @JsonCreator
    public IrMemberAccessor(@JsonProperty(value="base") IrPathNode base, @JsonProperty(value="key") Optional<String> key, @JsonProperty(value="type") Optional<Type> type) {
        super(base, type);
        this.key = Objects.requireNonNull(key, "key is null");
    }

    @Override
    protected <R, C> R accept(IrJsonPathVisitor<R, C> visitor, C context) {
        return visitor.visitIrMemberAccessor(this, context);
    }

    @JsonProperty
    public Optional<String> getKey() {
        return this.key;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrMemberAccessor other = (IrMemberAccessor)obj;
        return Objects.equals(this.base, other.base) && Objects.equals(this.key, other.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base, this.key);
    }
}

