/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.trino.json.ir.IrJsonPathVisitor;
import io.trino.json.ir.IrPathNode;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public class IrNamedValueVariable
extends IrPathNode {
    private final int index;

    @JsonCreator
    public IrNamedValueVariable(@JsonProperty(value="index") int index, @JsonProperty(value="type") Optional<Type> type) {
        super(type);
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"parameter index is negative");
        this.index = index;
    }

    @Override
    protected <R, C> R accept(IrJsonPathVisitor<R, C> visitor, C context) {
        return visitor.visitIrNamedValueVariable(this, context);
    }

    @JsonProperty
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrNamedValueVariable other = (IrNamedValueVariable)obj;
        return this.index == other.index;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index);
    }
}

