/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.trino.Session;
import io.trino.metadata.CatalogSchemaFunctionName;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.Metadata;
import io.trino.metadata.SignatureBinder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.QualifiedFunctionName;
import io.trino.spi.function.Signature;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.SqlPathElement;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.Identifier;
import io.trino.type.UnknownType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FunctionResolver {
    private final Metadata metadata;
    private final TypeManager typeManager;

    public FunctionResolver(Metadata metadata, TypeManager typeManager) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    boolean isAggregationFunction(Session session, QualifiedFunctionName name, Function<CatalogSchemaFunctionName, Collection<CatalogFunctionMetadata>> candidateLoader) {
        for (CatalogSchemaFunctionName catalogSchemaFunctionName : FunctionResolver.toPath(session, name)) {
            Collection<CatalogFunctionMetadata> candidates = candidateLoader.apply(catalogSchemaFunctionName);
            if (candidates.isEmpty()) continue;
            return candidates.stream().map(CatalogFunctionMetadata::getFunctionMetadata).map(FunctionMetadata::getKind).anyMatch(arg_0 -> FunctionKind.AGGREGATE.equals(arg_0));
        }
        return false;
    }

    CatalogFunctionBinding resolveCoercion(Session session, QualifiedFunctionName name, Signature signature, Function<CatalogSchemaFunctionName, Collection<CatalogFunctionMetadata>> candidateLoader) {
        for (CatalogSchemaFunctionName catalogSchemaFunctionName : FunctionResolver.toPath(session, name)) {
            Collection<CatalogFunctionMetadata> candidates = candidateLoader.apply(catalogSchemaFunctionName);
            List exactCandidates = (List)candidates.stream().filter(function -> FunctionResolver.possibleExactCastMatch(signature, function.getFunctionMetadata().getSignature())).collect(ImmutableList.toImmutableList());
            for (CatalogFunctionMetadata candidate : exactCandidates) {
                if (!this.canBindSignature(session, candidate.getFunctionMetadata().getSignature(), signature)) continue;
                return this.toFunctionBinding(candidate, signature);
            }
            List genericCandidates = (List)candidates.stream().filter(function -> !function.getFunctionMetadata().getSignature().getTypeVariableConstraints().isEmpty()).collect(ImmutableList.toImmutableList());
            for (CatalogFunctionMetadata candidate : genericCandidates) {
                if (!this.canBindSignature(session, candidate.getFunctionMetadata().getSignature(), signature)) continue;
                return this.toFunctionBinding(candidate, signature);
            }
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, String.format("%s not found", signature));
    }

    private boolean canBindSignature(Session session, Signature declaredSignature, Signature actualSignature) {
        return new SignatureBinder(session, this.metadata, this.typeManager, declaredSignature, false).canBind(TypeSignatureProvider.fromTypeSignatures(actualSignature.getArgumentTypes()), actualSignature.getReturnType());
    }

    private CatalogFunctionBinding toFunctionBinding(CatalogFunctionMetadata functionMetadata, Signature signature) {
        BoundSignature boundSignature = new BoundSignature(signature.getName(), this.typeManager.getType(signature.getReturnType()), (List)signature.getArgumentTypes().stream().map(arg_0 -> ((TypeManager)this.typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList()));
        return new CatalogFunctionBinding(functionMetadata.getCatalogHandle(), SignatureBinder.bindFunction(functionMetadata.getFunctionMetadata().getFunctionId(), functionMetadata.getFunctionMetadata().getSignature(), boundSignature));
    }

    private static boolean possibleExactCastMatch(Signature signature, Signature declaredSignature) {
        if (!declaredSignature.getTypeVariableConstraints().isEmpty()) {
            return false;
        }
        if (!declaredSignature.getReturnType().getBase().equalsIgnoreCase(signature.getReturnType().getBase())) {
            return false;
        }
        return ((TypeSignature)declaredSignature.getArgumentTypes().get(0)).getBase().equalsIgnoreCase(((TypeSignature)signature.getArgumentTypes().get(0)).getBase());
    }

    CatalogFunctionBinding resolveFunction(Session session, QualifiedFunctionName name, List<TypeSignatureProvider> parameterTypes, Function<CatalogSchemaFunctionName, Collection<CatalogFunctionMetadata>> candidateLoader) {
        ImmutableList.Builder allCandidates = ImmutableList.builder();
        for (CatalogSchemaFunctionName catalogSchemaFunctionName : FunctionResolver.toPath(session, name)) {
            Collection<CatalogFunctionMetadata> candidates = candidateLoader.apply(catalogSchemaFunctionName);
            List exactCandidates = (List)candidates.stream().filter(function -> function.getFunctionMetadata().getSignature().getTypeVariableConstraints().isEmpty()).collect(ImmutableList.toImmutableList());
            Optional<CatalogFunctionBinding> match = this.matchFunctionExact(session, exactCandidates, parameterTypes);
            if (match.isPresent()) {
                return match.get();
            }
            List genericCandidates = (List)candidates.stream().filter(function -> !function.getFunctionMetadata().getSignature().getTypeVariableConstraints().isEmpty()).collect(ImmutableList.toImmutableList());
            match = this.matchFunctionExact(session, genericCandidates, parameterTypes);
            if (match.isPresent()) {
                return match.get();
            }
            match = this.matchFunctionWithCoercion(session, candidates, parameterTypes);
            if (match.isPresent()) {
                return match.get();
            }
            allCandidates.addAll((Iterable)candidates);
        }
        ImmutableList candidates = allCandidates.build();
        if (candidates.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Function '%s' not registered", name));
        }
        ArrayList<String> expectedParameters = new ArrayList<String>();
        for (CatalogFunctionMetadata function2 : candidates) {
            String arguments = Joiner.on((String)", ").join((Iterable)function2.getFunctionMetadata().getSignature().getArgumentTypes());
            String constraints = Joiner.on((String)", ").join((Iterable)function2.getFunctionMetadata().getSignature().getTypeVariableConstraints());
            expectedParameters.add(String.format("%s(%s) %s", name, arguments, constraints).stripTrailing());
        }
        String parameters = Joiner.on((String)", ").join(parameterTypes);
        String expected = Joiner.on((String)", ").join(expectedParameters);
        String message = String.format("Unexpected parameters (%s) for function %s. Expected: %s", parameters, name, expected);
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, message);
    }

    public static List<CatalogSchemaFunctionName> toPath(Session session, QualifiedFunctionName name) {
        if (name.getCatalogName().isPresent()) {
            return ImmutableList.of((Object)new CatalogSchemaFunctionName((String)name.getCatalogName().orElseThrow(), (String)name.getSchemaName().orElseThrow(), name.getFunctionName()));
        }
        if (name.getSchemaName().isPresent()) {
            String currentCatalog = session.getCatalog().orElseThrow(() -> new IllegalArgumentException("Session default catalog must be set to resolve a partial function name: " + name));
            return ImmutableList.of((Object)new CatalogSchemaFunctionName(currentCatalog, (String)name.getSchemaName().orElseThrow(), name.getFunctionName()));
        }
        ImmutableList.Builder names = ImmutableList.builder();
        names.add((Object)new CatalogSchemaFunctionName("system", "builtin", name.getFunctionName()));
        for (SqlPathElement sqlPathElement : session.getPath().getParsedPath()) {
            String catalog = sqlPathElement.getCatalog().map(Identifier::getCanonicalValue).or(session::getCatalog).orElseThrow(() -> new IllegalArgumentException("Session default catalog must be set to resolve a partial function name: " + name));
            names.add((Object)new CatalogSchemaFunctionName(catalog, sqlPathElement.getSchema().getCanonicalValue(), name.getFunctionName()));
        }
        return names.build();
    }

    private Optional<CatalogFunctionBinding> matchFunctionExact(Session session, List<CatalogFunctionMetadata> candidates, List<TypeSignatureProvider> actualParameters) {
        return this.matchFunction(session, candidates, actualParameters, false);
    }

    private Optional<CatalogFunctionBinding> matchFunctionWithCoercion(Session session, Collection<CatalogFunctionMetadata> candidates, List<TypeSignatureProvider> actualParameters) {
        return this.matchFunction(session, candidates, actualParameters, true);
    }

    private Optional<CatalogFunctionBinding> matchFunction(Session session, Collection<CatalogFunctionMetadata> candidates, List<TypeSignatureProvider> parameters, boolean coercionAllowed) {
        List<ApplicableFunction> applicableFunctions = this.identifyApplicableFunctions(session, candidates, parameters, coercionAllowed);
        if (applicableFunctions.isEmpty()) {
            return Optional.empty();
        }
        if (coercionAllowed) {
            Preconditions.checkState((!(applicableFunctions = this.selectMostSpecificFunctions(session, applicableFunctions, parameters)).isEmpty() ? 1 : 0) != 0, (Object)"at least single function must be left");
        }
        if (applicableFunctions.size() == 1) {
            ApplicableFunction applicableFunction = (ApplicableFunction)Iterables.getOnlyElement(applicableFunctions);
            return Optional.of(this.toFunctionBinding(applicableFunction.getFunction(), applicableFunction.getBoundSignature()));
        }
        StringBuilder errorMessageBuilder = new StringBuilder();
        errorMessageBuilder.append("Could not choose a best candidate operator. Explicit type casts must be added.\n");
        errorMessageBuilder.append("Candidates are:\n");
        for (ApplicableFunction function : applicableFunctions) {
            errorMessageBuilder.append("\t * ");
            errorMessageBuilder.append(function.getBoundSignature());
            errorMessageBuilder.append("\n");
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_CALL, errorMessageBuilder.toString());
    }

    private List<ApplicableFunction> identifyApplicableFunctions(Session session, Collection<CatalogFunctionMetadata> candidates, List<TypeSignatureProvider> actualParameters, boolean allowCoercion) {
        ImmutableList.Builder applicableFunctions = ImmutableList.builder();
        for (CatalogFunctionMetadata function : candidates) {
            new SignatureBinder(session, this.metadata, this.typeManager, function.getFunctionMetadata().getSignature(), allowCoercion).bind(actualParameters).ifPresent(signature -> applicableFunctions.add((Object)new ApplicableFunction(function, (Signature)signature)));
        }
        return applicableFunctions.build();
    }

    private List<ApplicableFunction> selectMostSpecificFunctions(Session session, List<ApplicableFunction> applicableFunctions, List<TypeSignatureProvider> parameters) {
        Preconditions.checkArgument((!applicableFunctions.isEmpty() ? 1 : 0) != 0);
        List<ApplicableFunction> mostSpecificFunctions = this.selectMostSpecificFunctions(session, applicableFunctions);
        if (mostSpecificFunctions.size() <= 1) {
            return mostSpecificFunctions;
        }
        Optional<List<Type>> optionalParameterTypes = this.toTypes(parameters);
        if (optionalParameterTypes.isEmpty()) {
            return mostSpecificFunctions;
        }
        List<Type> parameterTypes = optionalParameterTypes.get();
        if (!FunctionResolver.someParameterIsUnknown(parameterTypes)) {
            return mostSpecificFunctions;
        }
        List<ApplicableFunction> unknownOnlyCastFunctions = this.getUnknownOnlyCastFunctions(applicableFunctions, parameterTypes);
        if (!unknownOnlyCastFunctions.isEmpty() && (mostSpecificFunctions = unknownOnlyCastFunctions).size() == 1) {
            return mostSpecificFunctions;
        }
        if (this.returnTypeIsTheSame(mostSpecificFunctions) && FunctionResolver.allReturnNullOnGivenInputTypes(mostSpecificFunctions, parameterTypes)) {
            ApplicableFunction selectedFunction = (ApplicableFunction)Ordering.usingToString().reverse().sortedCopy(mostSpecificFunctions).get(0);
            return ImmutableList.of((Object)selectedFunction);
        }
        return mostSpecificFunctions;
    }

    private List<ApplicableFunction> selectMostSpecificFunctions(Session session, List<ApplicableFunction> candidates) {
        ArrayList<ApplicableFunction> representatives = new ArrayList<ApplicableFunction>();
        for (ApplicableFunction current : candidates) {
            boolean found = false;
            for (int i = 0; i < representatives.size(); ++i) {
                ApplicableFunction representative = (ApplicableFunction)representatives.get(i);
                if (this.isMoreSpecificThan(session, current, representative)) {
                    representatives.set(i, current);
                }
                if (!this.isMoreSpecificThan(session, current, representative) && !this.isMoreSpecificThan(session, representative, current)) continue;
                found = true;
                break;
            }
            if (found) continue;
            representatives.add(current);
        }
        return representatives;
    }

    private static boolean someParameterIsUnknown(List<Type> parameters) {
        return parameters.stream().anyMatch(type -> type.equals((Object)UnknownType.UNKNOWN));
    }

    private List<ApplicableFunction> getUnknownOnlyCastFunctions(List<ApplicableFunction> applicableFunction, List<Type> actualParameters) {
        return (List)applicableFunction.stream().filter(function -> this.onlyCastsUnknown((ApplicableFunction)function, actualParameters)).collect(ImmutableList.toImmutableList());
    }

    private boolean onlyCastsUnknown(ApplicableFunction applicableFunction, List<Type> actualParameters) {
        List boundTypes = (List)applicableFunction.getBoundSignature().getArgumentTypes().stream().map(arg_0 -> ((TypeManager)this.typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList());
        Preconditions.checkState((actualParameters.size() == boundTypes.size() ? 1 : 0) != 0, (Object)"type lists are of different lengths");
        for (int i = 0; i < actualParameters.size(); ++i) {
            if (((Type)boundTypes.get(i)).equals(actualParameters.get(i)) || actualParameters.get(i) == UnknownType.UNKNOWN) continue;
            return false;
        }
        return true;
    }

    private boolean returnTypeIsTheSame(List<ApplicableFunction> applicableFunctions) {
        Set returnTypes = applicableFunctions.stream().map(function -> this.typeManager.getType(function.getBoundSignature().getReturnType())).collect(Collectors.toSet());
        return returnTypes.size() == 1;
    }

    private static boolean allReturnNullOnGivenInputTypes(List<ApplicableFunction> applicableFunctions, List<Type> parameters) {
        return applicableFunctions.stream().allMatch(x -> FunctionResolver.returnsNullOnGivenInputTypes(x, parameters));
    }

    private static boolean returnsNullOnGivenInputTypes(ApplicableFunction applicableFunction, List<Type> parameterTypes) {
        FunctionMetadata function = applicableFunction.getFunctionMetadata();
        if (function.getKind() != FunctionKind.SCALAR) {
            return true;
        }
        FunctionNullability functionNullability = function.getFunctionNullability();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            if (!parameterTypes.get(i).equals((Object)UnknownType.UNKNOWN) || functionNullability.isArgumentNullable(i)) continue;
            return true;
        }
        return false;
    }

    private Optional<List<Type>> toTypes(List<TypeSignatureProvider> typeSignatureProviders) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (TypeSignatureProvider typeSignatureProvider : typeSignatureProviders) {
            if (typeSignatureProvider.hasDependency()) {
                return Optional.empty();
            }
            resultBuilder.add((Object)this.typeManager.getType(typeSignatureProvider.getTypeSignature()));
        }
        return Optional.of(resultBuilder.build());
    }

    private boolean isMoreSpecificThan(Session session, ApplicableFunction left, ApplicableFunction right) {
        List<TypeSignatureProvider> resolvedTypes = TypeSignatureProvider.fromTypeSignatures(left.getBoundSignature().getArgumentTypes());
        return new SignatureBinder(session, this.metadata, this.typeManager, right.getDeclaredSignature(), true).canBind(resolvedTypes);
    }

    static class CatalogFunctionMetadata {
        private final CatalogHandle catalogHandle;
        private final FunctionMetadata functionMetadata;

        public CatalogFunctionMetadata(CatalogHandle catalogHandle, FunctionMetadata functionMetadata) {
            this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
            this.functionMetadata = Objects.requireNonNull(functionMetadata, "functionMetadata is null");
        }

        public CatalogHandle getCatalogHandle() {
            return this.catalogHandle;
        }

        public FunctionMetadata getFunctionMetadata() {
            return this.functionMetadata;
        }
    }

    static class CatalogFunctionBinding {
        private final CatalogHandle catalogHandle;
        private final FunctionBinding functionBinding;

        private CatalogFunctionBinding(CatalogHandle catalogHandle, FunctionBinding functionBinding) {
            this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
            this.functionBinding = Objects.requireNonNull(functionBinding, "functionBinding is null");
        }

        public CatalogHandle getCatalogHandle() {
            return this.catalogHandle;
        }

        public FunctionBinding getFunctionBinding() {
            return this.functionBinding;
        }
    }

    private static class ApplicableFunction {
        private final CatalogFunctionMetadata function;
        private final Signature boundSignature;

        private ApplicableFunction(CatalogFunctionMetadata function, Signature boundSignature) {
            this.function = function;
            this.boundSignature = boundSignature;
        }

        public CatalogFunctionMetadata getFunction() {
            return this.function;
        }

        public FunctionMetadata getFunctionMetadata() {
            return this.function.getFunctionMetadata();
        }

        public Signature getDeclaredSignature() {
            return this.function.getFunctionMetadata().getSignature();
        }

        public Signature getBoundSignature() {
            return this.boundSignature;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("declaredSignature", (Object)this.function.getFunctionMetadata().getSignature()).add("boundSignature", (Object)this.boundSignature).toString();
        }
    }
}

