/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import io.trino.server.PluginClassLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public final class HandleResolver {
    private final Map<String, ClassLoader> classLoaders = new ConcurrentHashMap<String, ClassLoader>();

    @Inject
    public HandleResolver() {
        this.classLoaders.put("system", this.getClass().getClassLoader());
    }

    public void registerClassLoader(PluginClassLoader classLoader) {
        ClassLoader existingClassLoader = this.classLoaders.putIfAbsent(classLoader.getId(), classLoader);
        Preconditions.checkState((existingClassLoader == null ? 1 : 0) != 0, (String)"Class loader already registered: %s", (Object)classLoader.getId());
    }

    public void unregisterClassLoader(PluginClassLoader classLoader) {
        boolean result = this.classLoaders.remove(classLoader.getId(), classLoader);
        Preconditions.checkState((boolean)result, (String)"Class loader not registered: %s", (Object)classLoader.getId());
    }

    public String getId(Object tableHandle) {
        Class<?> handleClass = tableHandle.getClass();
        return HandleResolver.classId(handleClass);
    }

    public Class<?> getHandleClass(String id) {
        int splitPoint = id.lastIndexOf(58);
        Preconditions.checkArgument((splitPoint > 1 ? 1 : 0) != 0, (String)"Invalid handle id: %s", (Object)id);
        String classLoaderId = id.substring(0, splitPoint);
        String className = id.substring(splitPoint + 1);
        ClassLoader classLoader = this.classLoaders.get(classLoaderId);
        Preconditions.checkArgument((classLoader != null ? 1 : 0) != 0, (String)"Unknown handle id: %s", (Object)id);
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ignored) {
            throw new IllegalArgumentException("Handle ID not found: " + id);
        }
    }

    private static String classId(Class<?> handleClass) {
        return HandleResolver.classLoaderId(handleClass) + ":" + handleClass.getName();
    }

    private static String classLoaderId(Class<?> handleClass) {
        ClassLoader classLoader = handleClass.getClassLoader();
        if (classLoader instanceof PluginClassLoader) {
            return ((PluginClassLoader)classLoader).getId();
        }
        Preconditions.checkArgument((classLoader == HandleResolver.class.getClassLoader() ? 1 : 0) != 0, (String)"Handle [%s] has unknown class loader [%s]", (Object)handleClass.getName(), (Object)classLoader.getClass().getName());
        return "system";
    }
}

