/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.PolymorphicScalarFunctionBuilder;
import io.trino.metadata.SignatureBinder;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class PolymorphicScalarFunction
extends SqlScalarFunction {
    private final List<PolymorphicScalarFunctionChoice> choices;

    PolymorphicScalarFunction(FunctionMetadata functionMetadata, List<PolymorphicScalarFunctionChoice> choices) {
        super(functionMetadata);
        this.choices = Objects.requireNonNull(choices, "choices is null");
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        ImmutableList.Builder implementationChoices = ImmutableList.builder();
        FunctionMetadata metadata = this.getFunctionMetadata();
        FunctionBinding functionBinding = SignatureBinder.bindFunction(metadata.getFunctionId(), metadata.getSignature(), boundSignature);
        for (PolymorphicScalarFunctionChoice choice : this.choices) {
            implementationChoices.add((Object)this.getScalarFunctionImplementationChoice(functionBinding, choice));
        }
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, (List<ChoicesSpecializedSqlScalarFunction.ScalarImplementationChoice>)implementationChoices.build());
    }

    private ChoicesSpecializedSqlScalarFunction.ScalarImplementationChoice getScalarFunctionImplementationChoice(FunctionBinding functionBinding, PolymorphicScalarFunctionChoice choice) {
        PolymorphicScalarFunctionBuilder.SpecializeContext context = new PolymorphicScalarFunctionBuilder.SpecializeContext(functionBinding);
        Optional<Object> matchingMethod = Optional.empty();
        Optional<Object> matchingMethodsGroup = Optional.empty();
        for (PolymorphicScalarFunctionBuilder.MethodsGroup candidateMethodsGroup : choice.getMethodsGroups()) {
            for (PolymorphicScalarFunctionBuilder.MethodAndNativeContainerTypes candidateMethod : candidateMethodsGroup.getMethods()) {
                if (!PolymorphicScalarFunction.matchesParameterAndReturnTypes(candidateMethod, functionBinding.getBoundSignature(), choice.getArgumentConventions(), choice.getReturnConvention())) continue;
                if (matchingMethod.isPresent()) {
                    throw new IllegalStateException("two matching methods (" + ((PolymorphicScalarFunctionBuilder.MethodAndNativeContainerTypes)matchingMethod.get()).getMethod().getName() + " and " + candidateMethod.getMethod().getName() + ") for parameter types " + functionBinding.getBoundSignature().getArgumentTypes());
                }
                matchingMethod = Optional.of(candidateMethod);
                matchingMethodsGroup = Optional.of(candidateMethodsGroup);
            }
        }
        Preconditions.checkState((boolean)matchingMethod.isPresent(), (String)"no matching method for parameter types %s", (Object)functionBinding.getBoundSignature());
        List<Object> extraParameters = PolymorphicScalarFunction.computeExtraParameters((PolymorphicScalarFunctionBuilder.MethodsGroup)matchingMethodsGroup.get(), context);
        MethodHandle methodHandle = this.applyExtraParameters(((PolymorphicScalarFunctionBuilder.MethodAndNativeContainerTypes)matchingMethod.get()).getMethod(), extraParameters, choice.getArgumentConventions());
        return new ChoicesSpecializedSqlScalarFunction.ScalarImplementationChoice(choice.getReturnConvention(), choice.getArgumentConventions(), (List<Class<?>>)ImmutableList.of(), methodHandle, Optional.empty());
    }

    private static boolean matchesParameterAndReturnTypes(PolymorphicScalarFunctionBuilder.MethodAndNativeContainerTypes methodAndNativeContainerTypes, BoundSignature boundSignature, List<InvocationConvention.InvocationArgumentConvention> argumentConventions, InvocationConvention.InvocationReturnConvention returnConvention) {
        Method method = methodAndNativeContainerTypes.getMethod();
        Preconditions.checkState((method.getParameterCount() >= boundSignature.getArity() ? 1 : 0) != 0, (String)"method %s has not enough arguments: %s (should have at least %s)", (Object)method.getName(), (Object)method.getParameterCount(), (Object)boundSignature.getArity());
        Class<?>[] methodParameterJavaTypes = method.getParameterTypes();
        int methodParameterIndex = 0;
        for (int i = 0; i < boundSignature.getArity(); ++i) {
            Class actualType;
            Type resolvedType = boundSignature.getArgumentType(i);
            InvocationConvention.InvocationArgumentConvention argumentConvention = argumentConventions.get(i);
            Class<?> expectedType = null;
            switch (argumentConvention) {
                case NEVER_NULL: 
                case NULL_FLAG: {
                    expectedType = methodParameterJavaTypes[methodParameterIndex];
                    actualType = resolvedType.getJavaType();
                    break;
                }
                case BOXED_NULLABLE: {
                    expectedType = methodParameterJavaTypes[methodParameterIndex];
                    actualType = Primitives.wrap((Class)resolvedType.getJavaType());
                    break;
                }
                case BLOCK_POSITION: {
                    Optional<Class<?>> explicitNativeContainerTypes = methodAndNativeContainerTypes.getExplicitNativeContainerTypes().get(i);
                    if (explicitNativeContainerTypes.isPresent()) {
                        expectedType = explicitNativeContainerTypes.get();
                    }
                    actualType = resolvedType.getJavaType();
                    break;
                }
                case IN_OUT: {
                    actualType = resolvedType.getJavaType();
                    expectedType = resolvedType.getJavaType();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown argument convention: " + argumentConvention);
                }
            }
            if (!actualType.equals(expectedType)) {
                return false;
            }
            methodParameterIndex += argumentConvention.getParameterCount();
        }
        return method.getReturnType().equals(PolymorphicScalarFunction.getNullAwareContainerType(boundSignature.getReturnType().getJavaType(), returnConvention));
    }

    private static List<Object> computeExtraParameters(PolymorphicScalarFunctionBuilder.MethodsGroup methodsGroup, PolymorphicScalarFunctionBuilder.SpecializeContext context) {
        return methodsGroup.getExtraParametersFunction().map(function -> (List)function.apply(context)).orElse(Collections.emptyList());
    }

    private MethodHandle applyExtraParameters(Method matchingMethod, List<Object> extraParameters, List<InvocationConvention.InvocationArgumentConvention> argumentConventions) {
        int expectedArgumentsCount = extraParameters.size() + argumentConventions.stream().mapToInt(InvocationConvention.InvocationArgumentConvention::getParameterCount).sum();
        int matchingMethodArgumentCount = matchingMethod.getParameterCount();
        Preconditions.checkState((matchingMethodArgumentCount == expectedArgumentsCount ? 1 : 0) != 0, (String)"method %s has invalid number of arguments: %s (should have %s)", (Object)matchingMethod.getName(), (Object)matchingMethodArgumentCount, (Object)expectedArgumentsCount);
        MethodHandle matchingMethodHandle = Reflection.methodHandle(matchingMethod);
        matchingMethodHandle = MethodHandles.insertArguments(matchingMethodHandle, matchingMethodArgumentCount - extraParameters.size(), extraParameters.toArray());
        return matchingMethodHandle;
    }

    private static Class<?> getNullAwareContainerType(Class<?> clazz, InvocationConvention.InvocationReturnConvention returnConvention) {
        switch (returnConvention) {
            case NULLABLE_RETURN: {
                return Primitives.wrap(clazz);
            }
            case FAIL_ON_NULL: {
                return clazz;
            }
        }
        throw new UnsupportedOperationException("Unknown return convention: " + returnConvention);
    }

    static final class PolymorphicScalarFunctionChoice {
        private final InvocationConvention.InvocationReturnConvention returnConvention;
        private final List<InvocationConvention.InvocationArgumentConvention> argumentConventions;
        private final List<PolymorphicScalarFunctionBuilder.MethodsGroup> methodsGroups;

        PolymorphicScalarFunctionChoice(InvocationConvention.InvocationReturnConvention returnConvention, List<InvocationConvention.InvocationArgumentConvention> argumentConventions, List<PolymorphicScalarFunctionBuilder.MethodsGroup> methodsGroups) {
            this.returnConvention = Objects.requireNonNull(returnConvention, "returnConvention is null");
            this.argumentConventions = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentConventions, "argumentConventions is null"));
            this.methodsGroups = ImmutableList.copyOf((Collection)Objects.requireNonNull(methodsGroups, "methodsGroups is null"));
        }

        InvocationConvention.InvocationReturnConvention getReturnConvention() {
            return this.returnConvention;
        }

        List<PolymorphicScalarFunctionBuilder.MethodsGroup> getMethodsGroups() {
            return this.methodsGroups;
        }

        List<InvocationConvention.InvocationArgumentConvention> getArgumentConventions() {
            return this.argumentConventions;
        }
    }
}

