/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.OperatorNameUtil;
import io.trino.metadata.PolymorphicScalarFunction;
import io.trino.metadata.SqlScalarFunction;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.Signature;
import io.trino.spi.type.Type;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class PolymorphicScalarFunctionBuilder {
    private final Class<?> clazz;
    private Signature signature;
    private boolean nullableResult;
    private List<Boolean> argumentNullability;
    private String description;
    private Optional<Boolean> hidden = Optional.empty();
    private Boolean deterministic;
    private final List<PolymorphicScalarFunction.PolymorphicScalarFunctionChoice> choices = new ArrayList<PolymorphicScalarFunction.PolymorphicScalarFunctionChoice>();

    public PolymorphicScalarFunctionBuilder(Class<?> clazz) {
        this.clazz = Objects.requireNonNull(clazz, "clazz is null");
    }

    public PolymorphicScalarFunctionBuilder signature(Signature signature) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.hidden = Optional.of(this.hidden.orElseGet(() -> PolymorphicScalarFunctionBuilder.isOperator(signature)));
        return this;
    }

    public PolymorphicScalarFunctionBuilder nullableResult(boolean nullableResult) {
        this.nullableResult = nullableResult;
        return this;
    }

    public PolymorphicScalarFunctionBuilder argumentNullability(boolean ... argumentNullability) {
        Objects.requireNonNull(argumentNullability, "argumentNullability is null");
        Preconditions.checkState((this.argumentNullability == null ? 1 : 0) != 0, (Object)"The argumentNullability method must be invoked only once, and must be invoked before the choice method");
        this.argumentNullability = ImmutableList.copyOf((Collection)Booleans.asList((boolean[])argumentNullability));
        return this;
    }

    public PolymorphicScalarFunctionBuilder description(String description) {
        this.description = description;
        return this;
    }

    public PolymorphicScalarFunctionBuilder hidden(boolean hidden) {
        this.hidden = Optional.of(hidden);
        return this;
    }

    public PolymorphicScalarFunctionBuilder deterministic(boolean deterministic) {
        this.deterministic = deterministic;
        return this;
    }

    public PolymorphicScalarFunctionBuilder choice(Function<ChoiceBuilder, ChoiceBuilder> choiceSpecification) {
        if (this.argumentNullability == null) {
            this.argumentNullability = Collections.nCopies(this.signature.getArgumentTypes().size(), false);
        }
        ChoiceBuilder choiceBuilder = new ChoiceBuilder(this.clazz, this.signature);
        choiceBuilder = choiceSpecification.apply(choiceBuilder);
        this.choices.add(choiceBuilder.build());
        return this;
    }

    public SqlScalarFunction build() {
        Preconditions.checkState((this.signature != null ? 1 : 0) != 0, (Object)"signature is null");
        Preconditions.checkState((this.deterministic != null ? 1 : 0) != 0, (Object)"deterministic is null");
        Preconditions.checkState((this.argumentNullability != null ? 1 : 0) != 0, (Object)"argumentNullability is null");
        FunctionMetadata.Builder functionMetadata = FunctionMetadata.scalarBuilder().signature(this.signature);
        if (this.description != null) {
            functionMetadata.description(this.description);
        } else {
            functionMetadata.noDescription();
        }
        if (this.hidden.orElse(false).booleanValue()) {
            functionMetadata.hidden();
        }
        if (!this.deterministic.booleanValue()) {
            functionMetadata.nondeterministic();
        }
        if (this.nullableResult) {
            functionMetadata.nullable();
        }
        functionMetadata.argumentNullability(this.argumentNullability);
        return new PolymorphicScalarFunction(functionMetadata.build(), this.choices);
    }

    @SafeVarargs
    public static Function<SpecializeContext, List<Object>> concat(Function<SpecializeContext, List<Object>> ... extraParametersFunctions) {
        return context -> {
            ImmutableList.Builder extraParametersBuilder = ImmutableList.builder();
            for (Function extraParametersFunction : extraParametersFunctions) {
                extraParametersBuilder.addAll((Iterable)extraParametersFunction.apply(context));
            }
            return extraParametersBuilder.build();
        };
    }

    public static <T> Function<SpecializeContext, List<Object>> constant(T value) {
        return context -> ImmutableList.of((Object)value);
    }

    private static boolean isOperator(Signature signature) {
        for (OperatorType operator : OperatorType.values()) {
            if (!signature.getName().equals(OperatorNameUtil.mangleOperatorName(operator))) continue;
            return true;
        }
        return false;
    }

    public static class ChoiceBuilder {
        private final Class<?> clazz;
        private final Signature signature;
        private InvocationConvention.InvocationReturnConvention returnConvention = InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL;
        private List<InvocationConvention.InvocationArgumentConvention> argumentConventions;
        private final ImmutableList.Builder<MethodsGroup> methodsGroups = ImmutableList.builder();

        private ChoiceBuilder(Class<?> clazz, Signature signature) {
            this.clazz = Objects.requireNonNull(clazz, "clazz is null");
            this.signature = Objects.requireNonNull(signature, "signature is null");
        }

        public ChoiceBuilder implementation(Function<MethodsGroupBuilder, MethodsGroupBuilder> methodsGroupSpecification) {
            if (this.argumentConventions == null) {
                this.argumentConventions = Collections.nCopies(this.signature.getArgumentTypes().size(), InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
            }
            MethodsGroupBuilder methodsGroupBuilder = new MethodsGroupBuilder(this.clazz, this.signature, this.argumentConventions);
            methodsGroupBuilder = methodsGroupSpecification.apply(methodsGroupBuilder);
            this.methodsGroups.add((Object)methodsGroupBuilder.build());
            return this;
        }

        public ChoiceBuilder returnConvention(InvocationConvention.InvocationReturnConvention returnConvention) {
            this.returnConvention = Objects.requireNonNull(returnConvention, "returnConvention is null");
            return this;
        }

        public ChoiceBuilder argumentProperties(InvocationConvention.InvocationArgumentConvention ... argumentConventions) {
            Objects.requireNonNull(argumentConventions, "argumentConventions is null");
            Preconditions.checkState((this.argumentConventions == null ? 1 : 0) != 0, (Object)"The `argumentConventions` method must be invoked only once, and must be invoked before the `implementation` method");
            this.argumentConventions = ImmutableList.copyOf((Object[])argumentConventions);
            return this;
        }

        public PolymorphicScalarFunction.PolymorphicScalarFunctionChoice build() {
            return new PolymorphicScalarFunction.PolymorphicScalarFunctionChoice(this.returnConvention, this.argumentConventions, (List<MethodsGroup>)this.methodsGroups.build());
        }
    }

    static class MethodAndNativeContainerTypes {
        private final Method method;
        private final List<Optional<Class<?>>> explicitNativeContainerTypes;

        MethodAndNativeContainerTypes(Method method, List<Optional<Class<?>>> explicitNativeContainerTypes) {
            this.method = method;
            this.explicitNativeContainerTypes = explicitNativeContainerTypes;
        }

        public Method getMethod() {
            return this.method;
        }

        List<Optional<Class<?>>> getExplicitNativeContainerTypes() {
            return this.explicitNativeContainerTypes;
        }
    }

    static final class MethodsGroup {
        private final Optional<Function<SpecializeContext, List<Object>>> extraParametersFunction;
        private final List<MethodAndNativeContainerTypes> methodAndNativeContainerTypes;

        MethodsGroup(List<MethodAndNativeContainerTypes> methodAndNativeContainerTypes, Optional<Function<SpecializeContext, List<Object>>> extraParametersFunction) {
            this.methodAndNativeContainerTypes = Objects.requireNonNull(methodAndNativeContainerTypes, "methodAndNativeContainerTypes is null");
            this.extraParametersFunction = Objects.requireNonNull(extraParametersFunction, "extraParametersFunction is null");
        }

        List<MethodAndNativeContainerTypes> getMethods() {
            return this.methodAndNativeContainerTypes;
        }

        Optional<Function<SpecializeContext, List<Object>>> getExtraParametersFunction() {
            return this.extraParametersFunction;
        }
    }

    public static class MethodsGroupBuilder {
        private final Class<?> clazz;
        private final Signature signature;
        private final List<InvocationConvention.InvocationArgumentConvention> argumentConventions;
        private final ImmutableList.Builder<MethodAndNativeContainerTypes> methodAndNativeContainerTypesList = ImmutableList.builder();
        private Optional<Function<SpecializeContext, List<Object>>> extraParametersFunction = Optional.empty();

        private MethodsGroupBuilder(Class<?> clazz, Signature signature, List<InvocationConvention.InvocationArgumentConvention> argumentConventions) {
            this.clazz = Objects.requireNonNull(clazz, "clazz is null");
            this.signature = Objects.requireNonNull(signature, "signature is null");
            this.argumentConventions = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentConventions, "argumentConventions is null"));
        }

        public MethodsGroupBuilder methods(String ... methodNames) {
            return this.methods(Arrays.asList(Objects.requireNonNull(methodNames, "methodNames is null")));
        }

        public MethodsGroupBuilder methods(List<String> methodNames) {
            Objects.requireNonNull(methodNames, "methodNames is null");
            Preconditions.checkArgument((!methodNames.isEmpty() ? 1 : 0) != 0, (Object)"methods list is empty");
            methodNames.forEach(methodName -> this.methodWithExplicitJavaTypes((String)methodName, Collections.nCopies(this.signature.getArgumentTypes().size(), Optional.empty())));
            return this;
        }

        public MethodsGroupBuilder withExtraParameters(Function<SpecializeContext, List<Object>> extraParametersFunction) {
            Preconditions.checkState((!this.methodAndNativeContainerTypesList.build().isEmpty() ? 1 : 0) != 0, (Object)"methods must be selected first");
            Objects.requireNonNull(extraParametersFunction, "extraParametersFunction is null");
            this.extraParametersFunction = Optional.of(extraParametersFunction);
            return this;
        }

        public MethodsGroupBuilder methodWithExplicitJavaTypes(String methodName, List<Optional<Class<?>>> types) {
            Objects.requireNonNull(methodName, "methodName is null");
            List matchingMethod = (List)Arrays.stream(this.clazz.getMethods()).filter(method -> methodName.equals(method.getName())).map(method -> new MethodAndNativeContainerTypes((Method)method, types)).collect(ImmutableList.toImmutableList());
            Preconditions.checkState((!matchingMethod.isEmpty() ? 1 : 0) != 0, (String)"method %s was not found in %s", (Object)methodName, this.clazz);
            Preconditions.checkState((matchingMethod.size() == 1 ? 1 : 0) != 0, (String)"multiple methods %s was not found in %s", (Object)methodName, this.clazz);
            MethodAndNativeContainerTypes methodAndNativeContainerTypes = (MethodAndNativeContainerTypes)matchingMethod.get(0);
            int argumentSize = this.signature.getArgumentTypes().size();
            Preconditions.checkState((types.size() == argumentSize ? 1 : 0) != 0, (String)"not matching number of arguments from signature: %s (should have %s)", (int)types.size(), (int)argumentSize);
            Preconditions.checkState((types.size() == this.argumentConventions.size() ? 1 : 0) != 0, (String)"not matching number of arguments from argument properties: %s (should have %s)", (int)types.size(), (int)this.argumentConventions.size());
            Iterator<InvocationConvention.InvocationArgumentConvention> argumentConventionIterator = this.argumentConventions.iterator();
            Iterator<Optional<Class<?>>> typesIterator = types.iterator();
            while (argumentConventionIterator.hasNext() && typesIterator.hasNext()) {
                Optional<Class<?>> classOptional = typesIterator.next();
                InvocationConvention.InvocationArgumentConvention argumentProperty = argumentConventionIterator.next();
                Preconditions.checkState((argumentProperty == InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION == classOptional.isPresent() ? 1 : 0) != 0, (Object)"Explicit type is not set when null convention is BLOCK_AND_POSITION");
            }
            this.methodAndNativeContainerTypesList.add((Object)methodAndNativeContainerTypes);
            return this;
        }

        public MethodsGroup build() {
            return new MethodsGroup((List<MethodAndNativeContainerTypes>)this.methodAndNativeContainerTypesList.build(), this.extraParametersFunction);
        }
    }

    public static final class SpecializeContext {
        private final FunctionBinding functionBinding;

        SpecializeContext(FunctionBinding functionBinding) {
            this.functionBinding = Objects.requireNonNull(functionBinding, "functionBinding is null");
        }

        public Type getType(String name) {
            return this.functionBinding.getTypeVariable(name);
        }

        public Long getLiteral(String name) {
            return this.functionBinding.getLongVariable(name);
        }

        public List<Type> getParameterTypes() {
            return this.functionBinding.getBoundSignature().getArgumentTypes();
        }

        public Type getReturnType() {
            return this.functionBinding.getBoundSignature().getReturnType();
        }
    }
}

