/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import io.trino.connector.CatalogServiceProvider;
import io.trino.metadata.CatalogProcedures;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class ProcedureRegistry {
    private final CatalogServiceProvider<CatalogProcedures> proceduresProvider;

    @Inject
    public ProcedureRegistry(CatalogServiceProvider<CatalogProcedures> proceduresProvider) {
        this.proceduresProvider = Objects.requireNonNull(proceduresProvider, "proceduresProvider is null");
    }

    public Procedure resolve(CatalogHandle catalogHandle, SchemaTableName name) {
        return this.proceduresProvider.getService(catalogHandle).getProcedure(name);
    }
}

