/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.Work;
import io.trino.operator.WorkProcessor;
import io.trino.operator.aggregation.AggregatorFactory;
import io.trino.operator.aggregation.builder.HashAggregationBuilder;
import io.trino.operator.aggregation.builder.InMemoryHashAggregationBuilder;
import io.trino.operator.aggregation.builder.SpillableHashAggregationBuilder;
import io.trino.operator.aggregation.partial.PartialAggregationController;
import io.trino.operator.aggregation.partial.SkipAggregationBuilder;
import io.trino.operator.scalar.CombineHashFunction;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spiller.SpillerFactory;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.type.BlockTypeOperators;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HashAggregationOperator
implements Operator {
    private static final double MERGE_WITH_MEMORY_RATIO = 0.9;
    private final OperatorContext operatorContext;
    private final Optional<PartialAggregationController> partialAggregationController;
    private final List<Type> groupByTypes;
    private final List<Integer> groupByChannels;
    private final List<Integer> globalAggregationGroupIds;
    private final AggregationNode.Step step;
    private final boolean produceDefaultOutput;
    private final List<AggregatorFactory> aggregatorFactories;
    private final Optional<Integer> hashChannel;
    private final Optional<Integer> groupIdChannel;
    private final int expectedGroups;
    private final Optional<DataSize> maxPartialMemory;
    private final boolean spillEnabled;
    private final DataSize memoryLimitForMerge;
    private final DataSize memoryLimitForMergeWithMemory;
    private final SpillerFactory spillerFactory;
    private final JoinCompiler joinCompiler;
    private final BlockTypeOperators blockTypeOperators;
    private final List<Type> types;
    private HashAggregationBuilder aggregationBuilder;
    private final LocalMemoryContext memoryContext;
    private WorkProcessor<Page> outputPages;
    private boolean inputProcessed;
    private boolean finishing;
    private boolean finished;
    private Work<?> unfinishedWork;
    private long numberOfInputRowsProcessed;
    private long numberOfUniqueRowsProduced;

    private HashAggregationOperator(OperatorContext operatorContext, List<Type> groupByTypes, List<Integer> groupByChannels, List<Integer> globalAggregationGroupIds, AggregationNode.Step step, boolean produceDefaultOutput, List<AggregatorFactory> aggregatorFactories, Optional<Integer> hashChannel, Optional<Integer> groupIdChannel, int expectedGroups, Optional<DataSize> maxPartialMemory, boolean spillEnabled, DataSize memoryLimitForMerge, DataSize memoryLimitForMergeWithMemory, SpillerFactory spillerFactory, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators, Optional<PartialAggregationController> partialAggregationController) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.partialAggregationController = Objects.requireNonNull(partialAggregationController, "partialAggregationControl is null");
        Objects.requireNonNull(step, "step is null");
        Objects.requireNonNull(aggregatorFactories, "aggregatorFactories is null");
        Objects.requireNonNull(operatorContext, "operatorContext is null");
        Preconditions.checkArgument((partialAggregationController.isEmpty() || step.isOutputPartial() ? 1 : 0) != 0, (Object)"partialAggregationController should be present only for partial aggregation");
        this.groupByTypes = ImmutableList.copyOf(groupByTypes);
        this.groupByChannels = ImmutableList.copyOf(groupByChannels);
        this.globalAggregationGroupIds = ImmutableList.copyOf(globalAggregationGroupIds);
        this.aggregatorFactories = ImmutableList.copyOf(aggregatorFactories);
        this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
        this.groupIdChannel = Objects.requireNonNull(groupIdChannel, "groupIdChannel is null");
        this.step = step;
        this.produceDefaultOutput = produceDefaultOutput;
        this.expectedGroups = expectedGroups;
        this.maxPartialMemory = Objects.requireNonNull(maxPartialMemory, "maxPartialMemory is null");
        this.types = InMemoryHashAggregationBuilder.toTypes(groupByTypes, aggregatorFactories, hashChannel);
        this.spillEnabled = spillEnabled;
        this.memoryLimitForMerge = Objects.requireNonNull(memoryLimitForMerge, "memoryLimitForMerge is null");
        this.memoryLimitForMergeWithMemory = Objects.requireNonNull(memoryLimitForMergeWithMemory, "memoryLimitForMergeWithMemory is null");
        this.spillerFactory = Objects.requireNonNull(spillerFactory, "spillerFactory is null");
        this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
        this.memoryContext = operatorContext.localUserMemoryContext();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean needsInput() {
        if (this.finishing || this.outputPages != null) {
            return false;
        }
        if (this.aggregationBuilder != null && this.aggregationBuilder.isFull()) {
            return false;
        }
        return this.unfinishedWork == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((this.unfinishedWork == null ? 1 : 0) != 0, (Object)"Operator has unfinished work");
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        this.inputProcessed = true;
        if (this.aggregationBuilder == null) {
            boolean partialAggregationDisabled = this.partialAggregationController.map(PartialAggregationController::isPartialAggregationDisabled).orElse(false);
            this.aggregationBuilder = this.step.isOutputPartial() && partialAggregationDisabled ? new SkipAggregationBuilder(this.groupByChannels, this.hashChannel, this.aggregatorFactories, this.memoryContext) : (this.step.isOutputPartial() || !this.spillEnabled || !this.isSpillable() ? new InMemoryHashAggregationBuilder(this.aggregatorFactories, this.step, this.expectedGroups, this.groupByTypes, this.groupByChannels, this.hashChannel, this.operatorContext, this.maxPartialMemory, this.joinCompiler, this.blockTypeOperators, () -> {
                this.memoryContext.setBytes(((InMemoryHashAggregationBuilder)this.aggregationBuilder).getSizeInMemory());
                if (this.step.isOutputPartial() && this.maxPartialMemory.isPresent()) {
                    return true;
                }
                return this.operatorContext.isWaitingForMemory().isDone();
            }) : new SpillableHashAggregationBuilder(this.aggregatorFactories, this.step, this.expectedGroups, this.groupByTypes, this.groupByChannels, this.hashChannel, this.operatorContext, this.memoryLimitForMerge, this.memoryLimitForMergeWithMemory, this.spillerFactory, this.joinCompiler, this.blockTypeOperators));
        } else {
            Preconditions.checkState((!this.aggregationBuilder.isFull() ? 1 : 0) != 0, (Object)"Aggregation buffer is full");
        }
        this.unfinishedWork = this.aggregationBuilder.processPage(page);
        if (this.unfinishedWork.process()) {
            this.unfinishedWork = null;
        }
        this.aggregationBuilder.updateMemory();
        this.numberOfInputRowsProcessed += (long)page.getPositionCount();
    }

    private boolean isSpillable() {
        return this.aggregatorFactories.stream().allMatch(AggregatorFactory::isSpillable);
    }

    @Override
    public ListenableFuture<Void> startMemoryRevoke() {
        if (this.aggregationBuilder != null) {
            return this.aggregationBuilder.startMemoryRevoke();
        }
        return NOT_BLOCKED;
    }

    @Override
    public void finishMemoryRevoke() {
        if (this.aggregationBuilder != null) {
            this.aggregationBuilder.finishMemoryRevoke();
        }
    }

    @Override
    public Page getOutput() {
        if (this.finished) {
            return null;
        }
        if (this.unfinishedWork != null) {
            boolean workDone = this.unfinishedWork.process();
            this.aggregationBuilder.updateMemory();
            if (!workDone) {
                return null;
            }
            this.unfinishedWork = null;
        }
        if (this.outputPages == null) {
            if (this.finishing) {
                if (!this.inputProcessed && this.produceDefaultOutput) {
                    this.finished = true;
                    return this.getGlobalAggregationOutput();
                }
                if (this.aggregationBuilder == null) {
                    this.finished = true;
                    return null;
                }
            }
            if (!(this.finishing || this.aggregationBuilder != null && this.aggregationBuilder.isFull())) {
                return null;
            }
            this.outputPages = this.aggregationBuilder.buildResult();
        }
        if (!this.outputPages.process()) {
            return null;
        }
        if (this.outputPages.isFinished()) {
            this.closeAggregationBuilder();
            return null;
        }
        Page result = this.outputPages.getResult();
        this.numberOfUniqueRowsProduced += (long)result.getPositionCount();
        return result;
    }

    @Override
    public void close() {
        this.closeAggregationBuilder();
    }

    @VisibleForTesting
    public HashAggregationBuilder getAggregationBuilder() {
        return this.aggregationBuilder;
    }

    private void closeAggregationBuilder() {
        this.outputPages = null;
        if (this.aggregationBuilder != null) {
            this.aggregationBuilder.close();
            this.aggregationBuilder = null;
        }
        this.memoryContext.setBytes(0L);
        this.partialAggregationController.ifPresent(controller -> controller.onFlush(this.numberOfInputRowsProcessed, this.numberOfUniqueRowsProduced));
        this.numberOfInputRowsProcessed = 0L;
        this.numberOfUniqueRowsProduced = 0L;
    }

    private Page getGlobalAggregationOutput() {
        PageBuilder output = new PageBuilder(this.globalAggregationGroupIds.size(), this.types);
        for (int groupId : this.globalAggregationGroupIds) {
            int channel;
            output.declarePosition();
            for (channel = 0; channel < this.groupByTypes.size(); ++channel) {
                if (channel == this.groupIdChannel.orElseThrow()) {
                    output.getBlockBuilder(channel).writeLong((long)groupId);
                    continue;
                }
                output.getBlockBuilder(channel).appendNull();
            }
            if (this.hashChannel.isPresent()) {
                long hashValue = HashAggregationOperator.calculateDefaultOutputHash(this.groupByTypes, this.groupIdChannel.orElseThrow(), groupId);
                output.getBlockBuilder(channel).writeLong(hashValue);
                ++channel;
            }
            for (AggregatorFactory aggregatorFactory : this.aggregatorFactories) {
                aggregatorFactory.createAggregator().evaluate(output.getBlockBuilder(channel));
                ++channel;
            }
        }
        if (output.isEmpty()) {
            return null;
        }
        return output.build();
    }

    private static long calculateDefaultOutputHash(List<Type> groupByChannels, int groupIdChannel, int groupId) {
        long result = 0L;
        for (int channel = 0; channel < groupByChannels.size(); ++channel) {
            result = channel != groupIdChannel ? CombineHashFunction.getHash(result, 0L) : CombineHashFunction.getHash(result, BigintType.hash((long)groupId));
        }
        return result;
    }

    public static class HashAggregationOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> groupByTypes;
        private final List<Integer> groupByChannels;
        private final List<Integer> globalAggregationGroupIds;
        private final AggregationNode.Step step;
        private final boolean produceDefaultOutput;
        private final List<AggregatorFactory> aggregatorFactories;
        private final Optional<Integer> hashChannel;
        private final Optional<Integer> groupIdChannel;
        private final int expectedGroups;
        private final Optional<DataSize> maxPartialMemory;
        private final boolean spillEnabled;
        private final DataSize memoryLimitForMerge;
        private final DataSize memoryLimitForMergeWithMemory;
        private final SpillerFactory spillerFactory;
        private final JoinCompiler joinCompiler;
        private final BlockTypeOperators blockTypeOperators;
        private final Optional<PartialAggregationController> partialAggregationController;
        private boolean closed;

        @VisibleForTesting
        public HashAggregationOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> groupByTypes, List<Integer> groupByChannels, List<Integer> globalAggregationGroupIds, AggregationNode.Step step, List<AggregatorFactory> aggregatorFactories, Optional<Integer> hashChannel, Optional<Integer> groupIdChannel, int expectedGroups, Optional<DataSize> maxPartialMemory, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators, Optional<PartialAggregationController> partialAggregationController) {
            this(operatorId, planNodeId, groupByTypes, groupByChannels, globalAggregationGroupIds, step, false, aggregatorFactories, hashChannel, groupIdChannel, expectedGroups, maxPartialMemory, false, DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (types, spillContext, memoryContext) -> {
                throw new UnsupportedOperationException();
            }, joinCompiler, blockTypeOperators, partialAggregationController);
        }

        public HashAggregationOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> groupByTypes, List<Integer> groupByChannels, List<Integer> globalAggregationGroupIds, AggregationNode.Step step, boolean produceDefaultOutput, List<AggregatorFactory> aggregatorFactories, Optional<Integer> hashChannel, Optional<Integer> groupIdChannel, int expectedGroups, Optional<DataSize> maxPartialMemory, boolean spillEnabled, DataSize unspillMemoryLimit, SpillerFactory spillerFactory, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators, Optional<PartialAggregationController> partialAggregationController) {
            this(operatorId, planNodeId, groupByTypes, groupByChannels, globalAggregationGroupIds, step, produceDefaultOutput, aggregatorFactories, hashChannel, groupIdChannel, expectedGroups, maxPartialMemory, spillEnabled, unspillMemoryLimit, DataSize.succinctBytes((long)((long)((double)unspillMemoryLimit.toBytes() * 0.9))), spillerFactory, joinCompiler, blockTypeOperators, partialAggregationController);
        }

        @VisibleForTesting
        HashAggregationOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> groupByTypes, List<Integer> groupByChannels, List<Integer> globalAggregationGroupIds, AggregationNode.Step step, boolean produceDefaultOutput, List<AggregatorFactory> aggregatorFactories, Optional<Integer> hashChannel, Optional<Integer> groupIdChannel, int expectedGroups, Optional<DataSize> maxPartialMemory, boolean spillEnabled, DataSize memoryLimitForMerge, DataSize memoryLimitForMergeWithMemory, SpillerFactory spillerFactory, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators, Optional<PartialAggregationController> partialAggregationController) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            this.groupIdChannel = Objects.requireNonNull(groupIdChannel, "groupIdChannel is null");
            this.groupByTypes = ImmutableList.copyOf(groupByTypes);
            this.groupByChannels = ImmutableList.copyOf(groupByChannels);
            this.globalAggregationGroupIds = ImmutableList.copyOf(globalAggregationGroupIds);
            this.step = step;
            this.produceDefaultOutput = produceDefaultOutput;
            this.aggregatorFactories = ImmutableList.copyOf(aggregatorFactories);
            this.expectedGroups = expectedGroups;
            this.maxPartialMemory = Objects.requireNonNull(maxPartialMemory, "maxPartialMemory is null");
            this.spillEnabled = spillEnabled;
            this.memoryLimitForMerge = Objects.requireNonNull(memoryLimitForMerge, "memoryLimitForMerge is null");
            this.memoryLimitForMergeWithMemory = Objects.requireNonNull(memoryLimitForMergeWithMemory, "memoryLimitForMergeWithMemory is null");
            this.spillerFactory = Objects.requireNonNull(spillerFactory, "spillerFactory is null");
            this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
            this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
            this.partialAggregationController = Objects.requireNonNull(partialAggregationController, "partialAggregationController is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, HashAggregationOperator.class.getSimpleName());
            HashAggregationOperator hashAggregationOperator = new HashAggregationOperator(operatorContext, this.groupByTypes, this.groupByChannels, this.globalAggregationGroupIds, this.step, this.produceDefaultOutput, this.aggregatorFactories, this.hashChannel, this.groupIdChannel, this.expectedGroups, this.maxPartialMemory, this.spillEnabled, this.memoryLimitForMerge, this.memoryLimitForMergeWithMemory, this.spillerFactory, this.joinCompiler, this.blockTypeOperators, this.partialAggregationController);
            return hashAggregationOperator;
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new HashAggregationOperatorFactory(this.operatorId, this.planNodeId, this.groupByTypes, this.groupByChannels, this.globalAggregationGroupIds, this.step, this.produceDefaultOutput, this.aggregatorFactories, this.hashChannel, this.groupIdChannel, this.expectedGroups, this.maxPartialMemory, this.spillEnabled, this.memoryLimitForMerge, this.memoryLimitForMergeWithMemory, this.spillerFactory, this.joinCompiler, this.blockTypeOperators, this.partialAggregationController.map(PartialAggregationController::duplicate));
        }
    }
}

