/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.airlift.slice.SizeOf;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.IntFunction;

public class IdRegistry<T> {
    private static final long INSTANCE_SIZE = SizeOf.instanceSize(IdRegistry.class);
    private final ObjectList<T> objects = new ObjectList();
    private final IntFIFOQueue emptySlots = new IntFIFOQueue();

    public int allocateId(IntFunction<T> factory) {
        int newId;
        if (!this.emptySlots.isEmpty()) {
            newId = this.emptySlots.dequeueInt();
            this.objects.set(newId, factory.apply(newId));
        } else {
            newId = this.objects.size();
            this.objects.add(factory.apply(newId));
        }
        return newId;
    }

    public void deallocate(int id) {
        this.objects.set(id, null);
        this.emptySlots.enqueue(id);
    }

    public T get(int id) {
        return (T)this.objects.get(id);
    }

    public long sizeOf() {
        return INSTANCE_SIZE + this.objects.sizeOf() + this.emptySlots.sizeOf();
    }

    private static class ObjectList<T>
    extends ObjectArrayList<T> {
        private static final long INSTANCE_SIZE = SizeOf.instanceSize(ObjectList.class);

        private ObjectList() {
        }

        public long sizeOf() {
            return INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.a);
        }
    }

    private static class IntFIFOQueue
    extends IntArrayFIFOQueue {
        private static final long INSTANCE_SIZE = SizeOf.instanceSize(IntFIFOQueue.class);

        private IntFIFOQueue() {
        }

        public long sizeOf() {
            return INSTANCE_SIZE + SizeOf.sizeOf((int[])this.array);
        }
    }
}

