/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.operator.WorkProcessorUtils;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public interface WorkProcessor<T> {
    public boolean process();

    public boolean isBlocked();

    public ListenableFuture<Void> getBlockedFuture();

    public boolean isFinished();

    public T getResult();

    default public WorkProcessor<T> yielding(BooleanSupplier yieldSignal) {
        return WorkProcessorUtils.yielding(this, yieldSignal);
    }

    default public WorkProcessor<T> blocking(Supplier<ListenableFuture<Void>> futureSupplier) {
        return WorkProcessorUtils.blocking(this, futureSupplier);
    }

    default public WorkProcessor<T> withProcessEntryMonitor(Runnable monitor) {
        return WorkProcessorUtils.processEntryMonitor(this, monitor);
    }

    default public WorkProcessor<T> withProcessStateMonitor(Consumer<ProcessState<T>> monitor) {
        return WorkProcessorUtils.processStateMonitor(this, monitor);
    }

    default public WorkProcessor<T> finishWhen(BooleanSupplier finishSignal) {
        return WorkProcessorUtils.finishWhen(this, finishSignal);
    }

    default public <R> WorkProcessor<R> flatMap(Function<T, WorkProcessor<R>> mapper) {
        return WorkProcessorUtils.flatMap(this, mapper);
    }

    default public <R> WorkProcessor<R> map(Function<T, R> mapper) {
        return WorkProcessorUtils.map(this, mapper);
    }

    default public <R> WorkProcessor<R> flatTransform(Transformation<T, WorkProcessor<R>> transformation) {
        return WorkProcessorUtils.flatTransform(this, transformation);
    }

    default public <R> WorkProcessor<R> transform(Transformation<T, R> transformation) {
        return WorkProcessorUtils.transform(this, transformation);
    }

    default public <R> WorkProcessor<R> transformProcessor(Function<WorkProcessor<T>, WorkProcessor<R>> transformation) {
        return transformation.apply(this);
    }

    default public Iterator<T> iterator() {
        return WorkProcessorUtils.iteratorFrom(this);
    }

    default public Iterator<Optional<T>> yieldingIterator() {
        return WorkProcessorUtils.yieldingIteratorFrom(this);
    }

    public static <T> WorkProcessor<T> flatten(WorkProcessor<WorkProcessor<T>> processor) {
        return WorkProcessorUtils.flatten(processor);
    }

    @SafeVarargs
    public static <T> WorkProcessor<T> of(T ... elements) {
        return WorkProcessor.fromIterator(Iterators.forArray((Object[])elements));
    }

    public static <T> WorkProcessor<T> fromIterable(Iterable<T> iterable) {
        return WorkProcessorUtils.fromIterator(iterable.iterator());
    }

    public static <T> WorkProcessor<T> fromIterator(Iterator<T> iterator) {
        return WorkProcessorUtils.fromIterator(iterator);
    }

    public static <T> WorkProcessor<T> create(Process<T> process) {
        return WorkProcessorUtils.create(process);
    }

    public static <T> WorkProcessor<T> mergeSorted(Iterable<WorkProcessor<T>> processorIterable, Comparator<T> comparator) {
        return WorkProcessorUtils.mergeSorted(processorIterable, comparator);
    }

    public static interface Transformation<T, R> {
        public TransformationState<R> process(@Nullable T var1);
    }

    public static interface Process<T> {
        public ProcessState<T> process();
    }

    @Immutable
    public static final class ProcessState<T> {
        private static final ProcessState<?> YIELD_STATE = new ProcessState<Object>(Type.YIELD, null, null);
        private static final ProcessState<?> FINISHED_STATE = new ProcessState<Object>(Type.FINISHED, null, null);
        private final Type type;
        @Nullable
        private final T result;
        @Nullable
        private final ListenableFuture<Void> blocked;

        private ProcessState(Type type, @Nullable T result, @Nullable ListenableFuture<Void> blocked) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.result = result;
            this.blocked = blocked;
        }

        public static <T> ProcessState<T> blocked(ListenableFuture<Void> blocked) {
            return new ProcessState<Object>(Type.BLOCKED, null, Objects.requireNonNull(blocked, "blocked is null"));
        }

        public static <T> ProcessState<T> yielded() {
            return YIELD_STATE;
        }

        public static <T> ProcessState<T> ofResult(T result) {
            return new ProcessState<T>(Type.RESULT, Objects.requireNonNull(result, "result is null"), null);
        }

        public static <T> ProcessState<T> finished() {
            return FINISHED_STATE;
        }

        public Type getType() {
            return this.type;
        }

        @Nullable
        public T getResult() {
            return this.result;
        }

        @Nullable
        public ListenableFuture<Void> getBlocked() {
            return this.blocked;
        }

        public static enum Type {
            BLOCKED,
            YIELD,
            RESULT,
            FINISHED;

        }
    }

    @Immutable
    public static final class TransformationState<T> {
        private static final TransformationState<?> NEEDS_MORE_DATA_STATE = new TransformationState<Object>(Type.NEEDS_MORE_DATA, true, null, null);
        private static final TransformationState<?> YIELD_STATE = new TransformationState<Object>(Type.YIELD, false, null, null);
        private static final TransformationState<?> FINISHED_STATE = new TransformationState<Object>(Type.FINISHED, false, null, null);
        private final Type type;
        private final boolean needsMoreData;
        @Nullable
        private final T result;
        @Nullable
        private final ListenableFuture<Void> blocked;

        private TransformationState(Type type, boolean needsMoreData, @Nullable T result, @Nullable ListenableFuture<Void> blocked) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.needsMoreData = needsMoreData;
            this.result = result;
            this.blocked = blocked;
        }

        public static <T> TransformationState<T> needsMoreData() {
            return NEEDS_MORE_DATA_STATE;
        }

        public static <T> TransformationState<T> blocked(ListenableFuture<Void> blocked) {
            return new TransformationState<Object>(Type.BLOCKED, false, null, Objects.requireNonNull(blocked, "blocked is null"));
        }

        public static <T> TransformationState<T> yielded() {
            return YIELD_STATE;
        }

        public static <T> TransformationState<T> ofResult(T result) {
            return TransformationState.ofResult(result, true);
        }

        public static <T> TransformationState<T> ofResult(T result, boolean needsMoreData) {
            return new TransformationState<T>(Type.RESULT, needsMoreData, Objects.requireNonNull(result, "result is null"), null);
        }

        public static <T> TransformationState<T> finished() {
            return FINISHED_STATE;
        }

        Type getType() {
            return this.type;
        }

        boolean isNeedsMoreData() {
            return this.needsMoreData;
        }

        @Nullable
        T getResult() {
            return this.result;
        }

        @Nullable
        ListenableFuture<Void> getBlocked() {
            return this.blocked;
        }

        static enum Type {
            NEEDS_MORE_DATA,
            BLOCKED,
            YIELD,
            RESULT,
            FINISHED;

        }
    }
}

