/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.listagg;

import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.trino.operator.aggregation.listagg.ListaggAggregationState;
import io.trino.operator.aggregation.listagg.ListaggAggregationStateConsumer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.VarcharType;

public class SingleListaggAggregationState
implements ListaggAggregationState {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SingleListaggAggregationState.class);
    private BlockBuilder blockBuilder;
    private Slice separator;
    private boolean overflowError;
    private Slice overflowFiller;
    private boolean showOverflowEntryCount;

    public long getEstimatedSize() {
        long estimatedSize = INSTANCE_SIZE;
        if (this.blockBuilder != null) {
            estimatedSize += this.blockBuilder.getRetainedSizeInBytes();
        }
        return estimatedSize;
    }

    @Override
    public void setSeparator(Slice separator) {
        this.separator = separator;
    }

    @Override
    public Slice getSeparator() {
        return this.separator;
    }

    @Override
    public void setOverflowFiller(Slice overflowFiller) {
        this.overflowFiller = overflowFiller;
    }

    @Override
    public Slice getOverflowFiller() {
        return this.overflowFiller;
    }

    @Override
    public void setOverflowError(boolean overflowError) {
        this.overflowError = overflowError;
    }

    @Override
    public boolean isOverflowError() {
        return this.overflowError;
    }

    @Override
    public void setShowOverflowEntryCount(boolean showOverflowEntryCount) {
        this.showOverflowEntryCount = showOverflowEntryCount;
    }

    @Override
    public boolean showOverflowEntryCount() {
        return this.showOverflowEntryCount;
    }

    @Override
    public void add(Block block, int position) {
        if (this.blockBuilder == null) {
            this.blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 16);
        }
        VarcharType.VARCHAR.appendTo(block, position, this.blockBuilder);
    }

    @Override
    public void forEach(ListaggAggregationStateConsumer consumer) {
        if (this.blockBuilder == null) {
            return;
        }
        for (int i = 0; i < this.blockBuilder.getPositionCount() && consumer.accept((Block)this.blockBuilder, i); ++i) {
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.blockBuilder == null) {
            return true;
        }
        Verify.verify((this.blockBuilder.getPositionCount() != 0 ? 1 : 0) != 0);
        return false;
    }

    @Override
    public int getEntryCount() {
        if (this.blockBuilder == null) {
            return 0;
        }
        return this.blockBuilder.getPositionCount();
    }

    @Override
    public void reset() {
        this.separator = null;
        this.overflowError = false;
        this.overflowFiller = null;
        this.showOverflowEntryCount = false;
        this.blockBuilder = null;
    }
}

