/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxbyn;

import io.trino.operator.aggregation.minmaxbyn.MinByNState;
import io.trino.operator.aggregation.minmaxbyn.MinMaxByNStateFactory;
import io.trino.operator.aggregation.minmaxbyn.TypedKeyValueHeap;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.Convention;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import io.trino.util.Failures;
import java.lang.invoke.MethodHandle;
import java.util.function.Function;
import java.util.function.LongFunction;

public class MinByNStateFactory
implements AccumulatorStateFactory<MinByNState> {
    private static final long MAX_NUMBER_OF_VALUES = 10000L;
    private final LongFunction<TypedKeyValueHeap> heapFactory = n -> {
        Failures.checkCondition(n > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "third argument of min_by must be a positive integer", new Object[0]);
        Failures.checkCondition(n <= 10000L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "third argument of min_by must be less than or equal to %s; found %s", 10000L, n);
        return new TypedKeyValueHeap(true, compare, keyType, valueType, Math.toIntExact(n));
    };
    private final Function<Block, TypedKeyValueHeap> deserializer = rowBlock -> TypedKeyValueHeap.deserialize(true, compare, keyType, valueType, rowBlock);

    public MinByNStateFactory(@OperatorDependency(operator=OperatorType.COMPARISON_UNORDERED_LAST, argumentTypes={"K", "K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compare, @TypeParameter(value="K") Type keyType, @TypeParameter(value="V") Type valueType) {
    }

    public MinByNState createSingleState() {
        return new SingleMinByNState(this.heapFactory, this.deserializer);
    }

    public MinByNState createGroupedState() {
        return new GroupedMinByNState(this.heapFactory, this.deserializer);
    }

    private static class SingleMinByNState
    extends MinMaxByNStateFactory.SingleMinMaxByNState
    implements MinByNState {
        public SingleMinByNState(LongFunction<TypedKeyValueHeap> heapFactory, Function<Block, TypedKeyValueHeap> deserializer) {
            super(heapFactory, deserializer);
        }

        public SingleMinByNState(SingleMinByNState state) {
            super(state);
        }

        @Override
        public AccumulatorState copy() {
            return new SingleMinByNState(this);
        }
    }

    private static class GroupedMinByNState
    extends MinMaxByNStateFactory.GroupedMinMaxByNState
    implements MinByNState {
        public GroupedMinByNState(LongFunction<TypedKeyValueHeap> heapFactory, Function<Block, TypedKeyValueHeap> deserializer) {
            super(heapFactory, deserializer);
        }
    }
}

