/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxn;

import io.trino.operator.aggregation.minmaxn.MaxNState;
import io.trino.operator.aggregation.minmaxn.MinMaxNStateFactory;
import io.trino.operator.aggregation.minmaxn.TypedHeap;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.Convention;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import io.trino.util.Failures;
import java.lang.invoke.MethodHandle;
import java.util.function.Function;
import java.util.function.LongFunction;

public class MaxNStateFactory
implements AccumulatorStateFactory<MaxNState> {
    private static final long MAX_NUMBER_OF_VALUES = 10000L;
    private final LongFunction<TypedHeap> heapFactory = n -> {
        Failures.checkCondition(n > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "second argument of max_n must be positive", new Object[0]);
        Failures.checkCondition(n <= 10000L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "second argument of max_n must be less than or equal to %s; found %s", 10000L, n);
        return new TypedHeap(false, compare, elementType, Math.toIntExact(n));
    };
    private final Function<Block, TypedHeap> deserializer = rowBlock -> TypedHeap.deserialize(false, compare, elementType, rowBlock);

    public MaxNStateFactory(@OperatorDependency(operator=OperatorType.COMPARISON_UNORDERED_FIRST, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compare, @TypeParameter(value="T") Type elementType) {
    }

    public MaxNState createSingleState() {
        return new SingleMaxNState(this.heapFactory, this.deserializer);
    }

    public MaxNState createGroupedState() {
        return new GroupedMaxNState(this.heapFactory, this.deserializer);
    }

    private static class SingleMaxNState
    extends MinMaxNStateFactory.SingleMinMaxNState
    implements MaxNState {
        public SingleMaxNState(LongFunction<TypedHeap> heapFactory, Function<Block, TypedHeap> deserializer) {
            super(heapFactory, deserializer);
        }

        public SingleMaxNState(SingleMaxNState state) {
            super(state);
        }

        @Override
        public AccumulatorState copy() {
            return new SingleMaxNState(this);
        }
    }

    private static class GroupedMaxNState
    extends MinMaxNStateFactory.GroupedMinMaxNState
    implements MaxNState {
        public GroupedMaxNState(LongFunction<TypedHeap> heapFactory, Function<Block, TypedHeap> deserializer) {
            super(heapFactory, deserializer);
        }
    }
}

