/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxn;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.array.ObjectBigArray;
import io.trino.operator.aggregation.minmaxn.MinMaxNState;
import io.trino.operator.aggregation.minmaxn.TypedHeap;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.GroupedAccumulatorState;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.LongFunction;

public final class MinMaxNStateFactory {
    private MinMaxNStateFactory() {
    }

    public static abstract class SingleMinMaxNState
    extends AbstractMinMaxNState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(SingleMinMaxNState.class);
        private final LongFunction<TypedHeap> heapFactory;
        private final Function<Block, TypedHeap> deserializer;
        private TypedHeap typedHeap;

        public SingleMinMaxNState(LongFunction<TypedHeap> heapFactory, Function<Block, TypedHeap> deserializer) {
            this.heapFactory = Objects.requireNonNull(heapFactory, "heapFactory is null");
            this.deserializer = Objects.requireNonNull(deserializer, "deserializer is null");
        }

        protected SingleMinMaxNState(SingleMinMaxNState state) {
            this.heapFactory = state.heapFactory;
            this.deserializer = state.deserializer;
            this.typedHeap = state.typedHeap != null ? state.typedHeap.copy() : null;
        }

        public abstract AccumulatorState copy();

        public final long getEstimatedSize() {
            return (long)INSTANCE_SIZE + (this.typedHeap == null ? 0L : this.typedHeap.getEstimatedSize());
        }

        @Override
        public final void initialize(long n) {
            if (this.typedHeap == null) {
                this.typedHeap = this.heapFactory.apply(n);
            }
        }

        @Override
        public final void add(Block block, int position) {
            this.typedHeap.add(block, position);
        }

        @Override
        public final void merge(MinMaxNState other) {
            TypedHeap otherTypedHeap = ((AbstractMinMaxNState)other).getTypedHeap();
            if (otherTypedHeap == null) {
                return;
            }
            if (this.typedHeap == null) {
                this.typedHeap = otherTypedHeap;
            } else {
                this.typedHeap.addAll(otherTypedHeap);
            }
        }

        @Override
        public final void writeAll(BlockBuilder out) {
            if (this.typedHeap == null || this.typedHeap.isEmpty()) {
                out.appendNull();
                return;
            }
            BlockBuilder arrayBlockBuilder = out.beginBlockEntry();
            this.typedHeap.writeAll(arrayBlockBuilder);
            out.closeEntry();
        }

        @Override
        public final void serialize(BlockBuilder out) {
            if (this.typedHeap == null) {
                out.appendNull();
            } else {
                this.typedHeap.serialize(out);
            }
        }

        @Override
        public final void deserialize(Block rowBlock) {
            this.typedHeap = this.deserializer.apply(rowBlock);
        }

        @Override
        final TypedHeap getTypedHeap() {
            return this.typedHeap;
        }
    }

    public static abstract class GroupedMinMaxNState
    extends AbstractMinMaxNState
    implements GroupedAccumulatorState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(GroupedMinMaxNState.class);
        private final LongFunction<TypedHeap> heapFactory;
        private final Function<Block, TypedHeap> deserializer;
        private final ObjectBigArray<TypedHeap> heaps = new ObjectBigArray();
        private long groupId;
        private long size;

        public GroupedMinMaxNState(LongFunction<TypedHeap> heapFactory, Function<Block, TypedHeap> deserializer) {
            this.heapFactory = heapFactory;
            this.deserializer = deserializer;
        }

        public final void setGroupId(long groupId) {
            this.groupId = groupId;
        }

        public final void ensureCapacity(long size) {
            this.heaps.ensureCapacity(size);
        }

        public final long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.heaps.sizeOf() + this.size;
        }

        @Override
        public final void initialize(long n) {
            if (this.getTypedHeap() == null) {
                TypedHeap typedHeap = this.heapFactory.apply(n);
                this.setTypedHeap(typedHeap);
                this.size += typedHeap.getEstimatedSize();
            }
        }

        @Override
        public final void add(Block block, int position) {
            TypedHeap typedHeap = this.getTypedHeap();
            this.size -= typedHeap.getEstimatedSize();
            typedHeap.add(block, position);
            this.size += typedHeap.getEstimatedSize();
        }

        @Override
        public final void merge(MinMaxNState other) {
            TypedHeap otherTypedHeap = ((AbstractMinMaxNState)other).getTypedHeap();
            if (otherTypedHeap == null) {
                return;
            }
            TypedHeap typedHeap = this.getTypedHeap();
            if (typedHeap == null) {
                this.setTypedHeap(otherTypedHeap);
                this.size += otherTypedHeap.getEstimatedSize();
            } else {
                this.size -= typedHeap.getEstimatedSize();
                typedHeap.addAll(otherTypedHeap);
                this.size += typedHeap.getEstimatedSize();
            }
        }

        @Override
        public final void writeAll(BlockBuilder out) {
            TypedHeap typedHeap = this.getTypedHeap();
            if (typedHeap == null || typedHeap.isEmpty()) {
                out.appendNull();
                return;
            }
            BlockBuilder arrayBlockBuilder = out.beginBlockEntry();
            typedHeap.writeAll(arrayBlockBuilder);
            out.closeEntry();
        }

        @Override
        public final void serialize(BlockBuilder out) {
            TypedHeap typedHeap = this.getTypedHeap();
            if (typedHeap == null) {
                out.appendNull();
            } else {
                typedHeap.serialize(out);
            }
        }

        @Override
        public final void deserialize(Block rowBlock) {
            Preconditions.checkState((this.getTypedHeap() == null ? 1 : 0) != 0, (Object)"State already initialized");
            TypedHeap typedHeap = this.deserializer.apply(rowBlock);
            this.setTypedHeap(typedHeap);
            this.size += typedHeap.getEstimatedSize();
        }

        @Override
        final TypedHeap getTypedHeap() {
            return (TypedHeap)this.heaps.get(this.groupId);
        }

        private void setTypedHeap(TypedHeap value) {
            this.heaps.set(this.groupId, (Object)value);
        }
    }

    private static abstract class AbstractMinMaxNState
    implements MinMaxNState {
        private AbstractMinMaxNState() {
        }

        abstract TypedHeap getTypedHeap();
    }
}

