/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.partial;

public class PartialAggregationController {
    private final long minNumberOfRowsProcessed;
    private final double uniqueRowsRatioThreshold;
    private volatile boolean partialAggregationDisabled;
    private long totalRowProcessed;
    private long totalUniqueRowsProduced;

    public PartialAggregationController(long minNumberOfRowsProcessedToDisable, double uniqueRowsRatioThreshold) {
        this.minNumberOfRowsProcessed = minNumberOfRowsProcessedToDisable;
        this.uniqueRowsRatioThreshold = uniqueRowsRatioThreshold;
    }

    public boolean isPartialAggregationDisabled() {
        return this.partialAggregationDisabled;
    }

    public synchronized void onFlush(long rowsProcessed, long uniqueRowsProduced) {
        if (this.partialAggregationDisabled) {
            return;
        }
        this.totalRowProcessed += rowsProcessed;
        this.totalUniqueRowsProduced += uniqueRowsProduced;
        if (this.shouldDisablePartialAggregation()) {
            this.partialAggregationDisabled = true;
        }
    }

    private boolean shouldDisablePartialAggregation() {
        return this.totalRowProcessed >= this.minNumberOfRowsProcessed && (double)this.totalUniqueRowsProduced / (double)this.totalRowProcessed > this.uniqueRowsRatioThreshold;
    }

    public PartialAggregationController duplicate() {
        return new PartialAggregationController(this.minNumberOfRowsProcessed, this.uniqueRowsRatioThreshold);
    }
}

