/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.exchange;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.exchange.LocalExchange;
import io.trino.operator.exchange.LocalExchangeSource;
import io.trino.spi.Page;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Objects;

public class LocalExchangeSourceOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalExchangeSource source;
    private ListenableFuture<Void> isBlocked = NOT_BLOCKED;

    public LocalExchangeSourceOperator(OperatorContext operatorContext, LocalExchangeSource source) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.source = Objects.requireNonNull(source, "source is null");
        operatorContext.setInfoSupplier(source::getBufferInfo);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.source.finish();
    }

    @Override
    public boolean isFinished() {
        return this.source.isFinished();
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        if (this.isBlocked.isDone()) {
            this.isBlocked = this.source.waitForReading();
            if (this.isBlocked.isDone()) {
                this.isBlocked = NOT_BLOCKED;
            }
        }
        return this.isBlocked;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        Page page = this.source.removePage();
        if (page != null) {
            this.operatorContext.recordProcessedInput(page.getSizeInBytes(), page.getPositionCount());
        }
        return page;
    }

    @Override
    public void close() {
        this.source.close();
    }

    public static class LocalExchangeSourceOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final LocalExchange localExchange;
        private boolean closed;

        public LocalExchangeSourceOperatorFactory(int operatorId, PlanNodeId planNodeId, LocalExchange localExchange) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.localExchange = Objects.requireNonNull(localExchange, "localExchange is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, LocalExchangeSourceOperator.class.getSimpleName());
            return new LocalExchangeSourceOperator(operatorContext, this.localExchange.getNextSource(driverContext::getPhysicalWrittenDataSize));
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException("Source operator factories cannot be duplicated");
        }
    }
}

