/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.exchange;

import com.google.common.util.concurrent.ListenableFuture;
import io.trino.operator.PartitionFunction;
import io.trino.operator.exchange.LocalExchangeMemoryManager;
import io.trino.operator.exchange.LocalExchanger;
import io.trino.operator.exchange.UniformPartitionRebalancer;
import io.trino.spi.Page;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;

public class ScaleWriterPartitioningExchanger
implements LocalExchanger {
    private final List<Consumer<Page>> buffers;
    private final LocalExchangeMemoryManager memoryManager;
    private final long maxBufferedBytes;
    private final Function<Page, Page> partitionedPagePreparer;
    private final PartitionFunction partitionFunction;
    private final UniformPartitionRebalancer partitionRebalancer;
    private final IntArrayList[] writerAssignments;
    private final int[] partitionRowCounts;
    private final int[] partitionWriterIds;
    private final int[] partitionWriterIndexes;
    private final IntArrayList usedPartitions = new IntArrayList();
    private final Long2IntMap pageWriterPartitionRowCounts = new Long2IntOpenHashMap();
    @GuardedBy(value="this")
    private final Long2LongMap writerPartitionRowCounts = new Long2LongOpenHashMap();

    public ScaleWriterPartitioningExchanger(List<Consumer<Page>> buffers, LocalExchangeMemoryManager memoryManager, long maxBufferedBytes, Function<Page, Page> partitionedPagePreparer, PartitionFunction partitionFunction, int partitionCount, UniformPartitionRebalancer partitionRebalancer) {
        this.buffers = Objects.requireNonNull(buffers, "buffers is null");
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.maxBufferedBytes = maxBufferedBytes;
        this.partitionedPagePreparer = Objects.requireNonNull(partitionedPagePreparer, "partitionedPagePreparer is null");
        this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
        this.partitionRebalancer = Objects.requireNonNull(partitionRebalancer, "partitionRebalancer is null");
        this.writerAssignments = new IntArrayList[buffers.size()];
        for (int i = 0; i < this.writerAssignments.length; ++i) {
            this.writerAssignments[i] = new IntArrayList();
        }
        this.partitionRowCounts = new int[partitionCount];
        this.partitionWriterIndexes = new int[partitionCount];
        this.partitionWriterIds = new int[partitionCount];
        Arrays.fill(this.partitionWriterIds, -1);
    }

    @Override
    public void accept(Page page) {
        int writerId;
        int partitionId;
        if ((double)this.memoryManager.getBufferedBytes() > (double)this.maxBufferedBytes * 0.5) {
            this.partitionRebalancer.rebalancePartitions();
        }
        Page partitionPage = this.partitionedPagePreparer.apply(page);
        for (int position = 0; position < partitionPage.getPositionCount(); ++position) {
            int n = partitionId = this.partitionFunction.getPartition(partitionPage, position);
            this.partitionRowCounts[n] = this.partitionRowCounts[n] + 1;
            writerId = this.partitionWriterIds[partitionId];
            if (writerId == -1) {
                this.partitionWriterIds[partitionId] = writerId = this.getNextWriterId(partitionId);
                this.usedPartitions.add(partitionId);
            }
            this.writerAssignments[writerId].add(position);
        }
        IntListIterator position = this.usedPartitions.iterator();
        while (position.hasNext()) {
            partitionId = (Integer)position.next();
            writerId = this.partitionWriterIds[partitionId];
            this.pageWriterPartitionRowCounts.put(UniformPartitionRebalancer.WriterPartitionId.serialize(new UniformPartitionRebalancer.WriterPartitionId(writerId, partitionId)), this.partitionRowCounts[partitionId]);
            this.partitionRowCounts[partitionId] = 0;
            this.partitionWriterIds[partitionId] = -1;
        }
        this.updatePartitionRowCounts(this.pageWriterPartitionRowCounts);
        this.pageWriterPartitionRowCounts.clear();
        this.usedPartitions.clear();
        for (int bucket = 0; bucket < this.writerAssignments.length; ++bucket) {
            IntArrayList positionsList = this.writerAssignments[bucket];
            int bucketSize = positionsList.size();
            if (bucketSize == 0) continue;
            int[] positions = positionsList.elements();
            positionsList.clear();
            if (bucketSize == page.getPositionCount()) {
                page.compact();
                this.sendPageToPartition(this.buffers.get(bucket), page);
                return;
            }
            Page pageSplit = page.copyPositions(positions, 0, bucketSize);
            this.sendPageToPartition(this.buffers.get(bucket), pageSplit);
        }
    }

    @Override
    public ListenableFuture<Void> waitForWriting() {
        return this.memoryManager.getNotFullFuture();
    }

    public synchronized Long2LongMap getAndResetPartitionRowCounts() {
        Long2LongOpenHashMap result = new Long2LongOpenHashMap(this.writerPartitionRowCounts);
        this.writerPartitionRowCounts.clear();
        return result;
    }

    private synchronized void updatePartitionRowCounts(Long2IntMap pagePartitionRowCounts) {
        pagePartitionRowCounts.forEach((writerPartitionId, rowCount) -> this.writerPartitionRowCounts.merge(writerPartitionId.longValue(), (long)rowCount.intValue(), Long::sum));
    }

    private int getNextWriterId(int partitionId) {
        int n = partitionId;
        int n2 = this.partitionWriterIndexes[n];
        this.partitionWriterIndexes[n] = n2 + 1;
        return this.partitionRebalancer.getWriterId(partitionId, n2);
    }

    private void sendPageToPartition(Consumer<Page> buffer, Page pageSplit) {
        this.memoryManager.updateMemoryUsage(pageSplit.getRetainedSizeInBytes());
        buffer.accept(pageSplit);
    }
}

