/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join.unspilled;

import com.google.common.base.Verify;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.ProcessorContext;
import io.trino.operator.WorkProcessor;
import io.trino.operator.join.JoinStatisticsCounter;
import io.trino.operator.join.LookupJoinOperatorFactory;
import io.trino.operator.join.LookupSource;
import io.trino.operator.join.unspilled.JoinProbe;
import io.trino.operator.join.unspilled.LookupJoinPageBuilder;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public class PageJoiner
implements WorkProcessor.Transformation<Page, Page>,
Closeable {
    private final JoinProbe.JoinProbeFactory joinProbeFactory;
    private final ListenableFuture<LookupSource> lookupSourceFuture;
    private final JoinStatisticsCounter statisticsCounter;
    private final DriverYieldSignal yieldSignal;
    private final LookupJoinPageBuilder pageBuilder;
    private final boolean probeOnOuterSide;
    private final boolean outputSingleMatch;
    @Nullable
    private LookupSource lookupSource;
    @Nullable
    private JoinProbe probe;
    private long joinPosition = -1L;
    private int joinSourcePositions;
    private boolean currentProbePositionProducedRow;

    public PageJoiner(ProcessorContext processorContext, List<Type> buildOutputTypes, LookupJoinOperatorFactory.JoinType joinType, boolean outputSingleMatch, JoinProbe.JoinProbeFactory joinProbeFactory, ListenableFuture<LookupSource> lookupSource, JoinStatisticsCounter statisticsCounter) {
        Objects.requireNonNull(processorContext, "processorContext is null");
        this.joinProbeFactory = Objects.requireNonNull(joinProbeFactory, "joinProbeFactory is null");
        this.lookupSourceFuture = Objects.requireNonNull(lookupSource, "lookupSource is null");
        this.statisticsCounter = Objects.requireNonNull(statisticsCounter, "statisticsCounter is null");
        this.yieldSignal = processorContext.getDriverYieldSignal();
        this.pageBuilder = new LookupJoinPageBuilder(buildOutputTypes);
        this.outputSingleMatch = outputSingleMatch;
        this.probeOnOuterSide = joinType == LookupJoinOperatorFactory.JoinType.PROBE_OUTER || joinType == LookupJoinOperatorFactory.JoinType.FULL_OUTER;
    }

    @Override
    public void close() {
        this.pageBuilder.reset();
        MoreFutures.addSuccessCallback(this.lookupSourceFuture, LookupSource::close);
    }

    @Override
    public WorkProcessor.TransformationState<Page> process(@Nullable Page probePage) {
        boolean finishing;
        boolean bl = finishing = probePage == null;
        if (this.probe == null && finishing) {
            this.close();
            return WorkProcessor.TransformationState.finished();
        }
        if (this.lookupSource == null) {
            if (!this.lookupSourceFuture.isDone()) {
                return WorkProcessor.TransformationState.blocked(PageJoiner.asVoid(this.lookupSourceFuture));
            }
            this.lookupSource = Objects.requireNonNull((LookupSource)MoreFutures.getDone(this.lookupSourceFuture));
            this.statisticsCounter.updateLookupSourcePositions(this.lookupSource.getJoinPositionCount());
        }
        if (this.probe == null) {
            this.probe = this.joinProbeFactory.createJoinProbe(probePage, this.lookupSource);
        }
        this.processProbe(this.lookupSource);
        if (!this.probe.isFinished()) {
            if (this.pageBuilder.isFull()) {
                return WorkProcessor.TransformationState.ofResult(this.buildOutputPage(), false);
            }
            return WorkProcessor.TransformationState.yielded();
        }
        if (!this.pageBuilder.isEmpty() || finishing) {
            Page outputPage = this.buildOutputPage();
            this.probe = null;
            return WorkProcessor.TransformationState.ofResult(outputPage, !finishing);
        }
        this.probe = null;
        return WorkProcessor.TransformationState.needsMoreData();
    }

    private void processProbe(LookupSource lookupSource) {
        do {
            if (this.probe.getPosition() < 0) continue;
            if (!this.joinCurrentPosition(lookupSource, this.yieldSignal) || this.probeOnOuterSide && !this.outerJoinCurrentPosition()) break;
            this.statisticsCounter.recordProbe(this.joinSourcePositions);
        } while (this.advanceProbePosition() && !this.yieldSignal.isSet());
    }

    private boolean joinCurrentPosition(LookupSource lookupSource, DriverYieldSignal yieldSignal) {
        while (this.joinPosition >= 0L) {
            if (lookupSource.isJoinPositionEligible(this.joinPosition, this.probe.getPosition(), this.probe.getPage())) {
                this.currentProbePositionProducedRow = true;
                this.pageBuilder.appendRow(this.probe, lookupSource, this.joinPosition);
                ++this.joinSourcePositions;
            }
            this.joinPosition = this.outputSingleMatch && this.currentProbePositionProducedRow ? -1L : lookupSource.getNextJoinPosition(this.joinPosition, this.probe.getPosition(), this.probe.getPage());
            if (!yieldSignal.isSet() && !this.pageBuilder.isFull()) continue;
            return false;
        }
        return true;
    }

    private boolean outerJoinCurrentPosition() {
        if (!this.currentProbePositionProducedRow) {
            this.currentProbePositionProducedRow = true;
            this.pageBuilder.appendNullForBuild(this.probe);
            return !this.pageBuilder.isFull();
        }
        return true;
    }

    private boolean advanceProbePosition() {
        if (!this.probe.advanceNextPosition()) {
            return false;
        }
        this.joinPosition = this.probe.getCurrentJoinPosition();
        this.joinSourcePositions = 0;
        this.currentProbePositionProducedRow = false;
        return true;
    }

    private Page buildOutputPage() {
        Verify.verifyNotNull((Object)this.probe);
        Page outputPage = this.pageBuilder.build(this.probe);
        this.pageBuilder.reset();
        return outputPage;
    }

    private static <T> ListenableFuture<Void> asVoid(ListenableFuture<T> future) {
        return Futures.transform(future, v -> null, (Executor)MoreExecutors.directExecutor());
    }
}

