/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.operator.output.PositionsAppender;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public class RleAwarePositionsAppender
implements PositionsAppender {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(RleAwarePositionsAppender.class);
    private static final int NO_RLE = -1;
    private final BlockTypeOperators.BlockPositionIsDistinctFrom isDistinctFromOperator;
    private final PositionsAppender delegate;
    @Nullable
    private Block rleValue;
    private int rlePositionCount;

    public RleAwarePositionsAppender(BlockTypeOperators.BlockPositionIsDistinctFrom isDistinctFromOperator, PositionsAppender delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.isDistinctFromOperator = Objects.requireNonNull(isDistinctFromOperator, "isDistinctFromOperator is null");
    }

    @Override
    public void append(IntArrayList positions, Block source) {
        Preconditions.checkArgument((!(source instanceof RunLengthEncodedBlock) ? 1 : 0) != 0);
        this.switchToFlat();
        this.delegate.append(positions, source);
    }

    @Override
    public void appendRle(Block value, int positionCount) {
        if (positionCount == 0) {
            return;
        }
        Preconditions.checkArgument((value.getPositionCount() == 1 ? 1 : 0) != 0, (Object)"Expected value to contain a single position but has %d positions".formatted(value.getPositionCount()));
        if (this.rlePositionCount == 0) {
            this.rleValue = value;
            this.rlePositionCount = positionCount;
        } else if (this.rleValue != null) {
            if (!this.isDistinctFromOperator.isDistinctFrom(this.rleValue, 0, value, 0)) {
                this.rlePositionCount += positionCount;
                return;
            }
            this.switchToFlat();
            this.delegate.appendRle(value, positionCount);
        } else {
            this.delegate.appendRle(value, positionCount);
        }
    }

    @Override
    public void append(int position, Block value) {
        this.switchToFlat();
        this.delegate.append(position, value);
    }

    @Override
    public Block build() {
        Block result = this.rleValue != null ? RunLengthEncodedBlock.create((Block)this.rleValue, (int)this.rlePositionCount) : this.delegate.build();
        this.reset();
        return result;
    }

    private void reset() {
        this.rleValue = null;
        this.rlePositionCount = 0;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long retainedRleSize = this.rleValue != null ? this.rleValue.getRetainedSizeInBytes() : 0L;
        return (long)INSTANCE_SIZE + retainedRleSize + this.delegate.getRetainedSizeInBytes();
    }

    @Override
    public long getSizeInBytes() {
        long rleSize = this.rleValue != null ? this.rleValue.getSizeInBytes() : 0L;
        return rleSize + this.delegate.getSizeInBytes();
    }

    private void switchToFlat() {
        if (this.rleValue != null) {
            this.delegate.appendRle(this.rleValue, this.rlePositionCount);
            this.rleValue = null;
        }
        this.rlePositionCount = -1;
    }
}

