/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import io.trino.type.UnknownType;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class ArrayJoin
extends SqlScalarFunction {
    public static final ArrayJoin ARRAY_JOIN = new ArrayJoin();
    public static final ArrayJoinWithNullReplacement ARRAY_JOIN_WITH_NULL_REPLACEMENT = new ArrayJoinWithNullReplacement();
    private static final String FUNCTION_NAME = "array_join";
    private static final String DESCRIPTION = "Concatenates the elements of the given array using a delimiter and an optional string to replace nulls";
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayJoin.class, "arrayJoin", MethodHandle.class, Object.class, ConnectorSession.class, Block.class, Slice.class);
    private static final MethodHandle STATE_FACTORY = Reflection.methodHandle(ArrayJoin.class, "createState", new Class[0]);

    private ArrayJoin() {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name(FUNCTION_NAME).castableToTypeParameter("T", VarcharType.VARCHAR.getTypeSignature()).returnType((Type)VarcharType.VARCHAR).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType((Type)VarcharType.VARCHAR).build()).description(DESCRIPTION).build());
    }

    @UsedByGeneratedCode
    public static Object createState() {
        return new PageBuilder((List)ImmutableList.of((Object)VarcharType.VARCHAR));
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        return ArrayJoin.arrayJoinFunctionDependencies();
    }

    private static FunctionDependencyDeclaration arrayJoinFunctionDependencies() {
        return FunctionDependencyDeclaration.builder().addCastSignature(new TypeSignature("T", new TypeSignatureParameter[0]), VarcharType.VARCHAR.getTypeSignature()).build();
    }

    @Override
    public SpecializedSqlScalarFunction specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        return ArrayJoin.specializeArrayJoin(boundSignature, functionDependencies, METHOD_HANDLE);
    }

    private static ChoicesSpecializedSqlScalarFunction specializeArrayJoin(BoundSignature boundSignature, FunctionDependencies functionDependencies, MethodHandle methodHandle) {
        List<InvocationConvention.InvocationArgumentConvention> argumentConventions = Collections.nCopies(boundSignature.getArity(), InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
        Type type = ((ArrayType)boundSignature.getArgumentTypes().get(0)).getElementType();
        if (type instanceof UnknownType) {
            return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, argumentConventions, methodHandle.bindTo(null), Optional.of(STATE_FACTORY));
        }
        try {
            InvocationConvention convention = new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION), InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, true, false);
            MethodHandle cast = functionDependencies.getCastImplementation(type, (Type)VarcharType.VARCHAR, convention).getMethodHandle();
            if (cast.type().parameterArray()[0] != ConnectorSession.class) {
                cast = MethodHandles.dropArguments(cast, 0, new Class[]{ConnectorSession.class});
            }
            MethodHandle target = MethodHandles.insertArguments(methodHandle, 0, cast);
            return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, argumentConventions, target, Optional.of(STATE_FACTORY));
        }
        catch (TrinoException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Input type %s not supported", type), (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Slice arrayJoin(MethodHandle castFunction, Object state, ConnectorSession session, Block arrayBlock, Slice delimiter) {
        return ArrayJoin.arrayJoin(castFunction, state, session, arrayBlock, delimiter, null);
    }

    @UsedByGeneratedCode
    public static Slice arrayJoin(MethodHandle castFunction, Object state, ConnectorSession session, Block arrayBlock, Slice delimiter, Slice nullReplacement) {
        PageBuilder pageBuilder = (PageBuilder)state;
        if (pageBuilder.isFull()) {
            pageBuilder.reset();
        }
        int numElements = arrayBlock.getPositionCount();
        BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(0);
        boolean needsDelimiter = false;
        for (int i = 0; i < numElements; ++i) {
            Slice value = null;
            if (!arrayBlock.isNull(i)) {
                try {
                    value = castFunction.invokeExact(session, arrayBlock, i);
                }
                catch (Throwable throwable) {
                    blockBuilder.closeEntry();
                    pageBuilder.declarePosition();
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error casting array element to VARCHAR", throwable);
                }
            }
            if (value == null && (value = nullReplacement) == null) continue;
            if (needsDelimiter) {
                blockBuilder.writeBytes(delimiter, 0, delimiter.length());
            }
            blockBuilder.writeBytes(value, 0, value.length());
            needsDelimiter = true;
        }
        blockBuilder.closeEntry();
        pageBuilder.declarePosition();
        return VarcharType.VARCHAR.getSlice((Block)blockBuilder, blockBuilder.getPositionCount() - 1);
    }

    public static class ArrayJoinWithNullReplacement
    extends SqlScalarFunction {
        private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayJoin.class, "arrayJoin", MethodHandle.class, Object.class, ConnectorSession.class, Block.class, Slice.class, Slice.class);

        public ArrayJoinWithNullReplacement() {
            super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name(ArrayJoin.FUNCTION_NAME).typeVariable("T").returnType((Type)VarcharType.VARCHAR).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType((Type)VarcharType.VARCHAR).argumentType((Type)VarcharType.VARCHAR).build()).description(ArrayJoin.DESCRIPTION).build());
        }

        @Override
        public FunctionDependencyDeclaration getFunctionDependencies() {
            return ArrayJoin.arrayJoinFunctionDependencies();
        }

        @Override
        public SpecializedSqlScalarFunction specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
            return ArrayJoin.specializeArrayJoin(boundSignature, functionDependencies, METHOD_HANDLE);
        }
    }
}

