/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import io.airlift.slice.SizeOf;
import io.trino.operator.unnest.UnnestBlockBuilder;
import io.trino.operator.unnest.UnnestOperator;
import io.trino.operator.unnest.Unnester;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarArray;
import java.util.Objects;

public class ArrayUnnester
implements Unnester {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(ArrayUnnester.class);
    private final UnnestBlockBuilder blockBuilder = new UnnestBlockBuilder();
    private int[] arrayLengths = new int[0];
    private ColumnarArray columnarArray;

    @Override
    public int getChannelCount() {
        return 1;
    }

    @Override
    public void resetInput(Block block) {
        Objects.requireNonNull(block, "block is null");
        this.columnarArray = ColumnarArray.toColumnarArray((Block)block);
        this.blockBuilder.resetInputBlock(this.columnarArray.getElementsBlock());
        int positionCount = block.getPositionCount();
        this.arrayLengths = UnnestOperator.ensureCapacity(this.arrayLengths, positionCount, false);
        for (int i = 0; i < positionCount; ++i) {
            this.arrayLengths[i] = this.columnarArray.getLength(i);
        }
    }

    @Override
    public int[] getOutputEntriesPerPosition() {
        return this.arrayLengths;
    }

    @Override
    public Block[] buildOutputBlocks(int[] outputEntriesPerPosition, int startPosition, int inputBatchSize, int outputRowCount) {
        int unnestedLength = this.columnarArray.getOffset(startPosition + inputBatchSize) - this.columnarArray.getOffset(startPosition);
        boolean nullRequired = unnestedLength < outputRowCount;
        Block[] outputBlocks = new Block[]{nullRequired ? this.blockBuilder.buildWithNulls(outputEntriesPerPosition, startPosition, inputBatchSize, outputRowCount, this.arrayLengths) : this.blockBuilder.buildWithoutNulls(outputRowCount)};
        return outputBlocks;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.arrayLengths);
    }
}

