/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import java.util.Optional;
import javax.validation.constraints.Pattern;

public class ProtocolConfig {
    private String alternateHeaderName;
    private int preparedStatementCompressionThreshold = 2048;
    private int preparedStatementCompressionMinimalGain = 512;

    @Deprecated
    public Optional<@Pattern(regexp="[A-Za-z]+") String> getAlternateHeaderName() {
        return Optional.ofNullable(this.alternateHeaderName);
    }

    @Deprecated
    @Config(value="protocol.v1.alternate-header-name")
    @ConfigDescription(value="Alternate header name for V1 protocol")
    public ProtocolConfig setAlternateHeaderName(String alternateHeaderName) {
        this.alternateHeaderName = alternateHeaderName;
        return this;
    }

    public int getPreparedStatementCompressionThreshold() {
        return this.preparedStatementCompressionThreshold;
    }

    @Config(value="protocol.v1.prepared-statement-compression.length-threshold")
    @ConfigDescription(value="Compression is applied to prepared statements longer than the configured value")
    public ProtocolConfig setPreparedStatementCompressionThreshold(int preparedStatementCompressionThreshold) {
        this.preparedStatementCompressionThreshold = preparedStatementCompressionThreshold;
        return this;
    }

    public int getPreparedStatementCompressionMinimalGain() {
        return this.preparedStatementCompressionMinimalGain;
    }

    @Config(value="protocol.v1.prepared-statement-compression.min-gain")
    @ConfigDescription(value="Prepared statement compression is not applied if the size gain is less than the configured value")
    public ProtocolConfig setPreparedStatementCompressionMinimalGain(int preparedStatementCompressionMinimalGain) {
        this.preparedStatementCompressionMinimalGain = preparedStatementCompressionMinimalGain;
        return this;
    }
}

