/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableList;
import io.trino.connector.system.KillQueryProcedure;
import io.trino.dispatcher.DispatchManager;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryState;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlUtil;
import io.trino.server.BasicQueryInfo;
import io.trino.server.HttpRequestSessionContextFactory;
import io.trino.server.ProtocolConfig;
import io.trino.server.security.ResourceSecurity;
import io.trino.spi.QueryId;
import io.trino.spi.TrinoException;
import io.trino.spi.security.AccessDeniedException;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;

@Path(value="/v1/query")
public class QueryResource {
    private final DispatchManager dispatchManager;
    private final AccessControl accessControl;
    private final HttpRequestSessionContextFactory sessionContextFactory;
    private final Optional<String> alternateHeaderName;

    @Inject
    public QueryResource(DispatchManager dispatchManager, AccessControl accessControl, HttpRequestSessionContextFactory sessionContextFactory, ProtocolConfig protocolConfig) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sessionContextFactory = Objects.requireNonNull(sessionContextFactory, "sessionContextFactory is null");
        this.alternateHeaderName = protocolConfig.getAlternateHeaderName();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.AUTHENTICATED_USER)
    @GET
    public List<BasicQueryInfo> getAllQueryInfo(@QueryParam(value="state") String stateFilter, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        QueryState expectedState = stateFilter == null ? null : QueryState.valueOf(stateFilter.toUpperCase(Locale.ENGLISH));
        List<BasicQueryInfo> queries = this.dispatchManager.getQueries();
        queries = AccessControlUtil.filterQueries(this.sessionContextFactory.extractAuthorizedIdentity(servletRequest, httpHeaders, this.alternateHeaderName), queries, this.accessControl);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BasicQueryInfo queryInfo : queries) {
            if (stateFilter != null && queryInfo.getState() != expectedState) continue;
            builder.add((Object)queryInfo);
        }
        return builder.build();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.AUTHENTICATED_USER)
    @GET
    @Path(value="{queryId}")
    public Response getQueryInfo(@PathParam(value="queryId") QueryId queryId, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        Objects.requireNonNull(queryId, "queryId is null");
        Optional<QueryInfo> queryInfo = this.dispatchManager.getFullQueryInfo(queryId);
        if (queryInfo.isEmpty()) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
        try {
            AccessControlUtil.checkCanViewQueryOwnedBy(this.sessionContextFactory.extractAuthorizedIdentity(servletRequest, httpHeaders, this.alternateHeaderName), queryInfo.get().getSession().toIdentity(), this.accessControl);
            return Response.ok((Object)queryInfo.get()).build();
        }
        catch (AccessDeniedException e) {
            throw new ForbiddenException();
        }
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.AUTHENTICATED_USER)
    @DELETE
    @Path(value="{queryId}")
    public void cancelQuery(@PathParam(value="queryId") QueryId queryId, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        Objects.requireNonNull(queryId, "queryId is null");
        try {
            BasicQueryInfo queryInfo = this.dispatchManager.getQueryInfo(queryId);
            AccessControlUtil.checkCanKillQueryOwnedBy(this.sessionContextFactory.extractAuthorizedIdentity(servletRequest, httpHeaders, this.alternateHeaderName), queryInfo.getSession().toIdentity(), this.accessControl);
            this.dispatchManager.cancelQuery(queryId);
        }
        catch (AccessDeniedException e) {
            throw new ForbiddenException();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.AUTHENTICATED_USER)
    @PUT
    @Path(value="{queryId}/killed")
    public Response killQuery(@PathParam(value="queryId") QueryId queryId, String message, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        return this.failQuery(queryId, KillQueryProcedure.createKillQueryException(message), servletRequest, httpHeaders);
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.AUTHENTICATED_USER)
    @PUT
    @Path(value="{queryId}/preempted")
    public Response preemptQuery(@PathParam(value="queryId") QueryId queryId, String message, @Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        return this.failQuery(queryId, KillQueryProcedure.createPreemptQueryException(message), servletRequest, httpHeaders);
    }

    private Response failQuery(QueryId queryId, TrinoException queryException, HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
        Objects.requireNonNull(queryId, "queryId is null");
        try {
            BasicQueryInfo queryInfo = this.dispatchManager.getQueryInfo(queryId);
            AccessControlUtil.checkCanKillQueryOwnedBy(this.sessionContextFactory.extractAuthorizedIdentity(servletRequest, httpHeaders, this.alternateHeaderName), queryInfo.getSession().toIdentity(), this.accessControl);
            if (queryInfo.getState().isDone()) {
                return Response.status((Response.Status)Response.Status.CONFLICT).build();
            }
            this.dispatchManager.failQuery(queryId, (Throwable)queryException);
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        catch (AccessDeniedException e) {
            throw new ForbiddenException();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
    }
}

