/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.server.QueryStateInfo;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.resourcegroups.ResourceGroupState;
import io.trino.spi.resourcegroups.SchedulingPolicy;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class ResourceGroupInfo {
    private final ResourceGroupId id;
    private final ResourceGroupState state;
    private final SchedulingPolicy schedulingPolicy;
    private final int schedulingWeight;
    private final DataSize softMemoryLimit;
    private final int softConcurrencyLimit;
    private final int hardConcurrencyLimit;
    private final int maxQueuedQueries;
    private final DataSize memoryUsage;
    private final Duration cpuUsage;
    private final int numQueuedQueries;
    private final int numRunningQueries;
    private final int numEligibleSubGroups;
    private final Optional<List<ResourceGroupInfo>> subGroups;
    private final Optional<List<QueryStateInfo>> runningQueries;

    public ResourceGroupInfo(ResourceGroupId id, ResourceGroupState state, SchedulingPolicy schedulingPolicy, int schedulingWeight, DataSize softMemoryLimit, int softConcurrencyLimit, int hardConcurrencyLimit, int maxQueuedQueries, DataSize memoryUsage, Duration cpuUsage, int numQueuedQueries, int numRunningQueries, int numEligibleSubGroups, Optional<List<ResourceGroupInfo>> subGroups, Optional<List<QueryStateInfo>> runningQueries) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.state = Objects.requireNonNull(state, "state is null");
        this.schedulingPolicy = Objects.requireNonNull(schedulingPolicy, "schedulingPolicy is null");
        this.schedulingWeight = schedulingWeight;
        this.softMemoryLimit = Objects.requireNonNull(softMemoryLimit, "softMemoryLimit is null");
        this.softConcurrencyLimit = softConcurrencyLimit;
        this.hardConcurrencyLimit = hardConcurrencyLimit;
        this.maxQueuedQueries = maxQueuedQueries;
        this.memoryUsage = Objects.requireNonNull(memoryUsage, "memoryUsage is null");
        this.cpuUsage = Objects.requireNonNull(cpuUsage, "cpuUsage is null");
        this.numQueuedQueries = numQueuedQueries;
        this.numRunningQueries = numRunningQueries;
        this.numEligibleSubGroups = numEligibleSubGroups;
        this.subGroups = subGroups.map(ImmutableList::copyOf);
        this.runningQueries = runningQueries.map(ImmutableList::copyOf);
    }

    @JsonProperty
    public ResourceGroupId getId() {
        return this.id;
    }

    @JsonProperty
    public ResourceGroupState getState() {
        return this.state;
    }

    @JsonProperty
    public SchedulingPolicy getSchedulingPolicy() {
        return this.schedulingPolicy;
    }

    @JsonProperty
    public int getSchedulingWeight() {
        return this.schedulingWeight;
    }

    @JsonProperty
    public DataSize getSoftMemoryLimit() {
        return this.softMemoryLimit;
    }

    @JsonProperty
    public int getSoftConcurrencyLimit() {
        return this.softConcurrencyLimit;
    }

    @JsonProperty
    public int getHardConcurrencyLimit() {
        return this.hardConcurrencyLimit;
    }

    @JsonProperty
    public int getMaxQueuedQueries() {
        return this.maxQueuedQueries;
    }

    @JsonProperty
    public DataSize getMemoryUsage() {
        return this.memoryUsage;
    }

    @JsonProperty
    public Duration getCpuUsage() {
        return this.cpuUsage;
    }

    @JsonProperty
    public int getNumQueuedQueries() {
        return this.numQueuedQueries;
    }

    @JsonProperty
    public int getNumRunningQueries() {
        return this.numRunningQueries;
    }

    @JsonProperty
    public int getNumEligibleSubGroups() {
        return this.numEligibleSubGroups;
    }

    @JsonProperty
    public Optional<List<ResourceGroupInfo>> getSubGroups() {
        return this.subGroups;
    }

    @JsonProperty
    @Nullable
    public Optional<List<QueryStateInfo>> getRunningQueries() {
        return this.runningQueries;
    }
}

